/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

abstract class Resolver {
    final Collection<UnresolvedReference> unresolvedRefs = new ArrayList<UnresolvedReference>();
    protected final JsonReader reader;
    private static final NullClass nullReader = new NullClass();
    final Map<Class, JsonReader.JsonClassReaderBase> readerCache = new HashMap<Class, JsonReader.JsonClassReaderBase>();
    private final Collection<Object[]> prettyMaps = new ArrayList<Object[]>();
    private final boolean useMaps;
    private final Object unknownClass;
    private final boolean failOnUnknownType;
    private static final Map<String, Class> coercedTypes = new LinkedHashMap<String, Class>();
    protected final Collection<Missingfields> missingFields = new ArrayList<Missingfields>();
    Class singletonMap = Collections.singletonMap("foo", "bar").getClass();

    static {
        coercedTypes.put("java.util.Arrays$ArrayList", ArrayList.class);
        coercedTypes.put("java.util.LinkedHashMap$LinkedKeySet", LinkedHashSet.class);
        coercedTypes.put("java.util.LinkedHashMap$LinkedValues", ArrayList.class);
        coercedTypes.put("java.util.HashMap$KeySet", HashSet.class);
        coercedTypes.put("java.util.HashMap$Values", ArrayList.class);
        coercedTypes.put("java.util.TreeMap$KeySet", TreeSet.class);
        coercedTypes.put("java.util.TreeMap$Values", ArrayList.class);
        coercedTypes.put("java.util.concurrent.ConcurrentHashMap$KeySet", LinkedHashSet.class);
        coercedTypes.put("java.util.concurrent.ConcurrentHashMap$KeySetView", LinkedHashSet.class);
        coercedTypes.put("java.util.concurrent.ConcurrentHashMap$Values", ArrayList.class);
        coercedTypes.put("java.util.concurrent.ConcurrentHashMap$ValuesView", ArrayList.class);
        coercedTypes.put("java.util.concurrent.ConcurrentSkipListMap$KeySet", LinkedHashSet.class);
        coercedTypes.put("java.util.concurrent.ConcurrentSkipListMap$Values", ArrayList.class);
        coercedTypes.put("java.util.IdentityHashMap$KeySet", LinkedHashSet.class);
        coercedTypes.put("java.util.IdentityHashMap$Values", ArrayList.class);
    }

    protected Resolver(JsonReader reader) {
        this.reader = reader;
        Map<String, Object> optionalArgs = reader.getArgs();
        optionalArgs.put("OBJECT_RESOLVER", this);
        this.useMaps = Boolean.TRUE.equals(optionalArgs.get("USE_MAPS"));
        this.unknownClass = optionalArgs.containsKey("UNKNOWN_OBJECT") ? optionalArgs.get("UNKNOWN_OBJECT") : null;
        this.failOnUnknownType = Boolean.TRUE.equals(optionalArgs.get("FAIL_ON_UNKNOWN_TYPE"));
    }

    protected JsonReader getReader() {
        return this.reader;
    }

    protected Object convertMapsToObjects(JsonObject<String, Object> root) {
        ArrayDeque<JsonObject<String, Object>> stack = new ArrayDeque<JsonObject<String, Object>>();
        stack.addFirst(root);
        while (!stack.isEmpty()) {
            JsonObject jsonObj = (JsonObject)stack.removeFirst();
            if (jsonObj.isArray()) {
                this.traverseArray(stack, jsonObj);
                continue;
            }
            if (jsonObj.isCollection()) {
                this.traverseCollection(stack, jsonObj);
                continue;
            }
            if (jsonObj.isMap()) {
                this.traverseMap(stack, jsonObj);
                continue;
            }
            Object special = this.readIfMatching(jsonObj, null, stack);
            if (special != null) {
                jsonObj.target = special;
                continue;
            }
            this.traverseFields(stack, jsonObj);
        }
        return root.target;
    }

    protected abstract Object readIfMatching(Object var1, Class var2, Deque<JsonObject<String, Object>> var3);

    public abstract void traverseFields(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected abstract void traverseCollection(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected abstract void traverseArray(Deque<JsonObject<String, Object>> var1, JsonObject<String, Object> var2);

    protected void cleanup() {
        this.patchUnresolvedReferences();
        this.rehashMaps();
        this.reader.getObjectsRead().clear();
        this.unresolvedRefs.clear();
        this.prettyMaps.clear();
        this.readerCache.clear();
        this.handleMissingFields();
    }

    private void handleMissingFields() {
        JsonReader.MissingFieldHandler missingFieldHandler = this.reader.getMissingFieldHandler();
        if (missingFieldHandler != null) {
            for (Missingfields mf : this.missingFields) {
                missingFieldHandler.fieldMissing(mf.target, mf.fieldName, mf.value);
            }
        }
    }

    protected void traverseMap(Deque<JsonObject<String, Object>> stack, JsonObject<String, Object> jsonObj) {
        Resolver.convertMapToKeysItems(jsonObj);
        Object[] keys = (Object[])jsonObj.get("@keys");
        Object[] items = jsonObj.getArray();
        if (keys == null || items == null) {
            if (keys != items) {
                throw new JsonIoException("Map written where one of @keys or @items is empty");
            }
            return;
        }
        int size = keys.length;
        if (size != items.length) {
            throw new JsonIoException("Map written with @keys and @items entries of different sizes");
        }
        Object[] mapKeys = Resolver.buildCollection(stack, keys, size);
        Object[] mapValues = Resolver.buildCollection(stack, items, size);
        this.prettyMaps.add(new Object[]{jsonObj, mapKeys, mapValues});
    }

    private static Object[] buildCollection(Deque<JsonObject<String, Object>> stack, Object[] items, int size) {
        Object[] javaKeys;
        JsonObject<String, Object[]> jsonCollection = new JsonObject<String, Object[]>();
        jsonCollection.put("@items", items);
        jsonCollection.target = javaKeys = new Object[size];
        stack.addFirst(jsonCollection);
        return javaKeys;
    }

    protected static void convertMapToKeysItems(JsonObject<String, Object> map) {
        if (!map.containsKey("@keys") && !map.isReference()) {
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = iterator.next();
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            String saveType = map.getType();
            map.clear();
            map.setType(saveType);
            map.put("@keys", keys);
            map.put("@items", values);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object createJavaObjectInstance(Class clazz, JsonObject jsonObj) {
        Object mate;
        boolean useMapsLocal = this.useMaps;
        String type = jsonObj.type;
        if ("java.lang.Object".equals(type)) {
            Object value = jsonObj.get("value");
            if (jsonObj.keySet().size() == 1 && value != null) {
                type = value.getClass().getName();
            }
        }
        if (type != null) {
            Class c;
            try {
                c = MetaUtils.classForName(type, this.reader.getClassLoader(), this.failOnUnknownType);
            }
            catch (Exception e) {
                if (useMapsLocal) {
                    jsonObj.type = null;
                    jsonObj.target = null;
                    return jsonObj;
                }
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create class: " + name, e);
            }
            if (c.isArray()) {
                int size;
                Object[] items = jsonObj.getArray();
                int n = size = items == null ? 0 : items.length;
                if (c == char[].class) {
                    jsonObj.moveCharsToMate();
                    mate = jsonObj.target;
                } else {
                    mate = Array.newInstance(c.getComponentType(), size);
                }
            } else if (MetaUtils.isPrimitive(c)) {
                mate = MetaUtils.convert(c, jsonObj.get("value"));
            } else if (c == Class.class) {
                mate = MetaUtils.classForName((String)jsonObj.get("value"), this.reader.getClassLoader());
            } else if (c.isEnum()) {
                mate = this.getEnum(c, jsonObj);
            } else if (Enum.class.isAssignableFrom(c)) {
                mate = this.getEnum(c.getSuperclass(), jsonObj);
            } else if (EnumSet.class.isAssignableFrom(c)) {
                mate = this.getEnumSet(c, jsonObj);
            } else {
                mate = this.coerceCertainTypes(c.getName());
                if (mate == null) {
                    if (this.singletonMap.isAssignableFrom(c)) {
                        Object key = jsonObj.keySet().iterator().next();
                        Object value = jsonObj.values().iterator().next();
                        mate = Collections.singletonMap(key, value);
                    } else {
                        mate = Resolver.newInstance(c, jsonObj);
                    }
                }
            }
        } else {
            Object[] items = jsonObj.getArray();
            if (clazz.isArray() || items != null && clazz == Object.class && !jsonObj.containsKey("@keys")) {
                int size = items == null ? 0 : items.length;
                mate = Array.newInstance(clazz.isArray() ? clazz.getComponentType() : Object.class, size);
            } else if (clazz.isEnum()) {
                mate = this.getEnum(clazz, jsonObj);
            } else if (Enum.class.isAssignableFrom(clazz)) {
                mate = this.getEnum(clazz.getSuperclass(), jsonObj);
            } else if (EnumSet.class.isAssignableFrom(clazz)) {
                mate = this.getEnumSet(clazz, jsonObj);
            } else {
                mate = this.coerceCertainTypes(clazz.getName());
                if (mate == null) {
                    if (clazz == Object.class && !useMapsLocal) {
                        if (this.unknownClass == null) {
                            mate = new JsonObject();
                            ((JsonObject)mate).type = Map.class.getName();
                        } else {
                            if (!(this.unknownClass instanceof String)) throw new JsonIoException("Unable to determine object type at column: " + jsonObj.col + ", line: " + jsonObj.line + ", content: " + jsonObj);
                            mate = Resolver.newInstance(MetaUtils.classForName(((String)this.unknownClass).trim(), this.reader.getClassLoader()), jsonObj);
                        }
                    } else {
                        mate = Resolver.newInstance(clazz, jsonObj);
                    }
                }
            }
        }
        jsonObj.target = mate;
        return jsonObj.target;
    }

    protected Object coerceCertainTypes(String type) {
        Class clazz = coercedTypes.get(type);
        if (clazz == null) {
            return null;
        }
        return MetaUtils.newInstance(clazz);
    }

    protected JsonObject getReferencedObj(Long ref) {
        JsonObject refObject = this.reader.getObjectsRead().get(ref);
        if (refObject == null) {
            throw new JsonIoException("Forward reference @ref: " + ref + ", but no object defined (@id) with that value");
        }
        return refObject;
    }

    protected JsonReader.JsonClassReaderBase getCustomReader(Class c) {
        JsonReader.JsonClassReaderBase reader = this.readerCache.get(c);
        if (reader == null) {
            reader = this.forceGetCustomReader(c);
            this.readerCache.put(c, reader);
        }
        return reader == nullReader ? null : reader;
    }

    private JsonReader.JsonClassReaderBase forceGetCustomReader(Class c) {
        JsonReader.JsonClassReaderBase closestReader = nullReader;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry<Class, JsonReader.JsonClassReaderBase> entry : this.getReaders().entrySet()) {
            Class clz = entry.getKey();
            if (clz == c) {
                return entry.getValue();
            }
            int distance = MetaUtils.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestReader = entry.getValue();
        }
        return closestReader;
    }

    private Object getEnum(Class c, JsonObject jsonObj) {
        try {
            return Enum.valueOf(c, (String)jsonObj.get("name"));
        }
        catch (Exception exception) {
            return Enum.valueOf(c, (String)jsonObj.get("java.lang.Enum.name"));
        }
    }

    private Object getEnumSet(Class c, JsonObject<String, Object> jsonObj) {
        Object[] items = jsonObj.getArray();
        if (items == null || items.length == 0) {
            return Resolver.newInstance(c, jsonObj);
        }
        JsonObject item = (JsonObject)items[0];
        String type = item.getType();
        Class enumClass = MetaUtils.classForName(type, this.reader.getClassLoader());
        EnumSet<Enum> enumSet = null;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectItem = objectArray[n2];
            item = (JsonObject)objectItem;
            Enum enumItem = (Enum)this.getEnum(enumClass, item);
            if (enumSet == null) {
                enumSet = EnumSet.of(enumItem);
            } else {
                enumSet.add(enumItem);
            }
            ++n2;
        }
        return enumSet;
    }

    protected void patchUnresolvedReferences() {
        Iterator<UnresolvedReference> i = this.unresolvedRefs.iterator();
        while (i.hasNext()) {
            UnresolvedReference ref = i.next();
            Object objToFix = ((UnresolvedReference)ref).referencingObj.target;
            JsonObject objReferenced = this.reader.getObjectsRead().get(ref.refId);
            if (ref.index >= 0) {
                if (objToFix instanceof List) {
                    List list = (List)objToFix;
                    list.set(ref.index, objReferenced.target);
                } else if (objToFix instanceof Collection) {
                    Collection col = (Collection)objToFix;
                    col.add(objReferenced.target);
                } else {
                    Array.set(objToFix, ref.index, objReferenced.target);
                }
            } else {
                Field field = MetaUtils.getField(objToFix.getClass(), ref.field);
                if (field != null) {
                    try {
                        field.set(objToFix, objReferenced.target);
                    }
                    catch (Exception e) {
                        throw new JsonIoException("Error setting field while resolving references '" + field.getName() + "', @ref = " + ref.refId, e);
                    }
                }
            }
            i.remove();
        }
    }

    protected void rehashMaps() {
        boolean useMapsLocal = this.useMaps;
        for (Object[] mapPieces : this.prettyMaps) {
            Object[] javaValues;
            Object[] javaKeys;
            Map<Object, Object> map;
            JsonObject jObj = (JsonObject)mapPieces[0];
            if (useMapsLocal) {
                map = jObj;
                javaKeys = (Object[])jObj.remove("@keys");
                javaValues = (Object[])jObj.remove("@items");
            } else {
                map = (Map)jObj.target;
                javaKeys = (Object[])mapPieces[1];
                javaValues = (Object[])mapPieces[2];
                jObj.clear();
            }
            if (this.singletonMap.isAssignableFrom(map.getClass())) continue;
            int j = 0;
            while (javaKeys != null && j < javaKeys.length) {
                map.put(javaKeys[j], javaValues[j]);
                ++j;
            }
        }
    }

    public static Object newInstance(Class c, JsonObject jsonObject) {
        return JsonReader.newInstance(c, jsonObject);
    }

    protected Map<Class, JsonReader.JsonClassReaderBase> getReaders() {
        return this.reader.readers;
    }

    protected boolean notCustom(Class cls) {
        return this.reader.notCustom.contains(cls);
    }

    protected static class Missingfields {
        private Object target;
        private String fieldName;
        private Object value;

        public Missingfields(Object target, String fieldName, Object value) {
            this.target = target;
            this.fieldName = fieldName;
            this.value = value;
        }
    }

    private static final class NullClass
    implements JsonReader.JsonClassReaderBase {
        private NullClass() {
        }
    }

    static final class UnresolvedReference {
        private final JsonObject referencingObj;
        private String field;
        private final long refId;
        private int index = -1;

        UnresolvedReference(JsonObject referrer, String fld, long id) {
            this.referencingObj = referrer;
            this.field = fld;
            this.refId = id;
        }

        UnresolvedReference(JsonObject referrer, int idx, long id) {
            this.referencingObj = referrer;
            this.index = idx;
            this.refId = id;
        }
    }
}

