/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonWriter
implements Closeable,
Flushable {
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String TYPE = "TYPE";
    private static final Map<String, ClassMeta> _classMetaCache = new HashMap<String, ClassMeta>();
    private static final List<Object[]> _writers = new ArrayList<Object[]>();
    private static final Set<Class> _notCustom = new HashSet<Class>();
    private static Object[] _byteStrings = new Object[256];
    private final Map<Object, Long> _objVisited = new IdentityHashMap<Object, Long>();
    private final Map<Object, Long> _objsReferenced = new IdentityHashMap<Object, Long>();
    private final Writer _out;
    private long _identity = 1L;
    static final ThreadLocal<Map<String, Object>> _args = new ThreadLocal<Map<String, Object>>(){

        @Override
        public Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    static final ThreadLocal<SimpleDateFormat> _dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };

    @Deprecated
    public static String toJson(Object item) {
        throw new RuntimeException("Use com.cedarsoftware.util.JsonWriter");
    }

    @Deprecated
    public static String toJson(Object item, Map<String, Object> optionalArgs) {
        throw new RuntimeException("Use com.cedarsoftware.util.JsonWriter");
    }

    public static String objectToJson(Object item) throws IOException {
        return JsonWriter.objectToJson(item, new HashMap<String, Object>());
    }

    public static String objectToJson(Object item, Map<String, Object> optionalArgs) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter(stream, optionalArgs);
        writer.write(item);
        writer.close();
        return new String(stream.toByteArray(), "UTF-8");
    }

    public JsonWriter(OutputStream out) throws IOException {
        this(out, new HashMap<String, Object>());
    }

    public JsonWriter(OutputStream out, Map<String, Object> optionalArgs) throws IOException {
        _args.get().clear();
        _args.get().putAll(optionalArgs);
        try {
            this._out = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Unsupported encoding.  Get a JVM that supports UTF-8", e);
        }
    }

    public static int getDistance(Class a, Class b) {
        Class curr = b;
        int distance = 0;
        while (curr != a) {
            ++distance;
            if ((curr = curr.getSuperclass()) != null) continue;
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    public boolean writeIfMatching(Object o, boolean showType, Writer out) throws IOException {
        Class<?> c = o.getClass();
        if (_notCustom.contains(c)) {
            return false;
        }
        return this.writeCustom(c, o, showType, out);
    }

    public boolean writeArrayElementIfMatching(Class arrayComponentClass, Object o, boolean showType, Writer out) throws IOException {
        if (!o.getClass().isAssignableFrom(arrayComponentClass) || _notCustom.contains(o.getClass())) {
            return false;
        }
        return this.writeCustom(arrayComponentClass, o, showType, out);
    }

    private boolean writeCustom(Class arrayComponentClass, Object o, boolean showType, Writer out) throws IOException {
        JsonClassWriter closestWriter = null;
        int minDistance = Integer.MAX_VALUE;
        for (Object[] item : _writers) {
            Class clz = (Class)item[0];
            if (clz == arrayComponentClass) {
                closestWriter = (JsonClassWriter)item[1];
                break;
            }
            int distance = JsonWriter.getDistance(clz, arrayComponentClass);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestWriter = (JsonClassWriter)item[1];
        }
        if (closestWriter == null) {
            return false;
        }
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this._objsReferenced.containsKey(o);
        if (!referenced && !showType && closestWriter.hasPrimitiveForm() || closestWriter instanceof JsonStringWriter) {
            closestWriter.writePrimitiveForm(o, out);
            return true;
        }
        out.write(123);
        if (referenced) {
            this.writeId(this.getId(o));
            if (showType) {
                out.write(44);
            }
        }
        if (showType) {
            JsonWriter.writeType(o, out);
        }
        if (referenced || showType) {
            out.write(44);
        }
        closestWriter.write(o, showType || referenced, out);
        out.write(125);
        return true;
    }

    public static void addWriter(Class c, JsonClassWriter writer) {
        for (Object[] item : _writers) {
            Class clz = (Class)item[0];
            if (clz != c) continue;
            item[1] = writer;
            return;
        }
        _writers.add(new Object[]{c, writer});
    }

    public static void addNotCustomWriter(Class c) {
        _notCustom.add(c);
    }

    public void write(Object obj) throws IOException {
        this.traceReferences(obj);
        this._objVisited.clear();
        this.writeImpl(obj, true);
        this.flush();
        this._objVisited.clear();
        this._objsReferenced.clear();
        _args.get().clear();
        _args.remove();
    }

    private void traceReferences(Object root) {
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(root);
        Map<Object, Long> visited = this._objVisited;
        Map<Object, Long> referenced = this._objsReferenced;
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object obj = stack.removeFirst();
            if (obj == null) continue;
            if (!(JsonReader.isPrimitive(obj.getClass()) || obj instanceof String || obj instanceof java.util.Date)) {
                Long id = visited.get(obj);
                if (id != null) {
                    referenced.put(obj, id);
                    continue;
                }
                visited.put(obj, this._identity++);
            }
            if ((clazz = obj.getClass()).isArray()) {
                Class<?> compType = clazz.getComponentType();
                if (JsonReader.isPrimitive(compType) || compType == String.class || java.util.Date.class.isAssignableFrom(compType)) continue;
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(obj, i);
                    if (o == null) continue;
                    stack.addFirst(o);
                }
                continue;
            }
            JsonWriter.traceFields(stack, obj);
        }
    }

    private static void traceFields(LinkedList<Object> stack, Object obj) {
        ClassMeta fields = JsonWriter.getDeepDeclaredFields(obj.getClass());
        for (Field field : fields.values()) {
            try {
                Object o;
                Class<?> type = field.getType();
                if (JsonReader.isPrimitive(type) || String.class == type || java.util.Date.class.isAssignableFrom(type) || (o = field.get(obj)) == null) continue;
                stack.addFirst(o);
            }
            catch (Exception ignored) {}
        }
    }

    private boolean writeOptionalReference(Object obj) throws IOException {
        Writer out = this._out;
        if (this._objVisited.containsKey(obj)) {
            String id = this.getId(obj);
            if (id == null) {
                return false;
            }
            out.write("{\"@ref\":");
            out.write(id);
            out.write(125);
            return true;
        }
        this._objVisited.put(obj, null);
        return false;
    }

    private void writeImpl(Object obj, boolean showType) throws IOException {
        if (obj == null) {
            this._out.write("null");
            return;
        }
        if (obj.getClass().isArray()) {
            this.writeArray(obj, showType);
        } else if (obj instanceof Collection) {
            this.writeCollection((Collection)obj, showType);
        } else if (obj instanceof JsonObject) {
            JsonObject jObj = (JsonObject)obj;
            if (jObj.isArray()) {
                this.writeJsonObjectArray(jObj, showType);
            } else if (jObj.isCollection()) {
                this.writeJsonObjectCollection(jObj, showType);
            } else if (jObj.isMap()) {
                this.writeJsonObjectMap(jObj, showType);
            } else {
                this.writeJsonObjectObject(jObj, showType);
            }
        } else if (obj instanceof Map) {
            this.writeMap((Map)obj, showType);
        } else {
            this.writeObject(obj, showType);
        }
    }

    private void writeId(String id) throws IOException {
        this._out.write("\"@id\":");
        this._out.write(id == null ? "0" : id);
    }

    private static void writeType(Object obj, Writer out) throws IOException {
        out.write("\"@type\":\"");
        Class<?> c = obj.getClass();
        if (Boolean.class == c) {
            out.write("boolean");
        } else if (Byte.class == c) {
            out.write("byte");
        } else if (Short.class == c) {
            out.write("short");
        } else if (Integer.class == c) {
            out.write("int");
        } else if (Long.class == c) {
            out.write("long");
        } else if (Double.class == c) {
            out.write("double");
        } else if (Float.class == c) {
            out.write("float");
        } else if (Character.class == c) {
            out.write("char");
        } else if (java.util.Date.class == c) {
            out.write("date");
        } else if (Class.class == c) {
            out.write("class");
        } else if (String.class == c) {
            out.write("string");
        } else {
            out.write(c.getName());
        }
        out.write(34);
    }

    private void writePrimitive(Object obj) throws IOException {
        if (obj instanceof Character) {
            JsonWriter.writeJsonUtf8String(String.valueOf(obj), this._out);
        } else {
            this._out.write(obj.toString());
        }
    }

    private void writeArray(Object array, boolean showType) throws IOException {
        if (this.writeOptionalReference(array)) {
            return;
        }
        Class<?> arrayType = array.getClass();
        int len = Array.getLength(array);
        boolean referenced = this._objsReferenced.containsKey(array);
        boolean typeWritten = showType && Object[].class != arrayType;
        Writer out = this._out;
        if (typeWritten || referenced) {
            out.write(123);
        }
        if (referenced) {
            this.writeId(this.getId(array));
            out.write(44);
        }
        if (typeWritten) {
            JsonWriter.writeType(array, out);
            out.write(44);
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                out.write("\"@items\":[]}");
            } else {
                out.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            out.write("\"@items\":[");
        } else {
            out.write(91);
        }
        int lenMinus1 = len - 1;
        if (byte[].class == arrayType) {
            this.writeByteArray((byte[])array, lenMinus1);
        } else if (char[].class == arrayType) {
            JsonWriter.writeJsonUtf8String(new String((char[])array), out);
        } else if (short[].class == arrayType) {
            this.writeShortArray((short[])array, lenMinus1);
        } else if (int[].class == arrayType) {
            this.writeIntArray((int[])array, lenMinus1);
        } else if (long[].class == arrayType) {
            this.writeLongArray((long[])array, lenMinus1);
        } else if (float[].class == arrayType) {
            this.writeFloatArray((float[])array, lenMinus1);
        } else if (double[].class == arrayType) {
            this.writeDoubleArray((double[])array, lenMinus1);
        } else if (boolean[].class == arrayType) {
            this.writeBooleanArray((boolean[])array, lenMinus1);
        } else {
            Class<?> componentClass = array.getClass().getComponentType();
            boolean isPrimitiveArray = JsonReader.isPrimitive(componentClass);
            boolean isObjectArray = Object[].class == arrayType;
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(array, i);
                if (value == null) {
                    out.write("null");
                } else if (isPrimitiveArray || value instanceof Boolean || value instanceof Long || value instanceof Double) {
                    this.writePrimitive(value);
                } else if (!this.writeArrayElementIfMatching(componentClass, value, false, out)) {
                    if (isObjectArray) {
                        if (!this.writeIfMatching(value, true, out)) {
                            this.writeImpl(value, true);
                        }
                    } else {
                        boolean forceType = value.getClass() != componentClass;
                        this.writeImpl(value, forceType || this.alwaysShowType());
                    }
                }
                if (i == lenMinus1) continue;
                out.write(44);
            }
        }
        out.write(93);
        if (typeWritten || referenced) {
            out.write(125);
        }
    }

    private boolean alwaysShowType() {
        return Boolean.TRUE.equals(_args.get().get(TYPE));
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(booleans[i] ? "true," : "false,");
        }
        out.write(Boolean.toString(booleans[lenMinus1]));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(Double.toString(doubles[i]));
            out.write(44);
        }
        out.write(Double.toString(doubles[lenMinus1]));
    }

    private void writeFloatArray(float[] floats, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(Double.toString(floats[i]));
            out.write(44);
        }
        out.write(Float.toString(floats[lenMinus1]));
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(Long.toString(longs[i]));
            out.write(44);
        }
        out.write(Long.toString(longs[lenMinus1]));
    }

    private void writeIntArray(int[] ints, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(Integer.toString(ints[i]));
            out.write(44);
        }
        out.write(Integer.toString(ints[lenMinus1]));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) throws IOException {
        Writer out = this._out;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write(Integer.toString(shorts[i]));
            out.write(44);
        }
        out.write(Integer.toString(shorts[lenMinus1]));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) throws IOException {
        Writer out = this._out;
        Object[] byteStrs = _byteStrings;
        for (int i = 0; i < lenMinus1; ++i) {
            out.write((char[])byteStrs[bytes[i] + 128]);
            out.write(44);
        }
        out.write((char[])byteStrs[bytes[lenMinus1] + 128]);
    }

    private void writeCollection(Collection col, boolean showType) throws IOException {
        if (this.writeOptionalReference(col)) {
            return;
        }
        Writer out = this._out;
        boolean referenced = this._objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            out.write(123);
        } else if (isEmpty) {
            out.write(91);
        }
        if (referenced) {
            this.writeId(this.getId(col));
        }
        if (showType) {
            if (referenced) {
                out.write(44);
            }
            JsonWriter.writeType(col, out);
        }
        if (isEmpty) {
            if (referenced || showType) {
                out.write(125);
            } else {
                out.write(93);
            }
            return;
        }
        if (showType || referenced) {
            out.write(",\"@items\":[");
        } else {
            out.write(91);
        }
        Iterator i = col.iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write(93);
        if (showType || referenced) {
            out.write("}");
        }
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) throws IOException {
        boolean typeWritten;
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        int len = jObj.getLength();
        String type = jObj.type;
        Class arrayClass = type == null || Object[].class.getName().equals(type) ? Object[].class : JsonReader.classForName2(type);
        Writer out = this._out;
        boolean isObjectArray = Object[].class == arrayClass;
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this._objsReferenced.containsKey(jObj) && jObj.hasId();
        boolean bl = typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            out.write(123);
        }
        if (referenced) {
            this.writeId(Long.toString(jObj.id));
            out.write(44);
        }
        if (typeWritten) {
            out.write("\"@type\":\"");
            out.write(arrayClass.getName());
            out.write("\",");
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                out.write("\"@items\":[]}");
            } else {
                out.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            out.write("\"@items\":[");
        } else {
            out.write(91);
        }
        Object[] items = (Object[])jObj.get("@items");
        int lenMinus1 = len - 1;
        for (int i = 0; i < len; ++i) {
            Object value = items[i];
            if (value == null) {
                out.write("null");
            } else if (Character.class == componentClass || Character.TYPE == componentClass) {
                JsonWriter.writeJsonUtf8String((String)value, out);
            } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                this.writePrimitive(value);
            } else if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, out);
            } else if (isObjectArray) {
                if (!this.writeIfMatching(value, true, out)) {
                    this.writeImpl(value, true);
                }
            } else if (!this.writeArrayElementIfMatching(componentClass, value, false, out)) {
                boolean forceType = value.getClass() != componentClass;
                this.writeImpl(value, forceType || this.alwaysShowType());
            }
            if (i == lenMinus1) continue;
            out.write(44);
        }
        out.write(93);
        if (typeWritten || referenced) {
            out.write(125);
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        String type = jObj.type;
        Class colClass = JsonReader.classForName2(type);
        boolean referenced = this._objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer out = this._out;
        int len = jObj.getLength();
        if (referenced || showType || len == 0) {
            out.write(123);
        }
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                out.write(44);
            }
            out.write("\"@type\":\"");
            out.write(colClass.getName());
            out.write(34);
        }
        if (len == 0) {
            out.write(125);
            return;
        }
        if (showType || referenced) {
            out.write(",\"@items\":[");
        } else {
            out.write(91);
        }
        Object[] items = (Object[])jObj.get("@items");
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        for (int i = 0; i < itemsLen; ++i) {
            this.writeCollectionElement(items[i]);
            if (i == itemsLenMinus1) continue;
            out.write(44);
        }
        out.write("]");
        if (showType || referenced) {
            out.write(125);
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        boolean referenced = this._objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer out = this._out;
        out.write(123);
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            String type;
            if (referenced) {
                out.write(44);
            }
            if ((type = jObj.getType()) != null) {
                Class mapClass = JsonReader.classForName2(type);
                out.write("\"@type\":\"");
                out.write(mapClass.getName());
                out.write(34);
            } else {
                showType = false;
            }
        }
        if (jObj.isEmpty()) {
            out.write(125);
            return;
        }
        if (showType) {
            out.write(44);
        }
        out.write("\"@keys\":[");
        Iterator<Object> i = jObj.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write("],\"@items\":[");
        i = jObj.values().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write("]}");
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        Writer out = this._out;
        boolean referenced = this._objsReferenced.containsKey(jObj) && jObj.hasId();
        showType = showType && jObj.type != null;
        Class type = null;
        out.write(123);
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                out.write(44);
            }
            out.write("\"@type\":\"");
            out.write(jObj.type);
            out.write(34);
            try {
                type = JsonReader.classForName2(jObj.type);
            }
            catch (Exception ignored) {
                type = null;
            }
        }
        if (jObj.isEmpty()) {
            out.write(125);
            return;
        }
        if (showType || referenced) {
            out.write(44);
        }
        Iterator i = jObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String fieldName = (String)entry.getKey();
            out.write(34);
            out.write(fieldName);
            out.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                out.write("null");
            } else if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            } else if (value instanceof Number || value instanceof Boolean) {
                out.write(value.toString());
            } else if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, out);
            } else if (value instanceof Character) {
                JsonWriter.writeJsonUtf8String(String.valueOf(value), out);
            } else {
                this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            }
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write(125);
    }

    private static boolean doesValueTypeMatchFieldType(Class type, String fieldName, Object value) {
        if (type != null) {
            ClassMeta meta = JsonWriter.getDeepDeclaredFields(type);
            Field field = (Field)meta.get(fieldName);
            return field != null && value.getClass() == field.getType();
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) throws IOException {
        if (this.writeOptionalReference(map)) {
            return;
        }
        Writer out = this._out;
        boolean referenced = this._objsReferenced.containsKey(map);
        out.write(123);
        if (referenced) {
            this.writeId(this.getId(map));
        }
        if (showType) {
            if (referenced) {
                out.write(44);
            }
            JsonWriter.writeType(map, out);
        }
        if (map.isEmpty()) {
            out.write(125);
            return;
        }
        if (showType || referenced) {
            out.write(44);
        }
        out.write("\"@keys\":[");
        Iterator<Object> i = map.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write("],\"@items\":[");
        i = map.values().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            out.write(44);
        }
        out.write("]}");
    }

    private void writeCollectionElement(Object o) throws IOException {
        if (o == null) {
            this._out.write("null");
        } else if (o instanceof Boolean || o instanceof Long || o instanceof Double) {
            this._out.write(o.toString());
        } else if (o instanceof String) {
            JsonWriter.writeJsonUtf8String((String)o, this._out);
        } else {
            this.writeImpl(o, true);
        }
    }

    private void writeObject(Object obj, boolean showType) throws IOException {
        boolean first;
        if (this.writeIfMatching(obj, showType, this._out)) {
            return;
        }
        if (this.writeOptionalReference(obj)) {
            return;
        }
        Writer out = this._out;
        out.write(123);
        boolean referenced = this._objsReferenced.containsKey(obj);
        if (referenced) {
            this.writeId(this.getId(obj));
        }
        ClassMeta classInfo = JsonWriter.getDeepDeclaredFields(obj.getClass());
        if (referenced && showType) {
            out.write(44);
        }
        if (showType) {
            JsonWriter.writeType(obj, out);
        }
        boolean bl = first = !showType;
        if (referenced && !showType) {
            first = false;
        }
        for (Map.Entry entry : classInfo.entrySet()) {
            boolean forceType;
            Object o;
            Field field = (Field)entry.getValue();
            if ((field.getModifiers() & 0x80) != 0) continue;
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            JsonWriter.writeJsonUtf8String((String)entry.getKey(), out);
            out.write(58);
            try {
                o = field.get(obj);
            }
            catch (Exception ignored) {
                o = null;
            }
            if (o == null) {
                out.write("null");
                continue;
            }
            Class<?> type = field.getType();
            boolean bl2 = forceType = o.getClass() != type;
            if (JsonReader.isPrimitive(type)) {
                this.writePrimitive(o);
                continue;
            }
            if (this.writeIfMatching(o, forceType, out)) continue;
            this.writeImpl(o, forceType || this.alwaysShowType());
        }
        out.write(125);
    }

    public static void writeJsonUtf8String(String s, Writer out) throws IOException {
        out.write(34);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                if (c == '\b') {
                    out.write("\\b");
                    continue;
                }
                if (c == '\t') {
                    out.write("\\t");
                    continue;
                }
                if (c == '\n') {
                    out.write("\\n");
                    continue;
                }
                if (c == '\f') {
                    out.write("\\f");
                    continue;
                }
                if (c == '\r') {
                    out.write("\\r");
                    continue;
                }
                String hex = Integer.toHexString(c);
                out.write("\\u");
                int pad = 4 - hex.length();
                for (int k = 0; k < pad; ++k) {
                    out.write(48);
                }
                out.write(hex);
                continue;
            }
            if (c == '\\' || c == '\"') {
                out.write(92);
                out.write(c);
                continue;
            }
            out.write(c);
        }
        out.write(34);
    }

    static ClassMeta getDeepDeclaredFields(Class c) {
        ClassMeta classInfo = _classMetaCache.get(c.getName());
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = new ClassMeta();
        for (Class curr = c; curr != null; curr = curr.getSuperclass()) {
            try {
                Field[] local;
                for (Field field : local = curr.getDeclaredFields()) {
                    if ((field.getModifiers() & 8) != 0) continue;
                    if (!field.isAccessible()) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    if (classInfo.containsKey(field.getName())) {
                        classInfo.put(curr.getName() + '.' + field.getName(), field);
                        continue;
                    }
                    classInfo.put(field.getName(), field);
                }
                continue;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _classMetaCache.put(c.getName(), classInfo);
        return classInfo;
    }

    @Override
    public void flush() {
        try {
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this._out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getId(Object o) {
        long id;
        if (o instanceof JsonObject && (id = ((JsonObject)o).id) != -1L) {
            return String.valueOf(id);
        }
        Long id2 = this._objsReferenced.get(o);
        return id2 == null ? null : Long.toString(id2);
    }

    static {
        JsonWriter.addWriter(String.class, new JsonStringWriter());
        JsonWriter.addWriter(java.util.Date.class, new DateWriter());
        JsonWriter.addWriter(BigInteger.class, new BigIntegerWriter());
        JsonWriter.addWriter(BigDecimal.class, new BigDecimalWriter());
        JsonWriter.addWriter(Date.class, new DateWriter());
        JsonWriter.addWriter(Timestamp.class, new TimestampWriter());
        JsonWriter.addWriter(Calendar.class, new CalendarWriter());
        JsonWriter.addWriter(TimeZone.class, new TimeZoneWriter());
        JsonWriter.addWriter(Locale.class, new LocaleWriter());
        JsonWriter.addWriter(Class.class, new ClassWriter());
        JsonWriter.addWriter(StringBuilder.class, new StringBuilderWriter());
        JsonWriter.addWriter(StringBuffer.class, new StringBufferWriter());
        for (int i = -128; i <= 127; i = (int)((short)(i + 1))) {
            char[] chars = Integer.toString(i).toCharArray();
            JsonWriter._byteStrings[i + 128] = chars;
        }
    }

    public static class StringBufferWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            StringBuffer buffer = (StringBuffer)obj;
            out.write("\"value\":\"");
            out.write(buffer.toString());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            StringBuffer buffer = (StringBuffer)o;
            out.write(34);
            out.write(buffer.toString());
            out.write(34);
        }
    }

    public static class StringBuilderWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            StringBuilder builder = (StringBuilder)obj;
            out.write("\"value\":\"");
            out.write(builder.toString());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            StringBuilder builder = (StringBuilder)o;
            out.write(34);
            out.write(builder.toString());
            out.write(34);
        }
    }

    public static class BigDecimalWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            BigDecimal big = (BigDecimal)obj;
            out.write("\"value\":\"");
            out.write(big.toPlainString());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            BigDecimal big = (BigDecimal)o;
            out.write(34);
            out.write(big.toPlainString());
            out.write(34);
        }
    }

    public static class BigIntegerWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            BigInteger big = (BigInteger)obj;
            out.write("\"value\":\"");
            out.write(big.toString(10));
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            BigInteger big = (BigInteger)o;
            out.write(34);
            out.write(big.toString(10));
            out.write(34);
        }
    }

    public static class LocaleWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            Locale locale = (Locale)obj;
            out.write("\"language\":\"");
            out.write(locale.getLanguage());
            out.write("\",\"country\":\"");
            out.write(locale.getCountry());
            out.write("\",\"variant\":\"");
            out.write(locale.getVariant());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return false;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
        }
    }

    public static class JsonStringWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            out.write("\"value\":");
            JsonWriter.writeJsonUtf8String((String)obj, out);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            JsonWriter.writeJsonUtf8String((String)o, out);
        }
    }

    public static class ClassWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            String value = ((Class)obj).getName();
            out.write("\"value\":");
            JsonWriter.writeJsonUtf8String(value, out);
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            JsonWriter.writeJsonUtf8String(((Class)o).getName(), out);
        }
    }

    public static class TimestampWriter
    implements JsonClassWriter {
        public void write(Object o, boolean showType, Writer out) throws IOException {
            Timestamp tstamp = (Timestamp)o;
            out.write("\"time\":\"");
            out.write(Long.toString(tstamp.getTime() / 1000L * 1000L));
            out.write("\",\"nanos\":\"");
            out.write(Integer.toString(tstamp.getNanos()));
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return false;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
        }
    }

    public static class DateWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            java.util.Date date = (java.util.Date)obj;
            Object dateFormat = _args.get().get(JsonWriter.DATE_FORMAT);
            if (dateFormat instanceof String) {
                dateFormat = new SimpleDateFormat((String)dateFormat);
                _args.get().put(JsonWriter.DATE_FORMAT, dateFormat);
            }
            if (showType) {
                out.write("\"value\":");
            }
            if (dateFormat instanceof Format) {
                out.write("\"");
                out.write(((Format)dateFormat).format(date));
                out.write("\"");
            } else {
                out.write(Long.toString(((java.util.Date)obj).getTime()));
            }
        }

        public boolean hasPrimitiveForm() {
            return true;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
            if (_args.get().containsKey(JsonWriter.DATE_FORMAT)) {
                this.write(o, false, out);
            } else {
                out.write(Long.toString(((java.util.Date)o).getTime()));
            }
        }
    }

    public static class CalendarWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            Calendar cal = (Calendar)obj;
            _dateFormat.get().setTimeZone(cal.getTimeZone());
            out.write("\"time\":\"");
            out.write(_dateFormat.get().format(cal.getTime()));
            out.write("\",\"zone\":\"");
            out.write(cal.getTimeZone().getID());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return false;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
        }
    }

    public static class TimeZoneWriter
    implements JsonClassWriter {
        public void write(Object obj, boolean showType, Writer out) throws IOException {
            TimeZone cal = (TimeZone)obj;
            out.write("\"zone\":\"");
            out.write(cal.getID());
            out.write(34);
        }

        public boolean hasPrimitiveForm() {
            return false;
        }

        public void writePrimitiveForm(Object o, Writer out) throws IOException {
        }
    }

    public static interface JsonClassWriter {
        public void write(Object var1, boolean var2, Writer var3) throws IOException;

        public boolean hasPrimitiveForm();

        public void writePrimitiveForm(Object var1, Writer var2) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassMeta
    extends LinkedHashMap<String, Field> {
        ClassMeta() {
        }
    }
}

