/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.RegexUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Color;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class StringConversions {
    private static final BigDecimal bigDecimalMinByte = BigDecimal.valueOf(-128L);
    private static final BigDecimal bigDecimalMaxByte = BigDecimal.valueOf(127L);
    private static final BigDecimal bigDecimalMinShort = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bigDecimalMaxShort = BigDecimal.valueOf(32767L);
    private static final BigDecimal bigDecimalMinInteger = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bigDecimalMaxInteger = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bigDecimalMaxLong = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bigDecimalMinLong = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final Pattern MM_DD = Pattern.compile("^(\\d{1,2}).(\\d{1,2})$");
    private static final Pattern allDigits = Pattern.compile("^\\d+$");
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final Pattern SIMPLE_DATE = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");

    private StringConversions() {
    }

    static String asString(Object from) {
        return from == null ? null : from.toString();
    }

    static Byte toByte(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return (byte)0;
        }
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException e) {
            Long value = StringConversions.toLong(str, bigDecimalMinByte, bigDecimalMaxByte);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + str + "' not parseable as a byte value or outside " + -128 + " to " + 127, e);
            }
            return value.byteValue();
        }
    }

    static Short toShort(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return (short)0;
        }
        try {
            return Short.valueOf(str);
        }
        catch (Exception e) {
            Long value = StringConversions.toLong(str, bigDecimalMinShort, bigDecimalMaxShort);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as a short value or outside " + Short.MIN_VALUE + " to " + Short.MAX_VALUE, e);
            }
            return value.shortValue();
        }
    }

    static Integer toInt(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            Long value = StringConversions.toLong(str, bigDecimalMinInteger, bigDecimalMaxInteger);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as an int value or outside " + Integer.MIN_VALUE + " to " + Integer.MAX_VALUE, e);
            }
            return value.intValue();
        }
    }

    static Long toLong(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            Long value = StringConversions.toLong(str, bigDecimalMinLong, bigDecimalMaxLong);
            if (value == null) {
                throw new IllegalArgumentException("Value '" + from + "' not parseable as a long value or outside " + Long.MIN_VALUE + " to " + Long.MAX_VALUE, e);
            }
            return value;
        }
    }

    private static Long toLong(String s, BigDecimal low, BigDecimal high) {
        try {
            BigDecimal big = new BigDecimal(s);
            big = big.setScale(0, RoundingMode.DOWN);
            if (big.compareTo(low) == -1 || big.compareTo(high) == 1) {
                return null;
            }
            return big.longValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    static Float toFloat(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return Float.valueOf(0.0f);
        }
        try {
            return Float.valueOf(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a float value", e);
        }
    }

    static Double toDouble(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return 0.0;
        }
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a double value", e);
        }
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(StringConversions.toBoolean(from, converter));
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger(StringConversions.toInt(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(StringConversions.toLong(from, converter));
    }

    static Boolean toBoolean(Object from, Converter converter) {
        String str = (String)from;
        if ("true".equals(str)) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "t".equalsIgnoreCase(str) || "1".equals(str) || "y".equalsIgnoreCase(str) || "\"true\"".equalsIgnoreCase(str);
    }

    static char toCharacter(Object from, Converter converter) {
        String str = (String)from;
        if (str.isEmpty()) {
            return '\u0000';
        }
        if (str.length() == 1) {
            return str.charAt(0);
        }
        Matcher matcher = allDigits.matcher(str);
        boolean isAllDigits = matcher.matches();
        if (isAllDigits) {
            try {
                return (char)Integer.parseInt(str.trim());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse '" + from + "' as a Character.", e);
            }
        }
        char result = StringConversions.parseUnicodeEscape(str);
        return result;
    }

    private static char parseUnicodeEscape(String unicodeStr) {
        if (!unicodeStr.startsWith("\\u") || unicodeStr.length() != 6) {
            throw new IllegalArgumentException("Unable to parse '" + unicodeStr + "' as a char/Character. Invalid Unicode escape sequence." + unicodeStr);
        }
        int codePoint = Integer.parseInt(unicodeStr.substring(2), 16);
        return (char)codePoint;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return BigInteger.ZERO;
        }
        try {
            BigDecimal bigDec = new BigDecimal(str);
            return bigDec.toBigInteger();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a BigInteger value.", e);
        }
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value '" + from + "' not parseable as a BigDecimal value.", e);
        }
    }

    static URL toURL(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return null;
        }
        try {
            URI uri = URI.create(str);
            return uri.toURL();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert String '" + str + "' to URL", e);
        }
    }

    static URI toURI(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return null;
        }
        return URI.create((String)from);
    }

    static String enumToString(Object from, Converter converter) {
        return ((Enum)from).name();
    }

    static UUID toUUID(Object from, Converter converter) {
        String s = (String)from;
        try {
            return UUID.fromString(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to convert '" + s + "' to UUID", e);
        }
    }

    static Duration toDuration(Object from, Converter converter) {
        if (!(from instanceof String)) {
            throw new IllegalArgumentException("Expected a String, but got: " + from);
        }
        String str = ((String)from).trim();
        try {
            if (DECIMAL_PATTERN.matcher(str).matches()) {
                BigDecimal seconds = new BigDecimal(str);
                long wholeSecs = seconds.longValue();
                long nanos = seconds.subtract(BigDecimal.valueOf(wholeSecs)).multiply(BigDecimalConversions.BILLION).longValue();
                return Duration.ofSeconds(wholeSecs, nanos);
            }
            return Duration.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse '" + str + "' as a Duration. Expected either:\n  - Decimal seconds (e.g., '123.456')\n  - ISO-8601 duration (e.g., 'PT1H2M3.456S')", e);
        }
    }

    static Class<?> toClass(Object from, Converter converter) {
        String str = ((String)from).trim();
        Class<?> clazz = ClassUtilities.forName(str, converter.getOptions().getClassLoader());
        if (clazz != null) {
            return clazz;
        }
        throw new IllegalArgumentException("Cannot convert String '" + str + "' to class.  Class not found.");
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        String monthDay = (String)from;
        try {
            return MonthDay.parse(monthDay);
        }
        catch (DateTimeParseException e) {
            Matcher matcher = MM_DD.matcher(monthDay);
            if (matcher.find()) {
                String mm = matcher.group(1);
                String dd = matcher.group(2);
                return MonthDay.of(Integer.parseInt(mm), Integer.parseInt(dd));
            }
            try {
                ZonedDateTime zdt = DateUtilities.parseDate(monthDay, converter.getOptions().getZoneId(), true);
                if (zdt == null) {
                    return null;
                }
                return MonthDay.of(zdt.getMonthValue(), zdt.getDayOfMonth());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to extract Month-Day from string: " + monthDay, ex);
            }
        }
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        String yearMonth = (String)from;
        try {
            return YearMonth.parse(yearMonth);
        }
        catch (DateTimeParseException e) {
            try {
                ZonedDateTime zdt = DateUtilities.parseDate(yearMonth, converter.getOptions().getZoneId(), true);
                if (zdt == null) {
                    return null;
                }
                return YearMonth.of(zdt.getYear(), zdt.getMonthValue());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to extract Year-Month from string: " + yearMonth, ex);
            }
        }
    }

    static Period toPeriod(Object from, Converter converter) {
        String period = (String)from;
        try {
            return Period.parse(period);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse '" + period + "' as a Period.", e);
        }
    }

    static java.util.Date toDate(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        return java.util.Date.from(zdt.toInstant());
    }

    static Date toSqlDate(Object from, Converter converter) {
        String dateStr = ((String)from).trim();
        if (!dateStr.contains("T") && SIMPLE_DATE.matcher(dateStr).matches()) {
            return Date.valueOf(dateStr);
        }
        try {
            if (dateStr.endsWith("Z")) {
                return Date.valueOf(Instant.parse(dateStr).atZone(ZoneOffset.UTC).toLocalDate());
            }
            ZonedDateTime zdt = ZonedDateTime.parse(dateStr);
            return Date.valueOf(zdt.toLocalDate());
        }
        catch (DateTimeParseException e) {
            ZonedDateTime zdt = DateUtilities.parseDate(dateStr, converter.getOptions().getZoneId(), true);
            return zdt == null ? null : Date.valueOf(zdt.toLocalDate());
        }
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        Instant instant = StringConversions.toInstant(from, converter);
        if (instant == null) {
            return null;
        }
        if (instant.getEpochSecond() < -62135596800L) {
            throw new IllegalArgumentException("Cannot convert to Timestamp: date " + instant + " has year before 0001. java.sql.Timestamp does not support dates before year 0001.");
        }
        return Timestamp.from(instant);
    }

    static TimeZone toTimeZone(Object from, Converter converter) {
        String str = StringUtilities.trimToNull((String)from);
        if (str == null) {
            return null;
        }
        return TimeZone.getTimeZone(str);
    }

    static Calendar toCalendar(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        if (zdt.getYear() < 2) {
            throw new IllegalArgumentException("Cannot convert to Calendar: date " + zdt + " has year less than 2. Due to Calendar implementation limitations, years 0 and 1 cannot be reliably represented.");
        }
        TimeZone timeZone = TimeZone.getTimeZone(zdt.getZone());
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTimeInMillis(zdt.toInstant().toEpochMilli());
        return calendar;
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        return zdt.toLocalDateTime();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        String str = (String)from;
        try {
            return LocalTime.parse(str);
        }
        catch (Exception e) {
            ZonedDateTime zdt = StringConversions.toZonedDateTime(str, converter);
            if (zdt == null) {
                return null;
            }
            return zdt.toLocalTime();
        }
    }

    static Locale toLocale(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return null;
        }
        return Locale.forLanguageTag(str);
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return DateUtilities.parseDate((String)from, converter.getOptions().getZoneId(), true);
    }

    static ZoneId toZoneId(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return null;
        }
        try {
            return ZoneId.of(str);
        }
        catch (Exception e) {
            TimeZone tz = TimeZone.getTimeZone(str);
            if ("GMT".equals(tz.getID())) {
                throw new IllegalArgumentException("Unknown time-zone ID: '" + str + "'", e);
            }
            return tz.toZoneId();
        }
    }

    static ZoneOffset toZoneOffset(Object from, Converter converter) {
        String str = (String)from;
        if (StringUtilities.isEmpty(str)) {
            return null;
        }
        try {
            return ZoneOffset.of(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown time-zone offset: '" + str + "'");
        }
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        return zdt.toOffsetDateTime();
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        String str = (String)from;
        try {
            return OffsetTime.parse(str, DateTimeFormatter.ISO_OFFSET_TIME);
        }
        catch (Exception e) {
            try {
                OffsetDateTime dateTime = StringConversions.toOffsetDateTime(from, converter);
                if (dateTime == null) {
                    return null;
                }
                return dateTime.toOffsetTime();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to parse '" + str + "' as an OffsetTime", e);
            }
        }
    }

    static Instant toInstant(Object from, Converter converter) {
        ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
        if (zdt == null) {
            return null;
        }
        return zdt.toInstant();
    }

    static char[] toCharArray(Object from, Converter converter) {
        String str = from.toString();
        if (StringUtilities.isEmpty(str)) {
            return ArrayUtilities.EMPTY_CHAR_ARRAY;
        }
        return str.toCharArray();
    }

    static Character[] toCharacterArray(Object from, Converter converter) {
        CharSequence s = (CharSequence)from;
        int len = s.length();
        Character[] ca = new Character[len];
        for (int i = 0; i < len; ++i) {
            ca[i] = Character.valueOf(s.charAt(i));
        }
        return ca;
    }

    static CharBuffer toCharBuffer(Object from, Converter converter) {
        return CharBuffer.wrap(StringConversions.asString(from));
    }

    static byte[] toByteArray(Object from, Converter converter) {
        String s = StringConversions.asString(from);
        if (s == null || s.isEmpty()) {
            return ArrayUtilities.EMPTY_BYTE_ARRAY;
        }
        return s.getBytes(converter.getOptions().getCharset());
    }

    static ByteBuffer toByteBuffer(Object from, Converter converter) {
        return ByteBuffer.wrap(StringConversions.toByteArray(from, converter));
    }

    static String toString(Object from, Converter converter) {
        return from == null ? null : from.toString();
    }

    static StringBuffer toStringBuffer(Object from, Converter converter) {
        return from == null ? null : new StringBuffer(from.toString());
    }

    static StringBuilder toStringBuilder(Object from, Converter converter) {
        return from == null ? null : new StringBuilder(from.toString());
    }

    static Year toYear(Object from, Converter converter) {
        String str = (String)from;
        str = StringUtilities.trimToNull(str);
        try {
            return Year.of(converter.convert(str, Integer.TYPE));
        }
        catch (Exception e) {
            try {
                ZonedDateTime zdt = StringConversions.toZonedDateTime(from, converter);
                if (zdt == null) {
                    return null;
                }
                return Year.of(zdt.getYear());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to parse 4-digit year from '" + str + "'", e);
            }
        }
    }

    static Pattern toPattern(Object from, Converter converter) {
        String patternString = ((String)from).trim();
        Pattern pattern = RegexUtilities.getCachedPattern(patternString);
        if (pattern == null) {
            throw new IllegalArgumentException("Invalid regex pattern: " + patternString);
        }
        return pattern;
    }

    static Currency toCurrency(Object from, Converter converter) {
        String code = ((String)from).trim();
        return Currency.getInstance(code);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        String str = ((String)from).trim();
        if (str.matches("^[A-Z][A-Z0-9_]*$")) {
            LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
            target.put("name", str);
            return target;
        }
        throw new IllegalArgumentException("Unsupported conversion, source type [String (" + str + ")] target type 'Map'");
    }

    static Color toColor(Object from, Converter converter) {
        String values;
        String[] components;
        String str = ((String)from).trim().toLowerCase();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Color");
        }
        if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (str.matches("^[0-9a-f]{6}$")) {
            int rgb = Integer.parseInt(str, 16);
            return new Color(rgb);
        }
        if (str.matches("^[0-9a-f]{8}$")) {
            long argb = Long.parseLong(str, 16);
            int alpha = (int)(argb >> 24 & 0xFFL);
            int rgb = (int)(argb & 0xFFFFFFL);
            return new Color(rgb | alpha << 24, true);
        }
        switch (str = str.replace("_", "").replace(" ", "").replace("-", "")) {
            case "black": {
                return Color.BLACK;
            }
            case "blue": {
                return Color.BLUE;
            }
            case "cyan": {
                return Color.CYAN;
            }
            case "darkgray": 
            case "darkgrey": {
                return Color.DARK_GRAY;
            }
            case "gray": 
            case "grey": {
                return Color.GRAY;
            }
            case "green": {
                return Color.GREEN;
            }
            case "lightgray": 
            case "lightgrey": {
                return Color.LIGHT_GRAY;
            }
            case "magenta": {
                return Color.MAGENTA;
            }
            case "orange": {
                return Color.ORANGE;
            }
            case "pink": {
                return Color.PINK;
            }
            case "red": {
                return Color.RED;
            }
            case "white": {
                return Color.WHITE;
            }
            case "yellow": {
                return Color.YELLOW;
            }
        }
        String original = ((String)from).trim();
        if (original.startsWith("rgb(") && original.endsWith(")") && (components = (values = original.substring(4, original.length() - 1)).split(",")).length == 3) {
            try {
                int r = converter.convert(components[0].trim(), Integer.TYPE);
                int g = converter.convert(components[1].trim(), Integer.TYPE);
                int b = converter.convert(components[2].trim(), Integer.TYPE);
                return new Color(r, g, b);
            }
            catch (NumberFormatException r) {
                // empty catch block
            }
        }
        if (original.startsWith("rgba(") && original.endsWith(")") && (components = (values = original.substring(5, original.length() - 1)).split(",")).length == 4) {
            try {
                int r = converter.convert(components[0].trim(), Integer.TYPE);
                int g = converter.convert(components[1].trim(), Integer.TYPE);
                int b = converter.convert(components[2].trim(), Integer.TYPE);
                int a = converter.convert(components[3].trim(), Integer.TYPE);
                return new Color(r, g, b, a);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Unable to parse color from string: " + from);
    }

    static Dimension toDimension(Object from, Converter converter) {
        String[] components;
        int startIndex;
        String content;
        String[] parts;
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Dimension");
        }
        if ((str.startsWith("Dimension[") || str.startsWith("java.awt.Dimension[")) && str.endsWith("]") && (parts = (content = str.substring(startIndex = str.indexOf(91) + 1, str.length() - 1)).split(",")).length == 2) {
            String widthPart = parts[0].trim();
            String heightPart = parts[1].trim();
            if (widthPart.startsWith("width=")) {
                String widthValue = widthPart.substring(6).trim();
                int width = converter.convert(widthValue, Integer.TYPE);
                if (heightPart.startsWith("height=")) {
                    String heightValue = heightPart.substring(7).trim();
                    int height = converter.convert(heightValue, Integer.TYPE);
                    return new Dimension(width, height);
                }
            }
        }
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1).trim();
        }
        if (str.contains("x") && (components = str.split("x")).length == 2) {
            try {
                int width = converter.convert(components[0].trim(), Integer.TYPE);
                int height = converter.convert(components[1].trim(), Integer.TYPE);
                return new Dimension(width, height);
            }
            catch (NumberFormatException width) {
                // empty catch block
            }
        }
        if (str.contains(",") && (components = str.split(",")).length == 2) {
            try {
                int width = converter.convert(components[0].trim(), Integer.TYPE);
                int height = converter.convert(components[1].trim(), Integer.TYPE);
                return new Dimension(width, height);
            }
            catch (NumberFormatException width) {
                // empty catch block
            }
        }
        if (str.contains(" ") && (components = str.split("\\s+")).length == 2) {
            try {
                int width = converter.convert(components[0].trim(), Integer.TYPE);
                int height = converter.convert(components[1].trim(), Integer.TYPE);
                return new Dimension(width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Unable to parse dimension from string: " + from);
    }

    static Point toPoint(Object from, Converter converter) {
        String[] components;
        int startIndex;
        String content;
        String[] parts;
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Point");
        }
        if ((str.startsWith("Point[") || str.startsWith("java.awt.Point[")) && str.endsWith("]") && (parts = (content = str.substring(startIndex = str.indexOf(91) + 1, str.length() - 1)).split(",")).length == 2) {
            String xPart = parts[0].trim();
            String yPart = parts[1].trim();
            if (xPart.startsWith("x=")) {
                String xValue = xPart.substring(2).trim();
                int x = converter.convert(xValue, Integer.TYPE);
                if (yPart.startsWith("y=")) {
                    String yValue = yPart.substring(2).trim();
                    int y = converter.convert(yValue, Integer.TYPE);
                    return new Point(x, y);
                }
            }
        }
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1).trim();
        }
        if (str.contains(",") && (components = str.split(",")).length == 2) {
            int x = converter.convert(components[0].trim(), Integer.TYPE);
            int y = converter.convert(components[1].trim(), Integer.TYPE);
            return new Point(x, y);
        }
        if (str.contains(" ") && (components = str.split("\\s+")).length == 2) {
            int x = converter.convert(components[0].trim(), Integer.TYPE);
            int y = converter.convert(components[1].trim(), Integer.TYPE);
            return new Point(x, y);
        }
        throw new IllegalArgumentException("Unable to parse point from string: " + from);
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        String[] components;
        int startIndex;
        String content;
        String[] parts;
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Rectangle");
        }
        if ((str.startsWith("Rectangle[") || str.startsWith("java.awt.Rectangle[")) && str.endsWith("]") && (parts = (content = str.substring(startIndex = str.indexOf(91) + 1, str.length() - 1)).split(",")).length == 4) {
            try {
                String xPart = parts[0].trim();
                String yPart = parts[1].trim();
                String widthPart = parts[2].trim();
                String heightPart = parts[3].trim();
                if (xPart.startsWith("x=")) {
                    String xValue = xPart.substring(2).trim();
                    int x = converter.convert(xValue, Integer.TYPE);
                    if (yPart.startsWith("y=")) {
                        String yValue = yPart.substring(2).trim();
                        int y = converter.convert(yValue, Integer.TYPE);
                        if (widthPart.startsWith("width=")) {
                            String widthValue = widthPart.substring(6).trim();
                            int width = converter.convert(widthValue, Integer.TYPE);
                            if (heightPart.startsWith("height=")) {
                                String heightValue = heightPart.substring(7).trim();
                                int height = converter.convert(heightValue, Integer.TYPE);
                                return new Rectangle(x, y, width, height);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException xPart) {
                // empty catch block
            }
        }
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1).trim();
        }
        if (str.contains(",") && (components = str.split(",")).length == 4) {
            try {
                int x = converter.convert(components[0].trim(), Integer.TYPE);
                int y = converter.convert(components[1].trim(), Integer.TYPE);
                int width = converter.convert(components[2].trim(), Integer.TYPE);
                int height = converter.convert(components[3].trim(), Integer.TYPE);
                return new Rectangle(x, y, width, height);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if (str.contains(" ") && (components = str.split("\\s+")).length == 4) {
            try {
                int x = converter.convert(components[0].trim(), Integer.TYPE);
                int y = converter.convert(components[1].trim(), Integer.TYPE);
                int width = converter.convert(components[2].trim(), Integer.TYPE);
                int height = converter.convert(components[3].trim(), Integer.TYPE);
                return new Rectangle(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Unable to parse rectangle from string: " + from);
    }

    static Insets toInsets(Object from, Converter converter) {
        String[] components;
        int startIndex;
        String content;
        String[] parts;
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Insets");
        }
        if ((str.startsWith("Insets[") || str.startsWith("java.awt.Insets[")) && str.endsWith("]") && (parts = (content = str.substring(startIndex = str.indexOf(91) + 1, str.length() - 1)).split(",")).length == 4) {
            try {
                String topPart = parts[0].trim();
                String leftPart = parts[1].trim();
                String bottomPart = parts[2].trim();
                String rightPart = parts[3].trim();
                if (topPart.startsWith("top=")) {
                    String topValue = topPart.substring(4).trim();
                    int top = converter.convert(topValue, Integer.TYPE);
                    if (leftPart.startsWith("left=")) {
                        String leftValue = leftPart.substring(5).trim();
                        int left = converter.convert(leftValue, Integer.TYPE);
                        if (bottomPart.startsWith("bottom=")) {
                            String bottomValue = bottomPart.substring(7).trim();
                            int bottom = converter.convert(bottomValue, Integer.TYPE);
                            if (rightPart.startsWith("right=")) {
                                String rightValue = rightPart.substring(6).trim();
                                int right = converter.convert(rightValue, Integer.TYPE);
                                return new Insets(top, left, bottom, right);
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse insets from string: " + from, e);
            }
        }
        if (str.startsWith("(") && str.endsWith(")")) {
            str = str.substring(1, str.length() - 1).trim();
        }
        if (str.contains(",") && (components = str.split(",")).length == 4) {
            try {
                int top = converter.convert(components[0].trim(), Integer.TYPE);
                int left = converter.convert(components[1].trim(), Integer.TYPE);
                int bottom = converter.convert(components[2].trim(), Integer.TYPE);
                int right = converter.convert(components[3].trim(), Integer.TYPE);
                return new Insets(top, left, bottom, right);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse insets from string: " + from, e);
            }
        }
        if (str.contains(" ") && (components = str.split("\\s+")).length == 4) {
            try {
                int top = converter.convert(components[0].trim(), Integer.TYPE);
                int left = converter.convert(components[1].trim(), Integer.TYPE);
                int bottom = converter.convert(components[2].trim(), Integer.TYPE);
                int right = converter.convert(components[3].trim(), Integer.TYPE);
                return new Insets(top, left, bottom, right);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse insets from string: " + from, e);
            }
        }
        throw new IllegalArgumentException("Unable to parse insets from string: " + from);
    }

    static File toFile(Object from, Converter converter) {
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to File");
        }
        return new File(str);
    }

    static Path toPath(Object from, Converter converter) {
        String str = ((String)from).trim();
        if (StringUtilities.isEmpty(str)) {
            throw new IllegalArgumentException("Cannot convert empty/null string to Path");
        }
        return Paths.get(str, new String[0]);
    }
}

