/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.cache;

import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.MapUtilities;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadedLRUCacheStrategy<K, V>
implements Map<K, V> {
    private final long cleanupDelayMillis;
    private final int capacity;
    private final ConcurrentMap<K, Node<K, V>> cache;
    private final AtomicBoolean cleanupScheduled = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> scheduledPurgeTask;
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "LRUCache-Purge-Thread");
        thread.setDaemon(true);
        return thread;
    });

    public ThreadedLRUCacheStrategy(int capacity, int cleanupDelayMillis) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be at least 1.");
        }
        if (cleanupDelayMillis < 10) {
            throw new IllegalArgumentException("cleanupDelayMillis must be at least 10 milliseconds.");
        }
        this.capacity = capacity;
        this.cache = new ConcurrentHashMapNullSafe<K, Node<K, V>>(capacity);
        this.cleanupDelayMillis = cleanupDelayMillis;
        this.schedulePurgeTask();
    }

    private void schedulePurgeTask() {
        WeakReference cacheRef = new WeakReference(this);
        PurgeTask purgeTask = new PurgeTask(cacheRef);
        this.scheduledPurgeTask = scheduler.scheduleAtFixedRate(purgeTask, this.cleanupDelayMillis, this.cleanupDelayMillis, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        ScheduledFuture<?> task = this.scheduledPurgeTask;
        if (task != null) {
            task.cancel(false);
            this.scheduledPurgeTask = null;
        }
    }

    private void cleanup() {
        int size = this.cache.size();
        if (size > this.capacity) {
            int nodesToRemove = size - this.capacity;
            Node[] nodes = this.cache.values().toArray(new Node[0]);
            Arrays.sort(nodes, Comparator.comparingLong(node -> node.timestamp));
            for (int i = 0; i < nodesToRemove; ++i) {
                Node node2 = nodes[i];
                this.cache.remove(node2.key, node2);
            }
            this.cleanupScheduled.set(false);
            if (this.cache.size() > this.capacity) {
                this.scheduleImmediateCleanup();
            }
        }
    }

    private void scheduleImmediateCleanup() {
        if (this.cleanupScheduled.compareAndSet(false, true)) {
            scheduler.schedule(this::cleanup, this.cleanupDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.cache.get(key);
        if (node != null) {
            node.updateTimestamp();
            return node.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> newNode = new Node<K, V>(key, value);
        Node<K, V> oldNode = this.cache.put(key, newNode);
        if (oldNode != null) {
            newNode.updateTimestamp();
            return oldNode.value;
        }
        if (this.size() > this.capacity) {
            this.scheduleImmediateCleanup();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.cache.remove(key);
        if (node != null) {
            return node.value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node node : this.cache.values()) {
            if (!Objects.equals(node.value, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ConcurrentSet entrySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            entrySet.add(new AbstractMap.SimpleEntry(node.key, node.value));
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public Set<K> keySet() {
        ConcurrentSet keySet = new ConcurrentSet();
        for (Node node : this.cache.values()) {
            keySet.add(node.key);
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (Node node : this.cache.values()) {
            values.add(node.value);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        return this.entrySet().equals(other.entrySet());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Node node : this.cache.values()) {
            Object key = node.key;
            Object value = node.value;
            hashCode = 31 * hashCode + (key == null ? 0 : key.hashCode());
            hashCode = 31 * hashCode + (value == null ? 0 : value.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        return MapUtilities.mapToString(this);
    }

    private static class PurgeTask<K, V>
    implements Runnable {
        private final WeakReference<ThreadedLRUCacheStrategy<K, V>> cacheRef;

        PurgeTask(WeakReference<ThreadedLRUCacheStrategy<K, V>> cacheRef) {
            this.cacheRef = cacheRef;
        }

        @Override
        public void run() {
            ThreadedLRUCacheStrategy cache = (ThreadedLRUCacheStrategy)this.cacheRef.get();
            if (cache != null) {
                cache.cleanup();
            }
        }
    }

    private static class Node<K, V> {
        final K key;
        volatile V value;
        volatile long timestamp;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
            this.timestamp = System.nanoTime();
        }

        void updateTimestamp() {
            this.timestamp = System.nanoTime();
        }
    }
}

