/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CollectionUtilities;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class ArrayUtilities {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final int DEFAULT_MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final String DEFAULT_DANGEROUS_CLASS_PATTERNS = "java.lang.Runtime,java.lang.ProcessBuilder,java.lang.System,java.security.,javax.script.,sun.,com.sun.,java.lang.Class";

    private static void initializeSystemPropertyDefaults() {
        if (System.getProperty("arrayutilities.dangerous.class.patterns") == null) {
            System.setProperty("arrayutilities.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        }
        if (System.getProperty("arrayutilities.max.array.size") == null) {
            System.setProperty("arrayutilities.max.array.size", String.valueOf(0x7FFFFFF7));
        }
    }

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.security.enabled", "false"));
    }

    private static boolean isComponentTypeValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.component.type.validation.enabled", "false"));
    }

    private static boolean isDangerousClassValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.dangerous.classes.validation.enabled", "false"));
    }

    private static long getMaxArraySize() {
        String maxSizeProp = System.getProperty("arrayutilities.max.array.size");
        if (maxSizeProp != null) {
            try {
                return Long.parseLong(maxSizeProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ArrayUtilities.isSecurityEnabled() ? 0x7FFFFFF7L : Long.MAX_VALUE;
    }

    private static String[] getDangerousClassPatterns() {
        String patterns = System.getProperty("arrayutilities.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        return patterns.split(",");
    }

    private ArrayUtilities() {
    }

    private static void validateComponentType(Class<?> componentType) {
        String[] dangerousPatterns;
        if (componentType == null) {
            return;
        }
        if (!ArrayUtilities.isSecurityEnabled() || !ArrayUtilities.isComponentTypeValidationEnabled()) {
            return;
        }
        String className = componentType.getName();
        for (String pattern : dangerousPatterns = ArrayUtilities.getDangerousClassPatterns()) {
            if (!((pattern = pattern.trim()).endsWith(".") ? className.startsWith(pattern) : className.equals(pattern))) continue;
            throw new SecurityException("Array creation denied for security-sensitive class: " + className);
        }
    }

    static void validateArraySize(long size) {
        if (!ArrayUtilities.isSecurityEnabled()) {
            return;
        }
        if (size < 0L) {
            throw new SecurityException("Array size cannot be negative");
        }
        long maxSize = ArrayUtilities.getMaxArraySize();
        if (size > maxSize) {
            throw new SecurityException("Array size too large: " + size + " > " + maxSize);
        }
    }

    public static boolean isEmpty(Object array) {
        return ArrayUtilities.getLength(array) == 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtilities.isEmpty(array);
    }

    public static int size(Object array) {
        return ArrayUtilities.getLength(array);
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        throw new IllegalArgumentException("Argument is not an array: " + array.getClass().getName());
    }

    public static <T> T[] shallowCopy(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T[] nullToEmpty(Class<T> componentType, T[] array) {
        Objects.requireNonNull(componentType, "componentType is null");
        ArrayUtilities.validateComponentType(componentType);
        return array == null ? (Object[])Array.newInstance(componentType, 0) : array;
    }

    @SafeVarargs
    public static <T> T[] createArray(T ... elements) {
        if (elements == null) {
            return null;
        }
        return Arrays.copyOf(elements, elements.length);
    }

    public static <T> T[] addAll(T[] array1, T[] array2) {
        if (array1 == null) {
            return ArrayUtilities.shallowCopy(array2);
        }
        if (array2 == null) {
            return ArrayUtilities.shallowCopy(array1);
        }
        long combinedLength = (long)array1.length + (long)array2.length;
        ArrayUtilities.validateArraySize(combinedLength);
        Class<?> componentType = array1.getClass().getComponentType();
        ArrayUtilities.validateComponentType(componentType);
        Object[] newArray = (Object[])Array.newInstance(componentType, (int)combinedLength);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static <T> T[] removeItem(T[] array, int pos) {
        Objects.requireNonNull(array, "array cannot be null");
        int len = array.length;
        if (pos < 0 || pos >= len) {
            throw new ArrayIndexOutOfBoundsException("Invalid array index");
        }
        Class<?> componentType = array.getClass().getComponentType();
        ArrayUtilities.validateComponentType(componentType);
        Object[] dest = (Object[])Array.newInstance(componentType, len - 1);
        System.arraycopy(array, 0, dest, 0, pos);
        System.arraycopy(array, pos + 1, dest, pos, len - pos - 1);
        return dest;
    }

    public static <T> T[] addItem(Class<T> componentType, T[] array, T item) {
        Objects.requireNonNull(componentType, "componentType is null");
        ArrayUtilities.validateComponentType(componentType);
        if (array == null) {
            Object[] result = (Object[])Array.newInstance(componentType, 1);
            result[0] = item;
            return result;
        }
        long newLength = (long)array.length + 1L;
        ArrayUtilities.validateArraySize(newLength);
        T[] newArray = Arrays.copyOf(array, (int)newLength);
        newArray[array.length] = item;
        return newArray;
    }

    public static <T> int indexOf(T[] array, T item) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T item) {
        if (array == null) {
            return -1;
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (!Objects.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T item) {
        return ArrayUtilities.indexOf(array, item) >= 0;
    }

    public static <T> T[] getArraySubset(T[] array, int start, int end) {
        return Arrays.copyOfRange(array, start, end);
    }

    public static <T> T[] toArray(Class<T> classToCastTo, Collection<?> c) {
        Objects.requireNonNull(classToCastTo, "classToCastTo is null");
        Objects.requireNonNull(c, "collection is null");
        ArrayUtilities.validateComponentType(classToCastTo);
        ArrayUtilities.validateArraySize(c.size());
        Object[] array = (Object[])Array.newInstance(classToCastTo, c.size());
        return c.toArray(array);
    }

    public static <T> T deepCopyContainers(T array) {
        return CollectionUtilities.deepCopyContainers(array);
    }

    public static Object getElement(Object array, int index) {
        if (array instanceof Object[]) {
            return ((Object[])array)[index];
        }
        return ArrayUtilities.getPrimitiveElement(array, index);
    }

    public static Object getPrimitiveElement(Object array, int index) {
        Class<?> arrayClass = array.getClass();
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("getPrimitiveElement() requires an array, but received: " + arrayClass.getName());
        }
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType == Integer.TYPE) {
            return ((int[])array)[index];
        }
        if (componentType == Long.TYPE) {
            return ((long[])array)[index];
        }
        if (componentType == Double.TYPE) {
            return ((double[])array)[index];
        }
        if (componentType == Boolean.TYPE) {
            return ((boolean[])array)[index];
        }
        if (componentType == Byte.TYPE) {
            return ((byte[])array)[index];
        }
        if (componentType == Character.TYPE) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (componentType == Short.TYPE) {
            return ((short[])array)[index];
        }
        if (componentType == Float.TYPE) {
            return Float.valueOf(((float[])array)[index]);
        }
        throw new IllegalArgumentException("getPrimitiveElement() should only be used for primitive arrays. For reference type arrays like " + componentType.getName() + "[], use direct access: array[index]");
    }

    public static void setElement(Object array, int index, Object element) {
        if (array instanceof Object[]) {
            try {
                ((Object[])array)[index] = element;
            }
            catch (ArrayStoreException e) {
                String elementType = element == null ? "null" : element.getClass().getName();
                String arrayType = array.getClass().getComponentType().getName() + "[]";
                throw new IllegalArgumentException("Cannot set '" + elementType + "' (value: " + element + ") into '" + arrayType + "' at index " + index);
            }
        } else {
            ArrayUtilities.setPrimitiveElement(array, index, element);
        }
    }

    public static void setPrimitiveElement(Object array, int index, Object element) {
        Class<?> arrayClass = array.getClass();
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("setPrimitiveElement() requires an array, but received: " + arrayClass.getName());
        }
        Class<?> componentType = arrayClass.getComponentType();
        try {
            if (componentType == Integer.TYPE) {
                ((int[])array)[index] = element == null ? 0 : ((Number)element).intValue();
                return;
            }
            if (componentType == Long.TYPE) {
                ((long[])array)[index] = element == null ? 0L : ((Number)element).longValue();
                return;
            }
            if (componentType == Double.TYPE) {
                ((double[])array)[index] = element == null ? 0.0 : ((Number)element).doubleValue();
                return;
            }
            if (componentType == Boolean.TYPE) {
                ((boolean[])array)[index] = element != null && element instanceof Boolean && (Boolean)element != false;
                return;
            }
            if (componentType == Byte.TYPE) {
                ((byte[])array)[index] = element == null ? (byte)0 : ((Number)element).byteValue();
                return;
            }
            if (componentType == Character.TYPE) {
                ((char[])array)[index] = element == null ? (char)'\u0000' : (element instanceof Character ? ((Character)element).charValue() : (element instanceof String && ((String)element).length() > 0 ? ((String)element).charAt(0) : (char)'\u0000'));
                return;
            }
            if (componentType == Short.TYPE) {
                ((short[])array)[index] = element == null ? (short)0 : ((Number)element).shortValue();
                return;
            }
            if (componentType == Float.TYPE) {
                ((float[])array)[index] = element == null ? 0.0f : ((Number)element).floatValue();
                return;
            }
            throw new IllegalArgumentException("setPrimitiveElement() should only be used for primitive arrays. For reference type arrays like " + componentType.getName() + "[], use direct assignment: array[index] = value");
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            String elementType = element == null ? "null" : element.getClass().getName();
            String arrayType = array.getClass().getComponentType().getName() + "[]";
            throw new IllegalArgumentException("Cannot set '" + elementType + "' (value: " + element + ") into '" + arrayType + "' at index " + index);
        }
    }

    static {
        ArrayUtilities.initializeSystemPropertyDefaults();
    }
}

