/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.Converter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.UUID;

final class BigDecimalConversions {
    static final BigDecimal BILLION = BigDecimal.valueOf(1000000000L);
    static final BigDecimal GRAND = BigDecimal.valueOf(1000L);

    private BigDecimalConversions() {
    }

    static Calendar toCalendar(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal millis = seconds.multiply(GRAND);
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(millis.longValue());
        return calendar;
    }

    static Instant toInstant(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal nanos = seconds.remainder(BigDecimal.ONE);
        return Instant.ofEpochSecond(seconds.longValue(), nanos.movePointRight(9).longValue());
    }

    static Duration toDuration(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal nanos = seconds.remainder(BigDecimal.ONE);
        return Duration.ofSeconds(seconds.longValue(), nanos.movePointRight(9).longValue());
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        BigDecimal nanos = seconds.multiply(BILLION);
        try {
            return LocalTime.ofNanoOfDay(nanos.longValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input value [" + seconds.toPlainString() + "] for conversion to LocalTime must be >= 0 && <= 86399.999999999", e);
        }
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static OffsetTime toOffsetTime(Object from, Converter converter) {
        BigDecimal seconds = (BigDecimal)from;
        try {
            long wholeSecs = seconds.longValue();
            BigDecimal frac = seconds.subtract(BigDecimal.valueOf(wholeSecs));
            long nanos = frac.multiply(BILLION).longValue();
            Instant instant = Instant.ofEpochSecond(wholeSecs, nanos);
            return OffsetTime.ofInstant(instant, converter.getOptions().getZoneId());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Input value [" + seconds.toPlainString() + "] for conversion to LocalTime must be >= 0 && <= 86399.999999999", e);
        }
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toZonedDateTime(from, converter).toOffsetDateTime();
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return BigDecimalConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId());
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return java.util.Date.from(BigDecimalConversions.toInstant(from, converter));
    }

    static Date toSqlDate(Object from, Converter converter) {
        Instant instant = BigDecimalConversions.toInstant(from, converter);
        LocalDate ld = instant.atZone(converter.getOptions().getZoneId()).toLocalDate();
        return Date.valueOf(ld);
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return Timestamp.from(BigDecimalConversions.toInstant(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        return ((BigDecimal)from).toBigInteger();
    }

    static String toString(Object from, Converter converter) {
        return ((BigDecimal)from).stripTrailingZeros().toPlainString();
    }

    static UUID toUUID(Object from, Converter converter) {
        BigInteger bigInt = ((BigDecimal)from).toBigInteger();
        return BigIntegerConversions.toUUID(bigInt, converter);
    }

    static BigDecimal secondsAndNanosToDouble(long seconds, long nanos) {
        return BigDecimal.valueOf(seconds).add(BigDecimal.valueOf(nanos, 9));
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from BigDecimal to MonthDay - no meaningful conversion exists.");
    }

    static Insets toInsets(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from BigDecimal to Insets - no meaningful conversion exists.");
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from BigDecimal to Rectangle - no meaningful conversion exists.");
    }

    static Dimension toDimension(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from BigDecimal to Dimension - no meaningful conversion exists.");
    }
}

