/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IntervalSet<T extends Comparable<? super T>>
implements Iterable<Interval<T>> {
    private final ConcurrentSkipListMap<T, T> intervals = new ConcurrentSkipListMap();
    private final transient ReentrantLock lock = new ReentrantLock();
    private final boolean autoMerge;
    private final Function<T, T> previousFunction;
    private final Function<T, T> nextFunction;

    public IntervalSet() {
        this(true, null, null);
    }

    public IntervalSet(boolean autoMerge) {
        this(autoMerge, null, null);
    }

    public IntervalSet(boolean autoMerge, Function<T, T> previousFunction, Function<T, T> nextFunction) {
        this.autoMerge = autoMerge;
        this.previousFunction = previousFunction;
        this.nextFunction = nextFunction;
    }

    public IntervalSet(IntervalSet<T> other) {
        this.autoMerge = other.autoMerge;
        this.previousFunction = other.previousFunction;
        this.nextFunction = other.nextFunction;
        this.intervals.putAll(other.intervals);
    }

    public void add(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) < 0) {
            throw new IllegalArgumentException("end < start");
        }
        this.lock.lock();
        try {
            if (this.autoMerge) {
                this.addWithMerge(start, end);
            } else {
                this.addDiscrete(start, end);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWithMerge(T start, T end) {
        Map.Entry e;
        Object newStart = start;
        Object newEnd = end;
        Map.Entry<T, T> lower = this.intervals.lowerEntry(start);
        if (lower != null && ((Comparable)lower.getValue()).compareTo(start) >= 0) {
            newStart = (Comparable)lower.getKey();
            newEnd = IntervalSet.greaterOf((Comparable)lower.getValue(), end);
            this.intervals.remove(lower.getKey());
        }
        Iterator it = this.intervals.tailMap((Object)start, true).entrySet().iterator();
        while (it.hasNext() && ((Comparable)(e = it.next()).getKey()).compareTo(newEnd) <= 0) {
            newEnd = IntervalSet.greaterOf(newEnd, (Comparable)e.getValue());
            it.remove();
        }
        this.intervals.put(newStart, newEnd);
    }

    private void addDiscrete(T start, T end) {
        this.intervals.put(start, end);
    }

    public void remove(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) < 0) {
            throw new IllegalArgumentException("end < start");
        }
        this.removeRange(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeExact(T start, T end) {
        Objects.requireNonNull(start);
        Objects.requireNonNull(end);
        this.lock.lock();
        try {
            Comparable existingEnd = (Comparable)this.intervals.get(start);
            if (existingEnd != null && existingEnd.equals(end)) {
                this.intervals.remove(start);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeRange(T start, T end) {
        Objects.requireNonNull(start, "start");
        Objects.requireNonNull(end, "end");
        if (end.compareTo(start) < 0) {
            throw new IllegalArgumentException("end < start");
        }
        this.lock.lock();
        try {
            if (this.autoMerge) {
                this.removeRangeWithSplitting(start, end);
            } else {
                this.removeRangeDiscrete(start, end);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeRangeWithSplitting(T start, T end) {
        Map.Entry e;
        Map.Entry<T, T> lower = this.intervals.lowerEntry(start);
        if (lower != null && ((Comparable)lower.getValue()).compareTo(start) >= 0) {
            T leftEnd;
            Comparable lowerKey = (Comparable)lower.getKey();
            Comparable lowerValue = (Comparable)lower.getValue();
            this.intervals.remove(lowerKey);
            if (lowerKey.compareTo(start) < 0 && lowerKey.compareTo(leftEnd = this.previousValue(start)) <= 0) {
                this.intervals.put(lowerKey, leftEnd);
            }
            if (lowerValue.compareTo(end) > 0) {
                Comparable rightStart = this.nextValue(end);
                if (rightStart.compareTo((Comparable)lowerValue) <= 0) {
                    this.intervals.put(rightStart, lowerValue);
                }
                return;
            }
        }
        Iterator it = this.intervals.tailMap((Object)start, true).entrySet().iterator();
        while (it.hasNext() && ((Comparable)(e = it.next()).getKey()).compareTo(end) < 0) {
            Comparable entryValue = (Comparable)e.getValue();
            it.remove();
            if (entryValue.compareTo(end) <= 0) continue;
            Comparable rightStart = this.nextValue(end);
            if (rightStart.compareTo((Comparable)entryValue) > 0) break;
            this.intervals.put(rightStart, entryValue);
            break;
        }
    }

    private void removeRangeDiscrete(T start, T end) {
        Iterator<Map.Entry<T, T>> it = this.intervals.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, T> entry = it.next();
            Comparable s = (Comparable)entry.getKey();
            Comparable v = (Comparable)entry.getValue();
            if (v.compareTo(start) < 0 || s.compareTo(end) > 0) continue;
            it.remove();
        }
    }

    public boolean contains(T value) {
        Objects.requireNonNull(value);
        if (this.autoMerge) {
            Map.Entry<T, T> e = this.intervals.floorEntry(value);
            return e != null && ((Comparable)e.getValue()).compareTo(value) >= 0;
        }
        return this.discreteContains(value);
    }

    private boolean discreteContains(T value) {
        Map.Entry<Object, T> entry = this.intervals.floorEntry(value);
        while (entry != null) {
            if (((Comparable)entry.getValue()).compareTo(value) >= 0) {
                return true;
            }
            entry = this.intervals.lowerEntry((Comparable)entry.getKey());
        }
        return false;
    }

    public Interval<T> intervalContaining(T value) {
        Objects.requireNonNull(value);
        if (this.autoMerge) {
            Map.Entry<T, T> e = this.intervals.floorEntry(value);
            return e != null && ((Comparable)e.getValue()).compareTo(value) >= 0 ? new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue()) : null;
        }
        return this.discreteIntervalContaining(value);
    }

    private Interval<T> discreteIntervalContaining(T value) {
        Map.Entry<Object, T> entry = this.intervals.floorEntry(value);
        while (entry != null) {
            if (((Comparable)entry.getValue()).compareTo(value) >= 0) {
                return new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue());
            }
            entry = this.intervals.lowerEntry((Comparable)entry.getKey());
        }
        return null;
    }

    public List<Interval<T>> asList() {
        this.lock.lock();
        try {
            ArrayList list = new ArrayList(this.intervals.size());
            this.intervals.forEach((? super K s, ? super V e) -> list.add(new Interval<Comparable>((Comparable)s, (Comparable)e)));
            List<Interval<T>> list2 = Collections.unmodifiableList(list);
            return list2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Interval<T> first() {
        Map.Entry<T, T> e = this.intervals.firstEntry();
        return e == null ? null : new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue());
    }

    public Interval<T> last() {
        Map.Entry<T, T> e = this.intervals.lastEntry();
        return e == null ? null : new Interval<Comparable>((Comparable)e.getKey(), (Comparable)e.getValue());
    }

    public Interval<T> nextInterval(T value) {
        Objects.requireNonNull(value);
        Interval<T> containing = this.intervalContaining(value);
        if (containing != null) {
            return containing;
        }
        Map.Entry<T, T> entry = this.intervals.ceilingEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> higherInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.higherEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> previousInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.floorEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public Interval<T> lowerInterval(T value) {
        Objects.requireNonNull(value);
        Map.Entry<T, T> entry = this.intervals.lowerEntry(value);
        return entry != null ? new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()) : null;
    }

    public List<Interval<T>> getIntervalsInRange(T fromKey, T toKey) {
        Objects.requireNonNull(fromKey);
        Objects.requireNonNull(toKey);
        if (toKey.compareTo(fromKey) < 0) {
            throw new IllegalArgumentException("toKey < fromKey");
        }
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.subMap((Object)fromKey, true, (Object)toKey, true).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public List<Interval<T>> getIntervalsBefore(T toKey) {
        Objects.requireNonNull(toKey);
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.headMap((Object)toKey, false).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public List<Interval<T>> getIntervalsFrom(T fromKey) {
        Objects.requireNonNull(fromKey);
        ArrayList<Interval<T>> result = new ArrayList<Interval<T>>();
        for (Map.Entry entry : this.intervals.tailMap((Object)fromKey, true).entrySet()) {
            result.add(new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue()));
        }
        return result;
    }

    public Iterator<Interval<T>> descendingIterator() {
        return new Iterator<Interval<T>>(){
            private final Iterator<Map.Entry<T, T>> entryIterator;
            {
                this.entryIterator = IntervalSet.this.intervals.descendingMap().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Interval<T> next() {
                Map.Entry entry = this.entryIterator.next();
                return new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue());
            }
        };
    }

    public NavigableSet<T> keySet() {
        return this.intervals.navigableKeySet();
    }

    public NavigableSet<T> descendingKeySet() {
        return this.intervals.descendingKeySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeIntervalsInKeyRange(T fromKey, T toKey) {
        Objects.requireNonNull(fromKey);
        Objects.requireNonNull(toKey);
        if (toKey.compareTo(fromKey) < 0) {
            throw new IllegalArgumentException("toKey < fromKey");
        }
        this.lock.lock();
        try {
            NavigableMap subMap = this.intervals.subMap((Object)fromKey, true, (Object)toKey, true);
            int count = subMap.size();
            subMap.clear();
            int n = count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.intervals.size();
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.lock.lock();
        try {
            this.intervals.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Duration totalDuration() {
        return this.totalDuration(this::defaultToDuration);
    }

    private Duration defaultToDuration(T start, T end) {
        if (start instanceof Temporal && end instanceof Temporal) {
            return Duration.between((Temporal)start, (Temporal)end);
        }
        if (start instanceof Number && end instanceof Number) {
            long diff = ((Number)end).longValue() - ((Number)start).longValue() + 1L;
            return Duration.ofNanos(diff);
        }
        throw new UnsupportedOperationException("No default duration mapping for type " + start.getClass());
    }

    public Duration totalDuration(BiFunction<T, T, Duration> toDuration) {
        List<Interval<T>> snapshot = this.asList();
        Duration d = Duration.ZERO;
        for (Interval<T> interval : snapshot) {
            d = d.plus(toDuration.apply(interval.getStart(), interval.getEnd()));
        }
        return d;
    }

    @Override
    public Iterator<Interval<T>> iterator() {
        return new Iterator<Interval<T>>(){
            private final Iterator<Map.Entry<T, T>> entryIterator;
            {
                this.entryIterator = IntervalSet.this.intervals.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Interval<T> next() {
                Map.Entry entry = this.entryIterator.next();
                return new Interval<Comparable>((Comparable)entry.getKey(), (Comparable)entry.getValue());
            }
        };
    }

    public IntervalSet<T> union(IntervalSet<T> other) {
        IntervalSet<T> result = new IntervalSet<T>(this);
        for (Interval<T> i : other) {
            result.add(i.getStart(), i.getEnd());
        }
        return result;
    }

    public IntervalSet<T> intersection(IntervalSet<T> other) {
        IntervalSet<T> result = new IntervalSet<T>(this.autoMerge);
        List<Interval<T>> list1 = this.asList();
        List<Interval<T>> list2 = other.asList();
        int i = 0;
        int j = 0;
        while (i < list1.size() && j < list2.size()) {
            T minEnd;
            Interval<T> a = list1.get(i);
            Interval<T> b = list2.get(j);
            if (a.getEnd().compareTo(b.getStart()) < 0) {
                ++i;
                continue;
            }
            if (b.getEnd().compareTo(a.getStart()) < 0) {
                ++j;
                continue;
            }
            T maxStart = IntervalSet.greaterOf(a.getStart(), b.getStart());
            T t = minEnd = a.getEnd().compareTo(b.getEnd()) <= 0 ? a.getEnd() : b.getEnd();
            if (maxStart.compareTo(minEnd) <= 0) {
                result.add(maxStart, minEnd);
            }
            if (a.getEnd().compareTo(b.getEnd()) <= 0) {
                ++i;
                continue;
            }
            ++j;
        }
        return result;
    }

    public IntervalSet<T> difference(IntervalSet<T> other) {
        IntervalSet<T> result = new IntervalSet<T>(this);
        for (Interval<T> interval : other.asList()) {
            result.removeRange(interval.getStart(), interval.getEnd());
        }
        return result;
    }

    public boolean intersects(IntervalSet<T> other) {
        List<Interval<T>> list1 = this.asList();
        List<Interval<T>> list2 = other.asList();
        int i = 0;
        int j = 0;
        while (i < list1.size() && j < list2.size()) {
            Interval<T> a = list1.get(i);
            Interval<T> b = list2.get(j);
            if (a.getEnd().compareTo(b.getStart()) < 0) {
                ++i;
                continue;
            }
            if (b.getEnd().compareTo(a.getStart()) < 0) {
                ++j;
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSet that = (IntervalSet)o;
        return this.asList().equals(that.asList());
    }

    public int hashCode() {
        return this.asList().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Interval<T> i : this) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("[").append(i.getStart()).append("-").append(i.getEnd()).append("]");
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    private static <T extends Comparable<? super T>> T greaterOf(T a, T b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    private T previousValue(T value) {
        if (this.previousFunction != null) {
            return (T)((Comparable)this.previousFunction.apply(value));
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == Integer.MIN_VALUE) {
                    throw new ArithmeticException("Integer underflow: cannot compute previous value for Integer.MIN_VALUE");
                }
                return (T)Integer.valueOf(i - 1);
            }
            if (value instanceof Long) {
                long l = (Long)value;
                if (l == Long.MIN_VALUE) {
                    throw new ArithmeticException("Long underflow: cannot compute previous value for Long.MIN_VALUE");
                }
                return (T)Long.valueOf(l - 1L);
            }
            if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                return (T)Float.valueOf(Math.nextDown(f));
            }
            if (value instanceof Double) {
                double d = (Double)value;
                return (T)Double.valueOf(Math.nextDown(d));
            }
            if (value instanceof BigInteger) {
                return (T)((BigInteger)value).subtract(BigInteger.ONE);
            }
            if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                BigDecimal increment = BigDecimal.ONE.scaleByPowerOfTen(-bd.scale());
                return (T)bd.subtract(increment);
            }
            if (value instanceof Byte) {
                byte b = (Byte)value;
                if (b == -128) {
                    throw new ArithmeticException("Byte underflow: cannot compute previous value for Byte.MIN_VALUE");
                }
                return (T)Byte.valueOf((byte)(b - 1));
            }
            if (value instanceof Short) {
                short s = (Short)value;
                if (s == Short.MIN_VALUE) {
                    throw new ArithmeticException("Short underflow: cannot compute previous value for Short.MIN_VALUE");
                }
                return (T)Short.valueOf((short)(s - 1));
            }
        }
        if (value instanceof java.util.Date) {
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                Timestamp result = new Timestamp(ts.getTime());
                result.setNanos(ts.getNanos() - 1);
                if (result.getNanos() < 0) {
                    result.setNanos(999999999);
                    result.setTime(result.getTime() - 1L);
                }
                return (T)result;
            }
            if (value instanceof Date) {
                Date date = (Date)value;
                return (T)new Date(date.getTime() - 86400000L);
            }
            java.util.Date date = (java.util.Date)value;
            return (T)new java.util.Date(date.getTime() - 1L);
        }
        if (value instanceof Temporal) {
            if (value instanceof Instant) {
                return (T)((Instant)value).minusNanos(1L);
            }
            if (value instanceof LocalDate) {
                return (T)((LocalDate)value).minusDays(1L);
            }
            if (value instanceof LocalTime) {
                return (T)((LocalTime)value).minusNanos(1L);
            }
            if (value instanceof LocalDateTime) {
                return (T)((LocalDateTime)value).minusNanos(1L);
            }
            if (value instanceof ZonedDateTime) {
                return (T)((ZonedDateTime)value).minusNanos(1L);
            }
            if (value instanceof OffsetDateTime) {
                return (T)((OffsetDateTime)value).minusNanos(1L);
            }
            if (value instanceof OffsetTime) {
                return (T)((OffsetTime)value).minusNanos(1L);
            }
        }
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c == '\u0000') {
                throw new ArithmeticException("Character underflow: cannot compute previous value for Character.MIN_VALUE");
            }
            return (T)Character.valueOf((char)(c - '\u0001'));
        }
        if (value instanceof Duration) {
            return (T)((Duration)value).minusNanos(1L);
        }
        throw new UnsupportedOperationException("Cannot compute previous value for type " + value.getClass());
    }

    private T nextValue(T value) {
        if (this.nextFunction != null) {
            return (T)((Comparable)this.nextFunction.apply(value));
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == Integer.MAX_VALUE) {
                    throw new ArithmeticException("Integer overflow: cannot compute next value for Integer.MAX_VALUE");
                }
                return (T)Integer.valueOf(i + 1);
            }
            if (value instanceof Long) {
                long l = (Long)value;
                if (l == Long.MAX_VALUE) {
                    throw new ArithmeticException("Long overflow: cannot compute next value for Long.MAX_VALUE");
                }
                return (T)Long.valueOf(l + 1L);
            }
            if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                return (T)Float.valueOf(Math.nextUp(f));
            }
            if (value instanceof Double) {
                double d = (Double)value;
                return (T)Double.valueOf(Math.nextUp(d));
            }
            if (value instanceof BigInteger) {
                return (T)((BigInteger)value).add(BigInteger.ONE);
            }
            if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                BigDecimal increment = BigDecimal.ONE.scaleByPowerOfTen(-bd.scale());
                return (T)bd.add(increment);
            }
            if (value instanceof Byte) {
                byte b = (Byte)value;
                if (b == 127) {
                    throw new ArithmeticException("Byte overflow: cannot compute next value for Byte.MAX_VALUE");
                }
                return (T)Byte.valueOf((byte)(b + 1));
            }
            if (value instanceof Short) {
                short s = (Short)value;
                if (s == Short.MAX_VALUE) {
                    throw new ArithmeticException("Short overflow: cannot compute next value for Short.MAX_VALUE");
                }
                return (T)Short.valueOf((short)(s + 1));
            }
        }
        if (value instanceof java.util.Date) {
            if (value instanceof Timestamp) {
                Timestamp ts = (Timestamp)value;
                Timestamp result = new Timestamp(ts.getTime());
                result.setNanos(ts.getNanos() + 1);
                if (result.getNanos() >= 1000000000) {
                    result.setNanos(0);
                    result.setTime(result.getTime() + 1L);
                }
                return (T)result;
            }
            if (value instanceof Date) {
                Date date = (Date)value;
                return (T)new Date(date.getTime() + 86400000L);
            }
            java.util.Date date = (java.util.Date)value;
            return (T)new java.util.Date(date.getTime() + 1L);
        }
        if (value instanceof Temporal) {
            if (value instanceof Instant) {
                return (T)((Instant)value).plusNanos(1L);
            }
            if (value instanceof LocalDate) {
                return (T)((LocalDate)value).plusDays(1L);
            }
            if (value instanceof LocalTime) {
                return (T)((LocalTime)value).plusNanos(1L);
            }
            if (value instanceof LocalDateTime) {
                return (T)((LocalDateTime)value).plusNanos(1L);
            }
            if (value instanceof ZonedDateTime) {
                return (T)((ZonedDateTime)value).plusNanos(1L);
            }
            if (value instanceof OffsetDateTime) {
                return (T)((OffsetDateTime)value).plusNanos(1L);
            }
            if (value instanceof OffsetTime) {
                return (T)((OffsetTime)value).plusNanos(1L);
            }
        }
        if (value instanceof Duration) {
            return (T)((Duration)value).plusNanos(1L);
        }
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            if (c == '\uffff') {
                throw new ArithmeticException("Character overflow: cannot compute next value for Character.MAX_VALUE");
            }
            return (T)Character.valueOf((char)(c + '\u0001'));
        }
        throw new UnsupportedOperationException("Cannot compute next value for type " + value.getClass());
    }

    public static final class Interval<T extends Comparable<? super T>>
    implements Comparable<Interval<T>> {
        private final T start;
        private final T end;

        Interval(T start, T end) {
            this.start = start;
            this.end = end;
        }

        public T getStart() {
            return this.start;
        }

        public T getEnd() {
            return this.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public boolean equals(Object o) {
            return o instanceof Interval && this.start.equals(((Interval)o).start) && this.end.equals(((Interval)o).end);
        }

        public String toString() {
            return "[" + this.start + " \u2013 " + this.end + "]";
        }

        @Override
        public int compareTo(Interval<T> o) {
            int cmp = this.start.compareTo(o.start);
            return cmp != 0 ? cmp : this.end.compareTo(o.end);
        }
    }
}

