/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.ConcurrentHashMapNullSafe;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.LRUCache;
import com.cedarsoftware.util.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionUtils {
    private static final String CACHE_SIZE_PROPERTY = "reflection.utils.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 1500;
    private static final int DEFAULT_MAX_CACHE_SIZE = 50000;
    private static final Logger LOG = Logger.getLogger(ReflectionUtils.class.getName());
    private static final String DEFAULT_DANGEROUS_CLASS_PATTERNS = "java.lang.Runtime,java.lang.Process,java.lang.ProcessBuilder,sun.misc.Unsafe,jdk.internal.misc.Unsafe,javax.script.ScriptEngine,javax.script.ScriptEngineManager";
    private static final String DEFAULT_SENSITIVE_FIELD_PATTERNS = "password,passwd,secret,secretkey,apikey,api_key,authtoken,accesstoken,credential,confidential,adminkey,private";
    private static final int CACHE_SIZE;
    private static final AtomicReference<Map<? super SortedConstructorsCacheKey, Constructor<?>[]>> SORTED_CONSTRUCTORS_CACHE;
    private static final AtomicReference<Map<? super ConstructorCacheKey, Constructor<?>>> CONSTRUCTOR_CACHE;
    private static final AtomicReference<Map<? super MethodCacheKey, Method>> METHOD_CACHE;
    private static final AtomicReference<Map<? super FieldsCacheKey, Collection<Field>>> FIELDS_CACHE;
    private static final AtomicReference<Map<? super FieldNameCacheKey, Field>> FIELD_NAME_CACHE;
    private static final AtomicReference<Map<? super ClassAnnotationCacheKey, Annotation>> CLASS_ANNOTATION_CACHE;
    private static final AtomicReference<Map<? super MethodAnnotationCacheKey, Annotation>> METHOD_ANNOTATION_CACHE;
    public static final Predicate<Field> DEFAULT_FIELD_FILTER;
    private static final int CONSTANT_UTF8 = 1;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACEMETHODREF = 11;
    private static final int CONSTANT_NAMEANDTYPE = 12;
    private static final int CONSTANT_METHODHANDLE = 15;
    private static final int CONSTANT_METHODTYPE = 16;
    private static final int CONSTANT_DYNAMIC = 17;
    private static final int CONSTANT_INVOKEDYNAMIC = 18;
    private static final int CONSTANT_MODULE = 19;
    private static final int CONSTANT_PACKAGE = 20;

    private static void initializeSystemPropertyDefaults() {
        if (System.getProperty("reflectionutils.dangerous.class.patterns") == null) {
            System.setProperty("reflectionutils.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        }
        if (System.getProperty("reflectionutils.sensitive.field.patterns") == null) {
            System.setProperty("reflectionutils.sensitive.field.patterns", DEFAULT_SENSITIVE_FIELD_PATTERNS);
        }
        if (System.getProperty("reflectionutils.max.cache.size") == null) {
            System.setProperty("reflectionutils.max.cache.size", String.valueOf(50000));
        }
    }

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("reflectionutils.security.enabled", "false"));
    }

    private static boolean isDangerousClassValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("reflectionutils.dangerous.class.validation.enabled", "false"));
    }

    private static boolean isSensitiveFieldValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("reflectionutils.sensitive.field.validation.enabled", "false"));
    }

    private static int getMaxCacheSize() {
        String maxSizeProp = System.getProperty("reflectionutils.max.cache.size");
        if (maxSizeProp != null) {
            try {
                return Math.max(1, Integer.parseInt(maxSizeProp));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ReflectionUtils.isSecurityEnabled() ? 50000 : Integer.MAX_VALUE;
    }

    private static Set<String> getDangerousClassPatterns() {
        String patterns = System.getProperty("reflectionutils.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        return new HashSet<String>(Arrays.asList(patterns.split(",")));
    }

    private static Set<String> getSensitiveFieldPatterns() {
        String patterns = System.getProperty("reflectionutils.sensitive.field.patterns", DEFAULT_SENSITIVE_FIELD_PATTERNS);
        return new HashSet<String>(Arrays.asList(patterns.split(",")));
    }

    private static <K, V> Map<K, V> ensureThreadSafe(Map<K, V> candidate) {
        if (candidate instanceof ConcurrentMap || candidate instanceof LRUCache) {
            return candidate;
        }
        return new ConcurrentHashMapNullSafe<K, V>(candidate);
    }

    private static <T> void swap(AtomicReference<T> ref, T newValue) {
        Objects.requireNonNull(newValue, "cache must not be null");
        ref.set(newValue);
    }

    public static void setMethodCache(Map<Object, Method> cache) {
        ReflectionUtils.swap(METHOD_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setClassFieldsCache(Map<Object, Collection<Field>> cache) {
        ReflectionUtils.swap(FIELDS_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setFieldCache(Map<Object, Field> cache) {
        ReflectionUtils.swap(FIELD_NAME_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setClassAnnotationCache(Map<Object, Annotation> cache) {
        ReflectionUtils.swap(CLASS_ANNOTATION_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setMethodAnnotationCache(Map<Object, Annotation> cache) {
        ReflectionUtils.swap(METHOD_ANNOTATION_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setConstructorCache(Map<Object, Constructor<?>> cache) {
        ReflectionUtils.swap(CONSTRUCTOR_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    public static void setSortedConstructorsCache(Map<Object, Constructor<?>[]> cache) {
        ReflectionUtils.swap(SORTED_CONSTRUCTORS_CACHE, ReflectionUtils.ensureThreadSafe(cache));
    }

    private static void secureSetAccessible(AccessibleObject obj) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                throw new SecurityException("Access denied: Insufficient permissions to bypass access controls for " + obj.getClass().getSimpleName(), e);
            }
        }
        if (obj instanceof Field) {
            ReflectionUtils.validateFieldAccess((Field)obj);
        }
        ClassUtilities.trySetAccessible(obj);
    }

    private static void validateFieldAccess(Field field) {
        if (!ReflectionUtils.isSecurityEnabled()) {
            return;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        String fieldName = field.getName().toLowerCase();
        String className = declaringClass.getName();
        if (ReflectionUtils.isDangerousClassValidationEnabled() && ReflectionUtils.isDangerousClass(declaringClass)) {
            LOG.log(Level.WARNING, "Access to field blocked in dangerous class: " + ReflectionUtils.sanitizeClassName(className) + "." + fieldName);
            throw new SecurityException("Access denied: Field access not permitted in security-sensitive class");
        }
        if (!ReflectionUtils.isSensitiveFieldValidationEnabled()) {
            return;
        }
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.")) {
            return;
        }
        if (fieldName.startsWith("normal")) {
            return;
        }
        Set<String> sensitivePatterns = ReflectionUtils.getSensitiveFieldPatterns();
        for (String pattern : sensitivePatterns) {
            if (!fieldName.contains(pattern.trim().toLowerCase())) continue;
            LOG.log(Level.WARNING, "Access to sensitive field blocked: " + ReflectionUtils.sanitizeClassName(className) + "." + fieldName);
            throw new SecurityException("Access denied: Sensitive field access not permitted");
        }
    }

    private static boolean isDangerousClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (!ReflectionUtils.isSecurityEnabled() || !ReflectionUtils.isDangerousClassValidationEnabled()) {
            return false;
        }
        String className = clazz.getName();
        Set<String> dangerousPatterns = ReflectionUtils.getDangerousClassPatterns();
        boolean isDangerous = false;
        for (String pattern : dangerousPatterns) {
            if (!className.equals(pattern = pattern.trim())) continue;
            isDangerous = true;
            break;
        }
        if (!isDangerous) {
            return false;
        }
        return !ReflectionUtils.isTrustedCaller();
    }

    private static boolean isTrustedCaller() {
        StackTraceElement[] stack;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.startsWith("com.cedarsoftware.util.") || className.equals("com.cedarsoftware.util.ReflectionUtils")) continue;
            return true;
        }
        return false;
    }

    private static String sanitizeClassName(String className) {
        if (className == null) {
            return "[null]";
        }
        if (className.length() <= 10) {
            return "[class:" + className.length() + "-chars]";
        }
        return className.substring(0, 5) + "***" + className.substring(className.length() - 5);
    }

    private ReflectionUtils() {
    }

    public static <T extends Annotation> T getClassAnnotation(Class<?> classToCheck, Class<T> annoClass) {
        if (classToCheck == null) {
            return null;
        }
        Convention.throwIfNull(annoClass, "annotation class cannot be null");
        ClassAnnotationCacheKey key = new ClassAnnotationCacheKey(classToCheck, annoClass);
        Annotation annotation = CLASS_ANNOTATION_CACHE.get().computeIfAbsent(key, k -> ReflectionUtils.findClassAnnotation(classToCheck, annoClass));
        return (T)annotation;
    }

    private static <T extends Annotation> T findClassAnnotation(Class<?> classToCheck, Class<T> annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.add(classToCheck);
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            T a = classToChk.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(classToChk, stack);
        }
        return null;
    }

    private static void addInterfaces(Class<?> classToCheck, LinkedList<Class<?>> stack) {
        for (Class<?> interFace : classToCheck.getInterfaces()) {
            stack.push(interFace);
        }
    }

    public static <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annoClass) {
        Convention.throwIfNull(method, "method cannot be null");
        Convention.throwIfNull(annoClass, "annotation class cannot be null");
        MethodAnnotationCacheKey key = new MethodAnnotationCacheKey(method, annoClass);
        Annotation annotation = METHOD_ANNOTATION_CACHE.get().computeIfAbsent(key, k -> {
            for (Class<?> currentClass = method.getDeclaringClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                try {
                    Method currentMethod = currentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    Object found = currentMethod.getAnnotation(annoClass);
                    if (found == null) continue;
                    return found;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Class<?> iface : method.getDeclaringClass().getInterfaces()) {
                try {
                    Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    Object found = ifaceMethod.getAnnotation(annoClass);
                    if (found == null) continue;
                    return found;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        });
        return (T)annotation;
    }

    public static Field getField(Class<?> c, String fieldName) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldName, "fieldName cannot be null");
        FieldNameCacheKey key = new FieldNameCacheKey(c, fieldName);
        Field field = FIELD_NAME_CACHE.get().computeIfAbsent(key, k -> {
            List<Field> fields = ReflectionUtils.getAllDeclaredFields(c);
            for (Field f : fields) {
                if (!fieldName.equals(f.getName())) continue;
                return f;
            }
            return null;
        });
        if (field != null) {
            ReflectionUtils.validateFieldAccess(field);
        }
        return field;
    }

    public static List<Field> getDeclaredFields(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        FieldsCacheKey key = new FieldsCacheKey(c, fieldFilter, false);
        Collection cachedFields = FIELDS_CACHE.get().computeIfAbsent(key, k -> {
            Field[] declared = c.getDeclaredFields();
            ArrayList<Field> filteredList = new ArrayList<Field>(declared.length);
            for (Field field : declared) {
                if (!fieldFilter.test(field)) continue;
                ReflectionUtils.secureSetAccessible(field);
                filteredList.add(field);
            }
            return Collections.unmodifiableList(filteredList);
        });
        return (List)cachedFields;
    }

    public static List<Field> getDeclaredFields(Class<?> c) {
        return ReflectionUtils.getDeclaredFields(c, DEFAULT_FIELD_FILTER);
    }

    public static List<Field> getAllDeclaredFields(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        if (ReflectionUtils.isDangerousClass(c)) {
            LOG.log(Level.WARNING, "Field access blocked for dangerous class: " + ReflectionUtils.sanitizeClassName(c.getName()));
            throw new SecurityException("Access denied: Field access not permitted for security-sensitive class");
        }
        FieldsCacheKey key = new FieldsCacheKey(c, fieldFilter, true);
        Collection cached = FIELDS_CACHE.get().computeIfAbsent(key, k -> {
            ArrayList<Field> allFields = new ArrayList<Field>();
            for (Class current = c; current != null && !ReflectionUtils.isDangerousClass(current); current = current.getSuperclass()) {
                allFields.addAll(ReflectionUtils.getDeclaredFields(current, fieldFilter));
            }
            return Collections.unmodifiableList(allFields);
        });
        return (List)cached;
    }

    public static List<Field> getAllDeclaredFields(Class<?> c) {
        return ReflectionUtils.getAllDeclaredFields(c, DEFAULT_FIELD_FILTER);
    }

    public static Map<String, Field> getAllDeclaredFieldsMap(Class<?> c, Predicate<Field> fieldFilter) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fieldFilter, "fieldFilter cannot be null");
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        List<Field> fields = ReflectionUtils.getAllDeclaredFields(c, fieldFilter);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldMap.containsKey(fieldName)) {
                fieldMap.put(field.getDeclaringClass().getName() + '.' + fieldName, field);
                continue;
            }
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static Map<String, Field> getAllDeclaredFieldsMap(Class<?> c) {
        return ReflectionUtils.getAllDeclaredFieldsMap(c, DEFAULT_FIELD_FILTER);
    }

    @Deprecated
    public static Collection<Field> getDeepDeclaredFields(Class<?> c) {
        Convention.throwIfNull(c, "Class cannot be null");
        Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
        return ReflectionUtils.getAllDeclaredFields(c, legacyFilter);
    }

    @Deprecated
    public static Map<String, Field> getDeepDeclaredFieldMap(Class<?> c) {
        Convention.throwIfNull(c, "class cannot be null");
        Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
        return ReflectionUtils.getAllDeclaredFieldsMap(c, legacyFilter);
    }

    @Deprecated
    public static void getDeclaredFields(Class<?> c, Collection<Field> fields) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(fields, "fields collection cannot be null");
        try {
            Predicate<Field> legacyFilter = field -> DEFAULT_FIELD_FILTER.test((Field)field) && !Modifier.isTransient(field.getModifiers()) && !field.isSynthetic();
            List<Field> filteredFields = ReflectionUtils.getDeclaredFields(c, legacyFilter);
            fields.addAll(filteredFields);
        }
        catch (Throwable t) {
            ExceptionUtilities.safelyIgnoreException(t);
        }
    }

    public static Object call(Object instance, Method method, Object ... args) {
        if (method == null) {
            String className = instance == null ? "null instance" : instance.getClass().getName();
            throw new IllegalArgumentException("null Method passed to ReflectionUtils.call() on instance of type: " + className);
        }
        if (instance == null) {
            throw new IllegalArgumentException("Cannot call [" + method.getName() + "()] on a null object.");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                throw new SecurityException("Access denied: ReflectionUtils.call() requires suppressAccessChecks permission for method: " + method.getName(), e);
            }
        }
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static Object call(Object instance, String methodName, Object ... args) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException e) {
                throw new SecurityException("Access denied: ReflectionUtils.call() requires suppressAccessChecks permission for method: " + methodName, e);
            }
        }
        Method method = ReflectionUtils.getMethod(instance, methodName, args.length);
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... types) {
        Convention.throwIfNull(c, "class cannot be null");
        Convention.throwIfNull(methodName, "methodName cannot be null");
        if (ReflectionUtils.isDangerousClass(c)) {
            LOG.log(Level.WARNING, "Method access blocked for dangerous class: " + ReflectionUtils.sanitizeClassName(c.getName()) + "." + methodName);
            throw new SecurityException("Access denied: Method access not permitted for security-sensitive class");
        }
        MethodCacheKey key = new MethodCacheKey(c, methodName, types);
        return METHOD_CACHE.get().computeIfAbsent(key, k -> {
            Method method = null;
            for (Class current = c; current != null && method == null; current = current.getSuperclass()) {
                try {
                    method = current.getDeclaredMethod(methodName, types);
                    ReflectionUtils.secureSetAccessible(method);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return method;
        });
    }

    public static Method getMethod(Object instance, String methodName, int argCount) {
        Convention.throwIfNull(instance, "Object instance cannot be null");
        Convention.throwIfNull(methodName, "Method name cannot be null");
        if (argCount < 0) {
            throw new IllegalArgumentException("Argument count cannot be negative");
        }
        Class<?> beanClass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Object[] types = new Class[argCount];
        Arrays.fill(types, Object.class);
        MethodCacheKey key = new MethodCacheKey(beanClass, methodName, (Class<?>[])types);
        Method cached = METHOD_CACHE.get().get(key);
        if (cached != null || METHOD_CACHE.get().containsKey(key)) {
            return cached;
        }
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Class<?> current = beanClass; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterCount() != argCount) continue;
                candidates.add(method);
            }
        }
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Method '%s' with %d parameters not found in %s or its superclasses", methodName, argCount, beanClass.getName()));
        }
        Method selected = ReflectionUtils.selectMethod(candidates);
        ReflectionUtils.secureSetAccessible(selected);
        METHOD_CACHE.get().put(key, selected);
        return selected;
    }

    private static Method selectMethod(List<Method> candidates) {
        return candidates.stream().min((m1, m2) -> {
            if (m1.isSynthetic() != m2.isSynthetic()) {
                return m1.isSynthetic() ? 1 : -1;
            }
            if (m1.isBridge() != m2.isBridge()) {
                return m1.isBridge() ? 1 : -1;
            }
            int accessDiff = ReflectionUtils.getAccessibilityScore(m2.getModifiers()) - ReflectionUtils.getAccessibilityScore(m1.getModifiers());
            if (accessDiff != 0) {
                return accessDiff;
            }
            if (m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass())) {
                return 1;
            }
            if (m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) {
                return -1;
            }
            return 0;
        }).orElse(candidates.get(0));
    }

    private static int getAccessibilityScore(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return 4;
        }
        if (Modifier.isProtected(modifiers)) {
            return 3;
        }
        if (Modifier.isPrivate(modifiers)) {
            return 1;
        }
        return 2;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Convention.throwIfNull(clazz, "class cannot be null");
        if (ReflectionUtils.isDangerousClass(clazz)) {
            LOG.log(Level.WARNING, "Constructor access blocked for dangerous class: " + ReflectionUtils.sanitizeClassName(clazz.getName()));
            throw new SecurityException("Access denied: Constructor access not permitted for security-sensitive class");
        }
        ConstructorCacheKey key = new ConstructorCacheKey(clazz, parameterTypes);
        Constructor cachedCtor = CONSTRUCTOR_CACHE.get().computeIfAbsent(key, k -> {
            try {
                Constructor ctor = clazz.getDeclaredConstructor(parameterTypes);
                ReflectionUtils.secureSetAccessible(ctor);
                return ctor;
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            catch (SecurityException ignored) {
                return null;
            }
        });
        return cachedCtor;
    }

    public static Constructor<?>[] getAllConstructors(Class<?> clazz) {
        if (clazz == null) {
            return new Constructor[0];
        }
        if (ReflectionUtils.isDangerousClass(clazz)) {
            LOG.log(Level.WARNING, "Constructor enumeration blocked for dangerous class: " + ReflectionUtils.sanitizeClassName(clazz.getName()));
            throw new SecurityException("Access denied: Constructor enumeration not permitted for security-sensitive class");
        }
        SortedConstructorsCacheKey key = new SortedConstructorsCacheKey(clazz);
        return SORTED_CONSTRUCTORS_CACHE.get().computeIfAbsent(key, k -> ReflectionUtils.getAllConstructorsInternal(clazz));
    }

    private static Constructor<?>[] getAllConstructorsInternal(Class<?> clazz) {
        Constructor<?>[] declared = clazz.getDeclaredConstructors();
        if (declared.length == 0) {
            return declared;
        }
        for (int i = 0; i < declared.length; ++i) {
            Constructor<?> ctor = declared[i];
            Class<?>[] paramTypes = ctor.getParameterTypes();
            ConstructorCacheKey key = new ConstructorCacheKey(clazz, paramTypes);
            declared[i] = CONSTRUCTOR_CACHE.get().computeIfAbsent(key, k -> {
                ReflectionUtils.secureSetAccessible(ctor);
                return ctor;
            });
        }
        Constructor[] result = new Constructor[declared.length];
        System.arraycopy(declared, 0, result, 0, declared.length);
        if (result.length > 1) {
            boolean isFinal = Modifier.isFinal(clazz.getModifiers());
            boolean isException = Throwable.class.isAssignableFrom(clazz);
            Arrays.sort(result, (c1, c2) -> {
                int mod1 = c1.getModifiers();
                int mod2 = c2.getModifiers();
                boolean isPublic1 = Modifier.isPublic(mod1);
                boolean isPublic2 = Modifier.isPublic(mod2);
                boolean isProtected1 = Modifier.isProtected(mod1);
                boolean isProtected2 = Modifier.isProtected(mod2);
                boolean isPrivate1 = Modifier.isPrivate(mod1);
                boolean isPrivate2 = Modifier.isPrivate(mod2);
                if (isPublic1 != isPublic2) {
                    return isPublic1 ? -1 : 1;
                }
                if (isProtected1 != isProtected2) {
                    return isProtected1 ? -1 : 1;
                }
                if (isPrivate1 != isPrivate2) {
                    return isPrivate1 ? 1 : -1;
                }
                int paramDiff = c1.getParameterCount() - c2.getParameterCount();
                if (isFinal || isException) {
                    return -paramDiff;
                }
                return -paramDiff;
            });
        }
        return result;
    }

    private static String makeParamKey(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append(':');
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                builder.append('|');
            }
            Class<?> param = parameterTypes[i];
            builder.append(param.getName());
        }
        return builder.toString();
    }

    public static Method getNonOverloadedMethod(Class<?> clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Attempted to call getMethod() [" + methodName + "()] on a null class.");
        }
        if (StringUtilities.isEmpty(methodName)) {
            throw new IllegalArgumentException("Attempted to call getMethod() with a null or blank method name on class: " + clazz.getName());
        }
        MethodCacheKey key = new MethodCacheKey(clazz, methodName, new Class[0]);
        return METHOD_CACHE.get().computeIfAbsent(key, k -> {
            Method foundMethod = null;
            for (Method m : clazz.getMethods()) {
                if (!methodName.equals(m.getName())) continue;
                if (foundMethod != null) {
                    throw new IllegalArgumentException("Method: " + methodName + "() called on a class with overloaded methods - ambiguous as to which one to return. Use getMethod() with argument types or argument count.");
                }
                foundMethod = m;
            }
            if (foundMethod == null) {
                throw new IllegalArgumentException("Method: " + methodName + "() is not found on class: " + clazz.getName() + ". Perhaps the method is protected, private, or misspelled?");
            }
            return foundMethod;
        });
    }

    public static String getClassName(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getClassNameFromByteCode(byte[] byteCode) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(byteCode);){
            String string;
            try (DataInputStream dis = new DataInputStream(is);){
                dis.readInt();
                dis.readShort();
                dis.readShort();
                int cpcnt = (dis.readShort() & 0xFFFF) - 1;
                int[] classes = new int[cpcnt];
                String[] strings = new String[cpcnt];
                block25: for (int i = 0; i < cpcnt; ++i) {
                    int t = dis.read();
                    switch (t) {
                        case 1: {
                            strings[i] = dis.readUTF();
                            continue block25;
                        }
                        case 3: 
                        case 4: {
                            dis.readInt();
                            continue block25;
                        }
                        case 5: 
                        case 6: {
                            dis.readInt();
                            dis.readInt();
                            ++i;
                            continue block25;
                        }
                        case 7: {
                            classes[i] = dis.readShort() & 0xFFFF;
                            continue block25;
                        }
                        case 8: {
                            dis.readShort();
                            continue block25;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            dis.readShort();
                            dis.readShort();
                            continue block25;
                        }
                        case 12: {
                            dis.readShort();
                            dis.readShort();
                            continue block25;
                        }
                        case 15: {
                            dis.readByte();
                            dis.readShort();
                            continue block25;
                        }
                        case 16: {
                            dis.readShort();
                            continue block25;
                        }
                        case 17: 
                        case 18: {
                            dis.readShort();
                            dis.readShort();
                            continue block25;
                        }
                        case 19: 
                        case 20: {
                            dis.readShort();
                            continue block25;
                        }
                        default: {
                            throw new IllegalStateException("Unrecognized constant pool tag: " + t);
                        }
                    }
                }
                dis.readShort();
                int thisClassIndex = dis.readShort() & 0xFFFF;
                int stringIndex = classes[thisClassIndex - 1];
                String className = strings[stringIndex - 1];
                string = className.replace('/', '.');
            }
            return string;
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static boolean isJavaCompilerAvailable() {
        if (Boolean.getBoolean("java.util.force.jre")) {
            return false;
        }
        try {
            Class<?> toolProvider = Class.forName("javax.tools.ToolProvider");
            Object compiler = toolProvider.getMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]);
            return compiler != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static String getClassLoaderName(Class<?> c) {
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            return "bootstrap";
        }
        return loader.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(loader));
    }

    static {
        ReflectionUtils.initializeSystemPropertyDefaults();
        CACHE_SIZE = Math.max(1, Math.min(ReflectionUtils.getMaxCacheSize(), Integer.getInteger(CACHE_SIZE_PROPERTY, 1500)));
        SORTED_CONSTRUCTORS_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        CONSTRUCTOR_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        METHOD_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        FIELDS_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        FIELD_NAME_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE * 10)));
        CLASS_ANNOTATION_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        METHOD_ANNOTATION_CACHE = new AtomicReference(ReflectionUtils.ensureThreadSafe(new LRUCache(CACHE_SIZE)));
        DEFAULT_FIELD_FILTER = field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            String fieldName = field.getName();
            Class<Enum> declaringClass = field.getDeclaringClass();
            if (declaringClass.isEnum() && ("internal".equals(fieldName) || "ENUM$VALUES".equals(fieldName))) {
                return false;
            }
            if ("metaClass".equals(fieldName) && "groovy.lang.MetaClass".equals(field.getType().getName())) {
                return false;
            }
            return !declaringClass.isAssignableFrom(Enum.class) || !fieldName.equals("hash") && !fieldName.equals("ordinal");
        };
    }

    private static final class ClassAnnotationCacheKey {
        private final Class<?> clazz;
        private final Class<? extends Annotation> annotationClass;
        private final int hash;

        ClassAnnotationCacheKey(Class<?> clazz, Class<? extends Annotation> annotationClass) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.annotationClass = Objects.requireNonNull(annotationClass, "annotationClass cannot be null");
            this.hash = Objects.hash(System.identityHashCode(clazz), System.identityHashCode(annotationClass));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassAnnotationCacheKey)) {
                return false;
            }
            ClassAnnotationCacheKey that = (ClassAnnotationCacheKey)o;
            return this.clazz == that.clazz && this.annotationClass == that.annotationClass;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class MethodAnnotationCacheKey {
        private final Method method;
        private final Class<? extends Annotation> annotationClass;
        private final int hash;

        MethodAnnotationCacheKey(Method method, Class<? extends Annotation> annotationClass) {
            this.method = Objects.requireNonNull(method, "method cannot be null");
            this.annotationClass = Objects.requireNonNull(annotationClass, "annotationClass cannot be null");
            this.hash = Objects.hash(System.identityHashCode(method), System.identityHashCode(annotationClass));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodAnnotationCacheKey)) {
                return false;
            }
            MethodAnnotationCacheKey that = (MethodAnnotationCacheKey)o;
            return this.method == that.method && this.annotationClass == that.annotationClass;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class FieldNameCacheKey {
        private final Class<?> clazz;
        private final String fieldName;
        private final int hash;

        FieldNameCacheKey(Class<?> clazz, String fieldName) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName cannot be null");
            this.hash = Objects.hash(System.identityHashCode(clazz), fieldName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldNameCacheKey)) {
                return false;
            }
            FieldNameCacheKey that = (FieldNameCacheKey)o;
            return this.clazz == that.clazz && Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class FieldsCacheKey {
        private final Class<?> clazz;
        private final Predicate<Field> predicate;
        private final boolean deep;
        private final int hash;

        FieldsCacheKey(Class<?> clazz, Predicate<Field> predicate, boolean deep) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.predicate = Objects.requireNonNull(predicate, "predicate cannot be null");
            this.deep = deep;
            this.hash = Objects.hash(System.identityHashCode(clazz), deep, System.identityHashCode(predicate));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldsCacheKey)) {
                return false;
            }
            FieldsCacheKey other = (FieldsCacheKey)o;
            return this.deep == other.deep && this.clazz == other.clazz && this.predicate == other.predicate;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class MethodCacheKey {
        private final Class<?> clazz;
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final int hash;

        public MethodCacheKey(Class<?> clazz, String methodName, Class<?> ... types) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.methodName = Objects.requireNonNull(methodName, "methodName cannot be null");
            this.parameterTypes = (Class[])types.clone();
            this.hash = Objects.hash(System.identityHashCode(clazz), methodName, Arrays.hashCode(this.parameterTypes));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey that = (MethodCacheKey)o;
            return this.clazz == that.clazz && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class ConstructorCacheKey {
        private final Class<?> clazz;
        private final Class<?>[] parameterTypes;
        private final int hash;

        ConstructorCacheKey(Class<?> clazz, Class<?> ... types) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.parameterTypes = (Class[])types.clone();
            this.hash = Objects.hash(System.identityHashCode(clazz), Arrays.hashCode(this.parameterTypes));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConstructorCacheKey)) {
                return false;
            }
            ConstructorCacheKey that = (ConstructorCacheKey)o;
            return this.clazz == that.clazz && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static final class SortedConstructorsCacheKey {
        private final Class<?> clazz;
        private final int hash;

        SortedConstructorsCacheKey(Class<?> clazz) {
            this.clazz = Objects.requireNonNull(clazz, "clazz cannot be null");
            this.hash = System.identityHashCode(clazz);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SortedConstructorsCacheKey)) {
                return false;
            }
            SortedConstructorsCacheKey that = (SortedConstructorsCacheKey)o;
            return this.clazz == that.clazz;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

