/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.EncryptionUtilities;
import com.cedarsoftware.util.LoggingConfig;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MultiKeyMap<V>
implements ConcurrentMap<Object, V> {
    private static final Logger LOG = Logger.getLogger(MultiKeyMap.class.getName());
    public static final String BRACKET_OPEN = "[";
    public static final String BRACKET_CLOSE = "]";
    private static final AtomicBoolean STRIPE_CONFIG_LOGGED;
    private final AtomicInteger totalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger contentionCount = new AtomicInteger(0);
    private final AtomicInteger[] stripeLockContention = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger[] stripeLockAcquisitions = new AtomicInteger[STRIPE_COUNT];
    private final AtomicInteger globalLockAcquisitions = new AtomicInteger(0);
    private final AtomicInteger globalLockContentions = new AtomicInteger(0);
    private final AtomicBoolean resizeInProgress = new AtomicBoolean(false);
    private volatile Object[] buckets;
    private final AtomicInteger atomicSize = new AtomicInteger(0);
    private volatile int size = 0;
    private volatile int maxChainLength = 0;
    private final float loadFactor;
    private final CollectionKeyMode collectionKeyMode;
    private final boolean flattenDimensions;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int STRIPE_COUNT;
    private static final int STRIPE_MASK;
    private final ReentrantLock[] stripeLocks = new ReentrantLock[STRIPE_COUNT];
    private static final Object NULL_SENTINEL;

    public MultiKeyMap(int capacity, float loadFactor) {
        this(capacity, loadFactor, CollectionKeyMode.COLLECTIONS_EXPANDED, false);
    }

    public MultiKeyMap(int capacity, float loadFactor, CollectionKeyMode collectionKeyMode) {
        this(capacity, loadFactor, collectionKeyMode, false);
    }

    public MultiKeyMap(int capacity, float loadFactor, CollectionKeyMode collectionKeyMode, boolean flattenDimensions) {
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Load factor must be positive: " + loadFactor);
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative: " + capacity);
        }
        this.buckets = new Object[capacity];
        this.loadFactor = loadFactor;
        this.collectionKeyMode = collectionKeyMode != null ? collectionKeyMode : CollectionKeyMode.COLLECTIONS_EXPANDED;
        this.flattenDimensions = flattenDimensions;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            this.stripeLocks[i] = new ReentrantLock();
            this.stripeLockContention[i] = new AtomicInteger(0);
            this.stripeLockAcquisitions[i] = new AtomicInteger(0);
        }
        if (STRIPE_CONFIG_LOGGED.compareAndSet(false, true) && LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("MultiKeyMap stripe configuration: %d locks for %d cores", STRIPE_COUNT, Runtime.getRuntime().availableProcessors()));
        }
    }

    public MultiKeyMap() {
        this(16);
    }

    public MultiKeyMap(CollectionKeyMode collectionKeyMode, boolean flattenDimensions) {
        this(16, 0.75f, collectionKeyMode, flattenDimensions);
    }

    public MultiKeyMap(int capacity) {
        this(capacity, 0.75f);
    }

    public MultiKeyMap(boolean flattenDimensions) {
        this(16, 0.75f, CollectionKeyMode.COLLECTIONS_EXPANDED, flattenDimensions);
    }

    public CollectionKeyMode getCollectionKeyMode() {
        return this.collectionKeyMode;
    }

    public boolean getFlattenDimensions() {
        return this.flattenDimensions;
    }

    private static int computeHash(Object ... keys) {
        return MultiKeyMap.computeHashFromArray(keys);
    }

    private static int computeSingleKeyHash(Object key) {
        return MultiKeyMap.computeHashFromSingle(key);
    }

    private static int computeHashFromArray(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return 0;
        }
        return MultiKeyMap.computeHashInternal(keys, keys.length);
    }

    private static int computeHashFromCollection(Collection<?> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0;
        }
        return MultiKeyMap.computeHashInternal(keys, keys.size());
    }

    private static int computeHashFromTypedArray(Object typedArray) {
        if (typedArray == null) {
            return 0;
        }
        int length = Array.getLength(typedArray);
        if (length == 0) {
            return 0;
        }
        if (typedArray instanceof String[]) {
            return MultiKeyMap.computeHashFromStringArray((String[])typedArray);
        }
        return MultiKeyMap.computeHashInternal(typedArray, length);
    }

    private static int computeHashFromStringArray(String[] array) {
        int hash = 1;
        for (String element : array) {
            hash = hash * 31 + MultiKeyMap.computeElementHash(element);
        }
        return MultiKeyMap.finalizeHash(hash);
    }

    private static int computeHashFromSingle(Object key) {
        if (key == null || key == NULL_SENTINEL) {
            return 0;
        }
        int keyHash = MultiKeyMap.computeElementHash(key);
        return MultiKeyMap.finalizeHash(keyHash);
    }

    private static int computeHashInternal(Object keys, int size) {
        if (size == 0) {
            return 0;
        }
        int hash = 1;
        if (keys instanceof Object[]) {
            Object[] array;
            for (Object o : array = (Object[])keys) {
                hash = hash * 31 + MultiKeyMap.computeElementHash(o);
            }
        } else if (keys instanceof Collection) {
            for (Object key : (Collection)keys) {
                hash = hash * 31 + MultiKeyMap.computeElementHash(key);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                hash = hash * 31 + MultiKeyMap.computeElementHash(Array.get(keys, i));
            }
        }
        return MultiKeyMap.finalizeHash(hash);
    }

    private static int computeElementHash(Object key) {
        if (key == null) {
            return 0;
        }
        if (key instanceof Class || key instanceof Executable || key instanceof Field || key instanceof ClassLoader || key instanceof Reference || key instanceof Thread) {
            return System.identityHashCode(key);
        }
        return key.hashCode();
    }

    private static int finalizeHash(int hash) {
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }

    private static int computeHashForKey(Object key) {
        if (key == null) {
            return 0;
        }
        Class<?> keyClass = key.getClass();
        if (keyClass.isArray()) {
            if (key instanceof Object[]) {
                return MultiKeyMap.computeHashFromArray((Object[])key);
            }
            return MultiKeyMap.computeHashFromTypedArray(key);
        }
        if (key instanceof Collection) {
            return MultiKeyMap.computeHashFromCollection((Collection)key);
        }
        return MultiKeyMap.computeHashFromSingle(key);
    }

    private ReentrantLock getStripeLock(int hash) {
        return this.stripeLocks[hash & STRIPE_MASK];
    }

    private void lockAllStripes() {
        int contendedStripes = 0;
        for (ReentrantLock lock : this.stripeLocks) {
            boolean wasContended = lock.hasQueuedThreads();
            if (wasContended) {
                ++contendedStripes;
            }
            lock.lock();
        }
        this.globalLockAcquisitions.incrementAndGet();
        if (contendedStripes > 0) {
            this.globalLockContentions.incrementAndGet();
        }
    }

    private void unlockAllStripes() {
        for (int i = this.stripeLocks.length - 1; i >= 0; --i) {
            this.stripeLocks[i].unlock();
        }
    }

    public V getMultiKey(Object ... keys) {
        if (keys == null) {
            return this.get(null);
        }
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        if (expandedKeys.length == 1 && (this.flattenDimensions || expandedKeys[0] instanceof CaseInsensitiveMap.CaseInsensitiveString)) {
            return this.get(expandedKeys[0]);
        }
        MultiKey<Object> lookupKey = new MultiKey<Object>(expandedKeys, null);
        return this.getInternalCommon(lookupKey);
    }

    @Override
    public V get(Object key) {
        if (this.flattenDimensions) {
            ArrayList<Object> flatKeys = new ArrayList<Object>();
            IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
            MultiKeyMap.expandWithBrackets(key, flatKeys, visited, true);
            if (flatKeys.size() == 1) {
                return this.getInternalSingle(flatKeys.get(0));
            }
            return this.getInternalCollectionDirect(flatKeys);
        }
        if (key == null) {
            return this.getInternalSingle(null);
        }
        if (key instanceof Collection) {
            return this.getInternalCollection((Collection)key);
        }
        if (key.getClass().isArray()) {
            return this.getInternalArray(key);
        }
        return this.getInternalSingle(key);
    }

    private V getFromBucket(int hash, Object keysParam) {
        Object[] currentBuckets = this.buckets;
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, keysParam)) continue;
            return entry.value;
        }
        return null;
    }

    private V getInternalSingle(Object key) {
        Object[] currentBuckets = this.buckets;
        Object lookupKey = key == null ? NULL_SENTINEL : key;
        int hash = MultiKeyMap.computeSingleKeyHash(lookupKey);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !this.isSingleKeyMatch(entry.keys, lookupKey)) continue;
            return entry.value;
        }
        return null;
    }

    private V getInternalArray(Object arrayKey) {
        int length = Array.getLength(arrayKey);
        if (length == 1 && this.getDepth(arrayKey) == 1) {
            Object singleElement = Array.get(arrayKey, 0);
            return this.getInternalSingle(singleElement);
        }
        if (this.isFlatArray(arrayKey)) {
            return this.getInternalArrayDirect(arrayKey);
        }
        if (this.flattenDimensions) {
            ArrayList<Object> flatKeys = new ArrayList<Object>();
            IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
            MultiKeyMap.expandWithBrackets(arrayKey, flatKeys, visited, true);
            if (flatKeys.size() == 1) {
                return this.getInternalSingle(flatKeys.get(0));
            }
            return this.getInternalCollectionDirect(flatKeys);
        }
        Object[] expandedKeys = MultiKeyMap.expandMultiDimensionalArray(arrayKey);
        return this.getInternalMulti(expandedKeys);
    }

    private boolean isFlatArray(Object arrayKey) {
        int length = Array.getLength(arrayKey);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(arrayKey, i);
            if (element == null || !element.getClass().isArray() && !(element instanceof Collection)) continue;
            return false;
        }
        return true;
    }

    private int getDepth(Object element) {
        return this.getDepth(element, 1);
    }

    private int getDepth(Object element, int currentDepth) {
        if (element == null) {
            return currentDepth;
        }
        if (element.getClass().isArray()) {
            int arrayLength = Array.getLength(element);
            if (arrayLength == 0) {
                return currentDepth;
            }
            Object firstElement = Array.get(element, 0);
            return this.getDepth(firstElement, currentDepth + 1);
        }
        if (element instanceof Collection) {
            Collection collection = (Collection)element;
            if (collection.isEmpty()) {
                return currentDepth;
            }
            Object firstElement = collection.iterator().next();
            return this.getDepth(firstElement, currentDepth + 1);
        }
        return currentDepth;
    }

    private V getInternalArrayDirect(Object arrayKey) {
        Object[] currentBuckets = this.buckets;
        int hash = MultiKeyMap.computeHashFromTypedArray(arrayKey);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !this.arrayElementsMatch(entry.keys, arrayKey)) continue;
            return entry.value;
        }
        return null;
    }

    private V getInternalCollection(Collection<?> collection) {
        switch (this.collectionKeyMode) {
            case COLLECTIONS_EXPANDED: {
                if (collection.isEmpty()) {
                    return this.getInternalMulti(new Object[0]);
                }
                V directResult = this.getInternalCollectionDirect(collection);
                if (directResult != null) {
                    return directResult;
                }
                return this.getMultiKey(collection);
            }
            case COLLECTIONS_NOT_EXPANDED: {
                return this.getInternalSingle(collection);
            }
        }
        throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
    }

    private V getInternalMulti(Object[] keys) {
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        int hash = MultiKeyMap.computeHash(expandedKeys);
        return this.getFromBucket(hash, expandedKeys);
    }

    private V getInternalCollectionDirect(Collection<?> collection) {
        if (this.collectionNeedsExpansion(collection)) {
            Collection<?> expandedCollection = this.expandCollectionWithBrackets(collection);
            int hash = MultiKeyMap.computeHashFromCollection(expandedCollection);
            return this.getFromBucketCollection(hash, expandedCollection);
        }
        int hash = MultiKeyMap.computeHashFromCollection(collection);
        return this.getFromBucketCollection(hash, collection);
    }

    private boolean collectionNeedsExpansion(Collection<?> collection) {
        for (Object element : collection) {
            if (element == null || !element.getClass().isArray() && !(element instanceof Collection)) continue;
            return true;
        }
        return false;
    }

    private V getFromBucketCollection(int hash, Collection<?> collection) {
        Object[] currentBuckets = this.buckets;
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, collection)) continue;
            return entry.value;
        }
        return null;
    }

    private boolean isSingleKeyMatch(Object storedKeys, Object singleKey) {
        return MultiKeyMap.keysMatch(storedKeys, singleKey);
    }

    private boolean arrayElementsMatch(Object storedKeys, Object arrayKey) {
        int keyLength;
        if (storedKeys == arrayKey) {
            return true;
        }
        if (!storedKeys.getClass().isArray() || !arrayKey.getClass().isArray()) {
            return false;
        }
        int storedLength = Array.getLength(storedKeys);
        if (storedLength != (keyLength = Array.getLength(arrayKey))) {
            return false;
        }
        if (storedKeys instanceof Object[] && arrayKey instanceof Object[]) {
            return this.arrayElementsMatchObjectArrays((Object[])storedKeys, (Object[])arrayKey);
        }
        if (storedKeys instanceof String[] && arrayKey instanceof String[]) {
            return this.arrayElementsMatchStringArrays((String[])storedKeys, (String[])arrayKey);
        }
        return this.arrayElementsMatchReflective(storedKeys, arrayKey, storedLength);
    }

    private boolean arrayElementsMatchObjectArrays(Object[] stored, Object[] lookup) {
        int len = stored.length;
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(stored[i], lookup[i])) continue;
            return false;
        }
        return true;
    }

    private boolean arrayElementsMatchStringArrays(String[] stored, String[] lookup) {
        int len = stored.length;
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(stored[i], lookup[i])) continue;
            return false;
        }
        return true;
    }

    private boolean arrayElementsMatchReflective(Object stored, Object lookup, int length) {
        for (int i = 0; i < length; ++i) {
            Object lookupElement;
            Object storedElement = Array.get(stored, i);
            if (Objects.equals(storedElement, lookupElement = Array.get(lookup, i))) continue;
            return false;
        }
        return true;
    }

    private boolean containsKeyInternalDirect(Object key) {
        Object[] currentBuckets = this.buckets;
        Object lookupKey = key == null ? NULL_SENTINEL : key;
        int hash = MultiKeyMap.computeSingleKeyHash(lookupKey);
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey entry : chain) {
            if (entry.hash != hash || !this.isSingleKeyMatch(entry.keys, lookupKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean keysMatch(Object storedKeys, Object lookupKeys) {
        boolean lookupIsMulti;
        if (storedKeys == lookupKeys) {
            return true;
        }
        if (storedKeys == null || lookupKeys == null) {
            return false;
        }
        boolean storedIsMulti = storedKeys instanceof Object[] || storedKeys instanceof Collection;
        boolean bl = lookupIsMulti = lookupKeys instanceof Object[] || lookupKeys instanceof Collection || lookupKeys != null && lookupKeys.getClass().isArray();
        if (storedIsMulti != lookupIsMulti) {
            return false;
        }
        if (storedIsMulti) {
            return MultiKeyMap.matchMultiKeys(storedKeys, lookupKeys);
        }
        return Objects.equals(storedKeys, lookupKeys);
    }

    private static boolean matchMultiKeys(Object stored, Object lookup) {
        if (stored instanceof Object[]) {
            Object[] storedArray = (Object[])stored;
            if (lookup instanceof Object[]) {
                return MultiKeyMap.keysEqual(storedArray, (Object[])lookup);
            }
            if (lookup instanceof Collection) {
                return MultiKeyMap.keysEqualCollection(storedArray, (Collection)lookup);
            }
            if (lookup.getClass().isArray()) {
                return MultiKeyMap.keysEqualTypedArray(storedArray, lookup);
            }
        } else if (stored instanceof Collection) {
            Collection storedCollection = (Collection)stored;
            if (lookup instanceof Object[]) {
                return MultiKeyMap.keysEqualCollection((Object[])lookup, storedCollection);
            }
            if (lookup instanceof Collection) {
                return MultiKeyMap.keysEqualCollectionToCollection(storedCollection, (Collection)lookup);
            }
            if (lookup.getClass().isArray()) {
                return MultiKeyMap.keysEqualCollectionToTypedArray(storedCollection, lookup);
            }
        }
        return false;
    }

    private static boolean keysEqual(Object[] keys1, Object[] keys2) {
        if (keys1 == keys2) {
            return true;
        }
        if (keys1 == null || keys2 == null) {
            return false;
        }
        int len1 = keys1.length;
        if (len1 != keys2.length) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (MultiKeyMap.keyEquals(keys1[i], keys2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean keysEqualCollection(Object[] stored, Collection<?> lookup) {
        if (stored.length != lookup.size()) {
            return false;
        }
        int i = 0;
        for (Object lookupKey : lookup) {
            if (!MultiKeyMap.keyEquals(stored[i], lookupKey)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean keysEqualTypedArray(Object[] stored, Object typedArray) {
        int length = Array.getLength(typedArray);
        if (stored.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (MultiKeyMap.keyEquals(stored[i], Array.get(typedArray, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean keysEqualCollectionToCollection(Collection<?> stored, Collection<?> lookup) {
        if (stored.size() != lookup.size()) {
            return false;
        }
        Iterator<?> storedIter = stored.iterator();
        Iterator<?> lookupIter = lookup.iterator();
        while (storedIter.hasNext() && lookupIter.hasNext()) {
            if (MultiKeyMap.keyEquals(storedIter.next(), lookupIter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean keysEqualCollectionToTypedArray(Collection<?> stored, Object typedArray) {
        int length = Array.getLength(typedArray);
        if (stored.size() != length) {
            return false;
        }
        int i = 0;
        for (Object storedKey : stored) {
            if (!MultiKeyMap.keyEquals(storedKey, Array.get(typedArray, i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean keyEquals(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        if (k1 == null || k2 == null) {
            return false;
        }
        if (k1 instanceof Class && k2 instanceof Class || k1 instanceof Executable && k2 instanceof Executable || k1 instanceof Field && k2 instanceof Field || k1 instanceof ClassLoader && k2 instanceof ClassLoader || k1 instanceof Reference && k2 instanceof Reference || k1 instanceof Thread && k2 instanceof Thread) {
            return false;
        }
        return k1.equals(k2);
    }

    public V putMultiKey(V value, Object ... keys) {
        if (keys == null || keys.length == 0) {
            return this.put((Object)null, value);
        }
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        if (expandedKeys.length == 1) {
            return this.put(expandedKeys[0], value);
        }
        MultiKey<V> newKey = new MultiKey<V>(expandedKeys, value);
        return this.putInternalCommon(newKey);
    }

    @Override
    public V put(Object key, V value) {
        MultiKey<V> newKey;
        if (this.flattenDimensions) {
            ArrayList<Object> flatKeys = new ArrayList<Object>();
            IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
            MultiKeyMap.expandWithBrackets(key, flatKeys, visited, true);
            newKey = flatKeys.size() == 1 ? new MultiKey<V>(flatKeys.get(0), value) : new MultiKey<V>(flatKeys, value);
        } else if (key != null && key.getClass().isArray()) {
            Object[] expandedKeys = MultiKeyMap.expandMultiDimensionalArray(key);
            newKey = new MultiKey<V>(expandedKeys, value);
        } else if (key instanceof Collection) {
            Collection collection = (Collection)key;
            switch (this.collectionKeyMode) {
                case COLLECTIONS_EXPANDED: {
                    if (collection.isEmpty()) {
                        newKey = new MultiKey<V>(new Object[0], value);
                        break;
                    }
                    if (!this.collectionNeedsExpansion(collection)) {
                        newKey = new MultiKey<V>(collection, value);
                        break;
                    }
                    Collection<?> expandedCollection = this.expandCollectionWithBrackets(collection);
                    newKey = new MultiKey<V>(expandedCollection, value);
                    break;
                }
                case COLLECTIONS_NOT_EXPANDED: {
                    newKey = new MultiKey<V>(collection, value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
                }
            }
        } else {
            newKey = new MultiKey<V>(key, value);
        }
        return this.putInternalCommon(newKey);
    }

    private V putInternalNoLock(MultiKey<V> newKey) {
        int hash = newKey.hash;
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            this.buckets[bucketIndex] = chain = this.createChain(newKey);
            this.size = this.atomicSize.incrementAndGet();
            if (1 > this.maxChainLength) {
                this.maxChainLength = 1;
            }
            return null;
        }
        int len = chain.length;
        Object newKeys = newKey.keys;
        for (int i = 0; i < len; ++i) {
            MultiKey existing = chain[i];
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, newKeys)) continue;
            Object oldValue = existing.value;
            chain[i] = newKey;
            return oldValue;
        }
        this.buckets[bucketIndex] = chain = this.growChain(chain, newKey);
        this.size = this.atomicSize.incrementAndGet();
        if (chain.length > this.maxChainLength) {
            this.maxChainLength = chain.length;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putInternalCommon(MultiKey<V> newKey) {
        int hash = newKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        int stripeIndex = hash & STRIPE_MASK;
        boolean resizeNeeded = false;
        V oldValue = null;
        boolean wasContended = lock.hasQueuedThreads();
        lock.lock();
        try {
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripeIndex].incrementAndGet();
            if (wasContended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripeIndex].incrementAndGet();
            }
            oldValue = this.putInternalNoLock(newKey);
            resizeNeeded = (float)this.size > (float)this.buckets.length * this.loadFactor;
        }
        finally {
            lock.unlock();
        }
        if (resizeNeeded && this.resizeInProgress.compareAndSet(false, true)) {
            try {
                this.resize();
            }
            finally {
                this.resizeInProgress.set(false);
            }
        }
        return oldValue;
    }

    private V getInternalCommon(MultiKey<V> lookupKey) {
        Object[] currentBuckets = this.buckets;
        int hash = lookupKey.hash;
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        for (MultiKey existing : chain) {
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, lookupKey.keys)) continue;
            return existing.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeInternalCommon(MultiKey<V> removeKey) {
        int hash = removeKey.hash;
        ReentrantLock lock = this.getStripeLock(hash);
        int stripeIndex = hash & STRIPE_MASK;
        V oldValue = null;
        boolean wasContended = lock.hasQueuedThreads();
        lock.lock();
        try {
            this.totalLockAcquisitions.incrementAndGet();
            this.stripeLockAcquisitions[stripeIndex].incrementAndGet();
            if (wasContended) {
                this.contentionCount.incrementAndGet();
                this.stripeLockContention[stripeIndex].incrementAndGet();
            }
            oldValue = this.removeInternalNoLock(removeKey);
        }
        finally {
            lock.unlock();
        }
        return oldValue;
    }

    private boolean containsKeyInternalCommon(MultiKey<V> lookupKey) {
        Object[] currentBuckets = this.buckets;
        int hash = lookupKey.hash;
        int bucketIndex = hash & currentBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])currentBuckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        Object lookupKeys = lookupKey.keys;
        for (MultiKey existing : chain) {
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, lookupKeys)) continue;
            return true;
        }
        return false;
    }

    public static Object[] expandMultiDimensionalArray(Object sourceArrayOrCollection) {
        if (sourceArrayOrCollection == null) {
            return new Object[]{null};
        }
        if (sourceArrayOrCollection instanceof Collection) {
            Collection collection = (Collection)sourceArrayOrCollection;
            if (collection.isEmpty()) {
                return new Object[0];
            }
            sourceArrayOrCollection = collection.toArray();
        }
        if (!sourceArrayOrCollection.getClass().isArray()) {
            return new Object[]{sourceArrayOrCollection};
        }
        int length = Array.getLength(sourceArrayOrCollection);
        boolean isFlat = true;
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(sourceArrayOrCollection, i);
            if (element == null || !element.getClass().isArray() && !(element instanceof Collection)) continue;
            isFlat = false;
            break;
        }
        if (isFlat) {
            if (sourceArrayOrCollection instanceof Object[]) {
                return sourceArrayOrCollection;
            }
            Object[] result = new Object[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Array.get(sourceArrayOrCollection, i);
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
        MultiKeyMap.expandWithBrackets(sourceArrayOrCollection, result, visited, false);
        return result.toArray(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expandWithBrackets(Object current, List<Object> result, IdentityHashMap<Object, Boolean> visited, boolean flattenDimensions) {
        if (current == null) {
            result.add(null);
            return;
        }
        if (current instanceof Collection) {
            Collection collection = (Collection)current;
            if (visited.containsKey(current)) {
                result.add("CYCLE_DETECTED:" + System.identityHashCode(current));
                return;
            }
            if (collection.isEmpty()) {
                result.add("EMPTY_COLLECTION");
                return;
            }
            visited.put(current, Boolean.TRUE);
            try {
                if (!flattenDimensions) {
                    result.add(BRACKET_OPEN);
                }
                for (Object element : collection) {
                    MultiKeyMap.expandWithBrackets(element, result, visited, flattenDimensions);
                }
                if (!flattenDimensions) {
                    result.add(BRACKET_CLOSE);
                }
            }
            finally {
                visited.remove(current);
            }
            return;
        }
        if (current.getClass().isArray()) {
            if (visited.containsKey(current)) {
                result.add("CYCLE_DETECTED:" + System.identityHashCode(current));
                return;
            }
            visited.put(current, Boolean.TRUE);
            try {
                if (!flattenDimensions) {
                    result.add(BRACKET_OPEN);
                }
                int len = Array.getLength(current);
                for (int i = 0; i < len; ++i) {
                    Object element = Array.get(current, i);
                    MultiKeyMap.expandWithBrackets(element, result, visited, flattenDimensions);
                }
                if (!flattenDimensions) {
                    result.add(BRACKET_CLOSE);
                }
            }
            finally {
                visited.remove(current);
            }
            return;
        }
        result.add(current);
    }

    public static Object get1DKey(Object arrayOrCollection) {
        return MultiKeyMap.get1DKey(arrayOrCollection, CollectionKeyMode.COLLECTIONS_EXPANDED);
    }

    public static Object get1DKey(Object arrayOrCollection, CollectionKeyMode collectionKeyMode) {
        if (arrayOrCollection == null) {
            return new Object[]{null};
        }
        if (arrayOrCollection instanceof Collection) {
            Collection collection = (Collection)arrayOrCollection;
            if (collectionKeyMode == CollectionKeyMode.COLLECTIONS_NOT_EXPANDED) {
                return collection;
            }
            if (collection.isEmpty()) {
                return new Object[0];
            }
            Object[] arrayFromCollection = collection.toArray();
            return MultiKeyMap.get1DKey(arrayFromCollection, collectionKeyMode);
        }
        if (!arrayOrCollection.getClass().isArray()) {
            return new Object[]{arrayOrCollection};
        }
        Class<?> componentType = arrayOrCollection.getClass().getComponentType();
        if (!componentType.isArray()) {
            if (arrayOrCollection instanceof Object[]) {
                Object[] objArray;
                for (Object element : objArray = (Object[])arrayOrCollection) {
                    if (element == null || !element.getClass().isArray() && !(element instanceof Collection)) continue;
                    Object[] expanded = MultiKeyMap.expandMultiDimensionalArray(arrayOrCollection);
                    return expanded;
                }
                return objArray;
            }
            return arrayOrCollection;
        }
        return MultiKeyMap.expandMultiDimensionalArray(arrayOrCollection);
    }

    public static String computeSHA1Hash(Object key1D) {
        Object[] keyArray;
        if (key1D == null) {
            return "sha1:" + EncryptionUtilities.calculateSHA1Hash(new byte[0]);
        }
        if (key1D.getClass().isArray()) {
            if (key1D instanceof Object[]) {
                keyArray = (Object[])key1D;
            } else {
                int len = Array.getLength(key1D);
                keyArray = new Object[len];
                for (int i = 0; i < len; ++i) {
                    keyArray[i] = Array.get(key1D, i);
                }
            }
        } else {
            keyArray = new Object[]{key1D};
        }
        if (keyArray.length == 0) {
            return "sha1:" + EncryptionUtilities.calculateSHA1Hash(new byte[0]);
        }
        StringBuilder keySequence = new StringBuilder();
        int len = keyArray.length;
        for (int i = 0; i < len; ++i) {
            Object key;
            if (i > 0) {
                keySequence.append("|");
            }
            if ((key = keyArray[i]) == null) {
                keySequence.append("NULL");
                continue;
            }
            if (BRACKET_OPEN.equals(key)) {
                keySequence.append(BRACKET_OPEN);
                continue;
            }
            if (BRACKET_CLOSE.equals(key)) {
                keySequence.append(BRACKET_CLOSE);
                continue;
            }
            if (ClassUtilities.isPrimitive(key.getClass()) || key instanceof Number) {
                keySequence.append(key);
                continue;
            }
            String str = key.toString();
            if (str.contains("@") && str.matches(".*@[0-9a-fA-F]+$")) {
                keySequence.append(key.getClass().getName()).append(":").append(key.hashCode());
                continue;
            }
            keySequence.append(key.getClass().getName()).append(":").append(str);
        }
        byte[] keyBytes = keySequence.toString().getBytes(StandardCharsets.UTF_8);
        return "sha1:" + EncryptionUtilities.calculateSHA1Hash(keyBytes);
    }

    private static Object[] expandArraysInKeySequence(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return keys;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object key : keys) {
            if (key != null && (key.getClass().isArray() || key instanceof Collection)) {
                boolean isFlat;
                Object[] expanded = MultiKeyMap.expandMultiDimensionalArray(key);
                boolean bl = isFlat = expanded.length == 0 || !BRACKET_OPEN.equals(expanded[0]);
                if (isFlat && keys.length > 1) {
                    result.add(1);
                    result.addAll(Arrays.asList(expanded));
                    result.add(1);
                    continue;
                }
                result.addAll(Arrays.asList(expanded));
                continue;
            }
            result.add(key);
        }
        return result.toArray(new Object[0]);
    }

    private Object[] expandKeySequenceWithFlattenSupport(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return keys;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
        for (Object key : keys) {
            if (key != null && (key.getClass().isArray() || key instanceof Collection)) {
                MultiKeyMap.expandWithBrackets(key, result, visited, this.flattenDimensions);
                continue;
            }
            result.add(key);
        }
        return result.toArray(new Object[0]);
    }

    private MultiKey<V>[] createChain(MultiKey<V> key) {
        return new MultiKey[]{key};
    }

    private MultiKey<V>[] growChain(MultiKey<V>[] oldChain, MultiKey<V> newKey) {
        MultiKey<V>[] newChain = Arrays.copyOf(oldChain, oldChain.length + 1);
        newChain[oldChain.length] = newKey;
        return newChain;
    }

    private int rehashEntry(MultiKey<V> entry, Object[] targetBuckets) {
        int bucketIndex = entry.hash & targetBuckets.length - 1;
        MultiKey[] chain = (MultiKey[])targetBuckets[bucketIndex];
        if (chain == null) {
            targetBuckets[bucketIndex] = this.createChain(entry);
            return 1;
        }
        targetBuckets[bucketIndex] = chain = this.growChain(chain, entry);
        return chain.length;
    }

    @Override
    public int size() {
        return this.atomicSize.get();
    }

    public int getMaxChainLength() {
        return this.maxChainLength;
    }

    public double getLoadFactor() {
        return (double)this.size / (double)this.buckets.length;
    }

    public Iterable<MultiKeyEntry<V>> entries() {
        return new EntryIterable();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (!Objects.equals(entry.value, value)) continue;
            return true;
        }
        return false;
    }

    public V removeMultiKey(Object ... keys) {
        if (keys == null) {
            return this.remove(null);
        }
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        if (expandedKeys.length == 1) {
            return this.remove(expandedKeys[0]);
        }
        MultiKey<Object> removeKey = new MultiKey<Object>(expandedKeys, null);
        return this.removeInternalCommon(removeKey);
    }

    @Override
    public V remove(Object key) {
        MultiKey<Object> removeKey;
        if (key == null) {
            removeKey = new MultiKey<Object>(key, null);
        } else if (key.getClass().isArray()) {
            if (this.flattenDimensions) {
                ArrayList<Object> flatKeys = new ArrayList<Object>();
                IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
                MultiKeyMap.expandWithBrackets(key, flatKeys, visited, true);
                removeKey = flatKeys.size() == 1 ? new MultiKey<Object>(flatKeys.get(0), null) : new MultiKey<Object>(flatKeys, null);
            } else {
                Object[] expandedKeys = MultiKeyMap.expandMultiDimensionalArray(key);
                removeKey = new MultiKey<Object>(expandedKeys, null);
            }
        } else if (key instanceof Collection) {
            Collection collection = (Collection)key;
            switch (this.collectionKeyMode) {
                case COLLECTIONS_EXPANDED: {
                    if (collection.isEmpty()) {
                        removeKey = new MultiKey<Object>(new Object[0], null);
                        break;
                    }
                    if (!this.collectionNeedsExpansion(collection)) {
                        removeKey = new MultiKey<Object>(collection, null);
                        break;
                    }
                    Collection<?> expandedCollection = this.expandCollectionWithBrackets(collection);
                    removeKey = new MultiKey<Object>(expandedCollection, null);
                    break;
                }
                case COLLECTIONS_NOT_EXPANDED: {
                    removeKey = new MultiKey<Object>(collection, null);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
                }
            }
        } else {
            removeKey = new MultiKey<Object>(key, null);
        }
        return this.removeInternalCommon(removeKey);
    }

    @Override
    public void putAll(Map<?, ? extends V> m) {
        for (Map.Entry<?, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(Object key, V value) {
        V existing = this.get(key);
        if (existing != null) {
            return existing;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            existing = this.get(key);
            if (existing == null) {
                this.put(key, value);
                V v = null;
                return v;
            }
            V v = existing;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(Object key, Function<? super Object, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction, "mappingFunction must not be null");
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V newValue;
            value = this.get(key);
            if (value == null && (newValue = mappingFunction.apply(key)) != null) {
                this.put(key, newValue);
                V v = newValue;
                return v;
            }
            V v = value;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        V oldValue = this.get(key);
        if (oldValue == null) {
            return null;
        }
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            oldValue = this.get(key);
            if (oldValue == null) {
                V v = null;
                return v;
            }
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.put(key, newValue);
                V v = newValue;
                return v;
            }
            this.remove(key);
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(Object key, BiFunction<? super Object, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            boolean contains = this.containsKey(key);
            V oldValue = this.get(key);
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue == null) {
                if (contains) {
                    this.remove(key);
                }
                V v = null;
                return v;
            }
            this.put(key, newValue);
            V v = newValue;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            V current = this.get(key);
            if (!Objects.equals(current, value)) {
                boolean bl = false;
                return bl;
            }
            this.remove(key);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(Object key, V value) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                V v = null;
                return v;
            }
            V v = this.put(key, value);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, V oldValue, V newValue) {
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            if (!this.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            V current = this.get(key);
            if (!Objects.equals(current, oldValue)) {
                boolean bl = false;
                return bl;
            }
            this.put(key, newValue);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(Object key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction, "remappingFunction must not be null");
        Objects.requireNonNull(value, "value must not be null");
        int hash = this.computeKeyHash(key);
        ReentrantLock lock = this.getStripeLock(hash);
        lock.lock();
        try {
            V newValue;
            V oldValue = this.get(key);
            V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
            if (newValue == null) {
                this.remove(key);
            } else {
                this.put(key, newValue);
            }
            V v2 = newValue;
            return v2;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean containsMultiKey(Object ... keys) {
        if (keys == null) {
            return this.containsKey(null);
        }
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        if (expandedKeys.length == 1 && (this.flattenDimensions || expandedKeys[0] instanceof CaseInsensitiveMap.CaseInsensitiveString)) {
            return this.containsKey(expandedKeys[0]);
        }
        MultiKey<Object> lookupKey = new MultiKey<Object>(expandedKeys, null);
        return this.containsKeyInternalCommon(lookupKey);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.flattenDimensions) {
            ArrayList<Object> flatKeys = new ArrayList<Object>();
            IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
            MultiKeyMap.expandWithBrackets(key, flatKeys, visited, true);
            if (flatKeys.size() == 1) {
                return this.containsKeyInternalDirect(flatKeys.get(0));
            }
            return this.containsKeyInternalCollection(flatKeys);
        }
        if (key == null) {
            return this.containsKeyInternalDirect(null);
        }
        if (key.getClass().isArray()) {
            Object[] expandedKeys = MultiKeyMap.expandMultiDimensionalArray(key);
            return this.containsKeyInternal(expandedKeys);
        }
        if (key instanceof Collection) {
            Collection collection = (Collection)key;
            switch (this.collectionKeyMode) {
                case COLLECTIONS_EXPANDED: {
                    if (collection.isEmpty()) {
                        return this.containsKeyInternal(new Object[0]);
                    }
                    if (!this.collectionNeedsExpansion(collection)) {
                        return this.containsKeyInternalCollection(collection);
                    }
                    Collection<?> expandedCollection = this.expandCollectionWithBrackets(collection);
                    return this.containsKeyInternalCollection(expandedCollection);
                }
                case COLLECTIONS_NOT_EXPANDED: {
                    return this.containsKeyInternalDirect(collection);
                }
            }
            throw new IllegalStateException("Unknown CollectionKeyMode: " + (Object)((Object)this.collectionKeyMode));
        }
        return this.containsKeyInternalDirect(key);
    }

    private boolean containsKeyInternal(Object[] keys) {
        Object[] expandedKeys = this.expandKeySequenceWithFlattenSupport(keys);
        int hash = MultiKeyMap.computeHash(expandedKeys);
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey existing : chain) {
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, expandedKeys)) continue;
            return true;
        }
        return false;
    }

    private boolean containsKeyInternalCollection(Collection<?> collection) {
        int hash = MultiKeyMap.computeHashFromCollection(collection);
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return false;
        }
        for (MultiKey existing : chain) {
            if (existing.hash != hash || !MultiKeyMap.keysMatch(existing.keys, collection)) continue;
            return true;
        }
        return false;
    }

    private Collection<?> expandCollectionWithBrackets(Collection<?> collection) {
        ArrayList<Object> result = new ArrayList<Object>();
        IdentityHashMap<Object, Boolean> visited = new IdentityHashMap<Object, Boolean>();
        for (Object element : collection) {
            this.expandWithBracketsToCollection(element, result, visited);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expandWithBracketsToCollection(Object element, List<Object> result, IdentityHashMap<Object, Boolean> visited) {
        if (element == null) {
            result.add(null);
            return;
        }
        if (visited.containsKey(element)) {
            result.add(element);
            return;
        }
        if (element.getClass().isArray()) {
            visited.put(element, Boolean.TRUE);
            try {
                int length = Array.getLength(element);
                if (length == 0) {
                    result.add(element);
                    return;
                }
                if (!this.flattenDimensions) {
                    result.add(BRACKET_OPEN);
                }
                for (int i = 0; i < length; ++i) {
                    Object item = Array.get(element, i);
                    this.expandWithBracketsToCollection(item, result, visited);
                }
                if (this.flattenDimensions) return;
                result.add(BRACKET_CLOSE);
                return;
            }
            finally {
                visited.remove(element);
            }
        } else if (element instanceof Collection) {
            Collection collection = (Collection)element;
            visited.put(element, Boolean.TRUE);
            try {
                if (collection.isEmpty()) {
                    result.add(element);
                    return;
                }
                if (!this.flattenDimensions) {
                    result.add(BRACKET_OPEN);
                }
                for (Object item : collection) {
                    this.expandWithBracketsToCollection(item, result, visited);
                }
                if (this.flattenDimensions) return;
                result.add(BRACKET_CLOSE);
                return;
            }
            finally {
                visited.remove(element);
            }
        } else {
            result.add(element);
        }
    }

    @Override
    public void clear() {
        this.withAllStripeLocks(() -> {
            Arrays.fill(this.buckets, null);
            this.atomicSize.set(0);
            this.size = 0;
            this.maxChainLength = 0;
        });
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        for (MultiKeyEntry<V> entry : this.entries()) {
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public Set<Object> keySet() {
        HashSet<Object> keys = new HashSet<Object>();
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (entry.keys.length == 1) {
                Object singleKey = entry.keys[0];
                Object originalKey = singleKey == NULL_SENTINEL ? null : singleKey;
                keys.add(originalKey);
                continue;
            }
            keys.add(entry.keys);
        }
        return keys;
    }

    @Override
    public Set<Map.Entry<Object, V>> entrySet() {
        HashSet<Map.Entry<Object, V>> entrySet = new HashSet<Map.Entry<Object, V>>();
        for (MultiKeyEntry<V> multiEntry : this.entries()) {
            Object singleKey;
            Object key = multiEntry.keys.length == 1 ? ((singleKey = multiEntry.keys[0]) == NULL_SENTINEL ? null : singleKey) : multiEntry.keys;
            entrySet.add(new AbstractMap.SimpleEntry((Object[])key, multiEntry.value));
        }
        return entrySet;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (MultiKeyEntry<V> entry : this.entries()) {
            Object singleKey;
            Object key = entry.keys.length == 1 ? ((singleKey = entry.keys[0]) == NULL_SENTINEL ? null : singleKey) : Integer.valueOf(Arrays.hashCode(entry.keys));
            int keyHash = key == null ? 0 : key.hashCode();
            int valueHash = entry.value == null ? 0 : entry.value.hashCode();
            hash += keyHash ^ valueHash;
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        try {
            for (MultiKeyEntry<V> entry : this.entries()) {
                Object singleKey;
                Object key = entry.keys.length == 1 ? ((singleKey = entry.keys[0]) == NULL_SENTINEL ? null : singleKey) : entry.keys;
                Object value = entry.value;
                if (!(value == null ? other.get(key) != null || !other.containsKey(key) : !value.equals(other.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (MultiKeyEntry<V> entry : this.entries()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (entry.keys.length == 1) {
                Object singleKey = entry.keys[0];
                Object originalKey = singleKey == NULL_SENTINEL ? null : singleKey;
                this.appendSafeKey(sb, originalKey);
            } else {
                this.appendSafeMultiKey(sb, entry.keys);
            }
            sb.append('=');
            this.appendSafeValue(sb, entry.value);
        }
        return sb.append('}').toString();
    }

    private void appendSafeKey(StringBuilder sb, Object key) {
        if (key == this) {
            sb.append("(this Map)");
        } else {
            sb.append(key);
        }
    }

    private void appendSafeMultiKey(StringBuilder sb, Object[] keys) {
        sb.append('[');
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (keys[i] == this) {
                sb.append("(this Map)");
                continue;
            }
            sb.append(keys[i]);
        }
        sb.append(']');
    }

    private void appendSafeValue(StringBuilder sb, Object value) {
        if (value == this) {
            sb.append("(this Map)");
        } else {
            sb.append(value);
        }
    }

    private static int calculateOptimalStripeCount() {
        int cores = Runtime.getRuntime().availableProcessors();
        int targetStripes = Math.max(8, cores / 2);
        targetStripes = Math.min(32, targetStripes);
        return Integer.highestOneBit(targetStripes - 1) << 1;
    }

    public void printContentionStatistics() {
        int totalAcquisitions = this.totalLockAcquisitions.get();
        int totalContentions = this.contentionCount.get();
        int globalAcquisitions = this.globalLockAcquisitions.get();
        int globalContentions = this.globalLockContentions.get();
        LOG.info("=== MultiKeyMap Contention Statistics ===");
        LOG.info("Total lock acquisitions: " + totalAcquisitions);
        LOG.info("Total contentions: " + totalContentions);
        if (totalAcquisitions > 0) {
            double contentionRate = (double)totalContentions / (double)totalAcquisitions * 100.0;
            LOG.info(String.format("Overall contention rate: %.2f%%", contentionRate));
        }
        LOG.info("Global lock acquisitions: " + globalAcquisitions);
        LOG.info("Global lock contentions: " + globalContentions);
        LOG.info("Stripe-level statistics:");
        LOG.info("Stripe | Acquisitions | Contentions | Rate");
        LOG.info("-------|-------------|-------------|------");
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            int acquisitions = this.stripeLockAcquisitions[i].get();
            int contentions = this.stripeLockContention[i].get();
            double rate = acquisitions > 0 ? (double)contentions / (double)acquisitions * 100.0 : 0.0;
            LOG.info(String.format("%6d | %11d | %11d | %5.2f%%", i, acquisitions, contentions, rate));
        }
        int maxContentionStripe = 0;
        int minContentionStripe = 0;
        int maxContentions = this.stripeLockContention[0].get();
        int minContentions = this.stripeLockContention[0].get();
        for (int i = 1; i < STRIPE_COUNT; ++i) {
            int contentions = this.stripeLockContention[i].get();
            if (contentions > maxContentions) {
                maxContentions = contentions;
                maxContentionStripe = i;
            }
            if (contentions >= minContentions) continue;
            minContentions = contentions;
            minContentionStripe = i;
        }
        LOG.info("Stripe distribution analysis:");
        LOG.info(String.format("Most contended stripe: %d (%d contentions)", maxContentionStripe, maxContentions));
        LOG.info(String.format("Least contended stripe: %d (%d contentions)", minContentionStripe, minContentions));
        int unusedStripes = 0;
        for (int i = 0; i < STRIPE_COUNT; ++i) {
            if (this.stripeLockAcquisitions[i].get() != 0) continue;
            ++unusedStripes;
        }
        LOG.info(String.format("Unused stripes: %d out of %d", unusedStripes, STRIPE_COUNT));
        LOG.info("================================================");
    }

    private int computeKeyHash(Object key) {
        return MultiKeyMap.computeHashForKey(key);
    }

    private void withAllStripeLocks(Runnable action) {
        this.lockAllStripes();
        try {
            action.run();
        }
        finally {
            this.unlockAllStripes();
        }
    }

    private void resize() {
        this.withAllStripeLocks(() -> {
            double currentLoadFactor = (double)this.size / (double)this.buckets.length;
            if (currentLoadFactor <= (double)this.loadFactor) {
                return;
            }
            Object[] oldBuckets = this.buckets;
            Object[] newBuckets = new Object[oldBuckets.length * 2];
            int newSize = 0;
            int newMaxChainLength = 0;
            for (Object bucket : oldBuckets) {
                MultiKey[] chain;
                if (bucket == null) continue;
                for (MultiKey entry : chain = (MultiKey[])bucket) {
                    int len = this.rehashEntry(entry, newBuckets);
                    ++newSize;
                    if (len <= newMaxChainLength) continue;
                    newMaxChainLength = len;
                }
            }
            this.buckets = newBuckets;
            this.atomicSize.set(newSize);
            this.size = newSize;
            this.maxChainLength = newMaxChainLength;
        });
    }

    private V removeInternalNoLock(MultiKey<V> removeKey) {
        int hash = removeKey.hash;
        int bucketIndex = hash & this.buckets.length - 1;
        MultiKey[] chain = (MultiKey[])this.buckets[bucketIndex];
        if (chain == null) {
            return null;
        }
        int chainLength = chain.length;
        Object removeKeys = removeKey.keys;
        for (int i = 0; i < chainLength; ++i) {
            int newSize;
            MultiKey entry = chain[i];
            if (entry.hash != hash || !MultiKeyMap.keysMatch(entry.keys, removeKeys)) continue;
            if (chain.length == 1) {
                this.buckets[bucketIndex] = null;
            } else {
                MultiKey[] newChain = new MultiKey[chain.length - 1];
                System.arraycopy(chain, 0, newChain, 0, i);
                if (i < chain.length - 1) {
                    System.arraycopy(chain, i + 1, newChain, i, chain.length - i - 1);
                }
                this.buckets[bucketIndex] = newChain;
            }
            this.size = newSize = this.atomicSize.decrementAndGet();
            return entry.value;
        }
        return null;
    }

    static {
        LoggingConfig.init();
        STRIPE_CONFIG_LOGGED = new AtomicBoolean(false);
        STRIPE_COUNT = MultiKeyMap.calculateOptimalStripeCount();
        STRIPE_MASK = STRIPE_COUNT - 1;
        NULL_SENTINEL = new Object();
    }

    public static enum CollectionKeyMode {
        COLLECTIONS_EXPANDED,
        COLLECTIONS_NOT_EXPANDED;

    }

    private static final class MultiKey<V> {
        final Object keys;
        final int hash;
        final V value;

        MultiKey(Object singleKey, V value) {
            this.keys = singleKey == null ? NULL_SENTINEL : singleKey;
            this.hash = MultiKeyMap.computeSingleKeyHash(this.keys);
            this.value = value;
        }

        MultiKey(Object[] multiKeys, V value) {
            this.keys = multiKeys != null ? multiKeys.clone() : new Object[]{};
            this.hash = MultiKeyMap.computeHash(multiKeys);
            this.value = value;
        }

        MultiKey(Collection<?> multiKeys, V value) {
            this.keys = multiKeys != null ? multiKeys : new ArrayList(0);
            this.hash = MultiKeyMap.computeHashFromCollection(multiKeys);
            this.value = value;
        }
    }

    private class EntryIterable
    implements Iterable<MultiKeyEntry<V>> {
        private EntryIterable() {
        }

        @Override
        public Iterator<MultiKeyEntry<V>> iterator() {
            return new EntryIterator();
        }
    }

    public static class MultiKeyEntry<V> {
        public final Object[] keys;
        public final V value;

        MultiKeyEntry(Object keys, V value) {
            this.keys = keys instanceof Object[] ? (Object[])((Object[])keys).clone() : new Object[]{keys};
            this.value = value;
        }
    }

    private class EntryIterator
    implements Iterator<MultiKeyEntry<V>> {
        private final Object[] bucketSnapshot;
        private int currentBucket = 0;
        private int currentChainIndex = 0;
        private MultiKeyEntry<V> nextEntry = null;

        EntryIterator() {
            this.bucketSnapshot = MultiKeyMap.this.buckets;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public MultiKeyEntry<V> next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            MultiKeyEntry result = this.nextEntry;
            this.advance();
            return result;
        }

        private void advance() {
            while (this.currentBucket < this.bucketSnapshot.length) {
                MultiKey[] chain = (MultiKey[])this.bucketSnapshot[this.currentBucket];
                if (chain != null && this.currentChainIndex < chain.length) {
                    MultiKey key = chain[this.currentChainIndex];
                    this.nextEntry = new MultiKeyEntry(key.keys, key.value);
                    ++this.currentChainIndex;
                    return;
                }
                ++this.currentBucket;
                this.currentChainIndex = 0;
            }
            this.nextEntry = null;
        }
    }
}

