/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

final class RectangleConversions {
    private RectangleConversions() {
    }

    static String toString(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return "(" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("x", rectangle.x);
        target.put("y", rectangle.y);
        target.put("width", rectangle.width);
        target.put("height", rectangle.height);
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
    }

    static Long toLong(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return (long)rectangle.width * (long)rectangle.height;
    }

    static Integer toInteger(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return rectangle.width * rectangle.height;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return BigInteger.valueOf((long)rectangle.width * (long)rectangle.height);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return BigDecimal.valueOf((long)rectangle.width * (long)rectangle.height);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return rectangle.x != 0 || rectangle.y != 0 || rectangle.width != 0 || rectangle.height != 0;
    }

    static Point toPoint(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Point(rectangle.x, rectangle.y);
    }

    static Dimension toDimension(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Dimension(rectangle.width, rectangle.height);
    }

    static Insets toInsets(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Insets(rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width);
    }
}

