/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

final class DimensionConversions {
    private DimensionConversions() {
    }

    static String toString(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.width + "x" + dimension.height;
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("width", dimension.width);
        target.put("height", dimension.height);
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new int[]{dimension.width, dimension.height};
    }

    static Integer toInteger(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.width * dimension.height;
    }

    static Long toLong(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return (long)dimension.width * (long)dimension.height;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return BigInteger.valueOf((long)dimension.width * (long)dimension.height);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return BigDecimal.valueOf((long)dimension.width * (long)dimension.height);
    }

    static Point toPoint(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new Point(dimension.width, dimension.height);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return dimension.width != 0 || dimension.height != 0;
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    static Insets toInsets(Object from, Converter converter) {
        Dimension dimension = (Dimension)from;
        int value = Math.min(dimension.width, dimension.height);
        return new Insets(value, value, value, value);
    }
}

