/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class SystemUtilities {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final Logger LOG = Logger.getLogger(SystemUtilities.class.getName());

    private SystemUtilities() {
    }

    public static String getExternalVariable(String var) {
        if (StringUtilities.isEmpty(var)) {
            return null;
        }
        String value = System.getProperty(var);
        if (StringUtilities.isEmpty(value)) {
            value = System.getenv(var);
        }
        return StringUtilities.isEmpty(value) ? null : value;
    }

    public static int getAvailableProcessors() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    public static MemoryInfo getMemoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        return new MemoryInfo(runtime.totalMemory(), runtime.freeMemory(), runtime.maxMemory());
    }

    public static double getSystemLoadAverage() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public static boolean isJavaVersionAtLeast(int major, int minor) {
        int[] version = SystemUtilities.parseJavaVersionNumbers();
        int majorVersion = version[0];
        int minorVersion = version[1];
        return majorVersion > major || majorVersion == major && minorVersion >= minor;
    }

    public static int currentJdkMajorVersion() {
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object v = versionMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
            Method major = v.getClass().getMethod("major", new Class[0]);
            return (Integer)major.invoke(v, new Object[0]);
        }
        catch (Exception ignored) {
            String spec = System.getProperty("java.specification.version");
            return spec.startsWith("1.") ? Integer.parseInt(spec.substring(2)) : Integer.parseInt(spec);
        }
    }

    private static int[] parseJavaVersionNumbers() {
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object v = versionMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
            Method majorMethod = v.getClass().getMethod("major", new Class[0]);
            Method minorMethod = v.getClass().getMethod("minor", new Class[0]);
            int major = (Integer)majorMethod.invoke(v, new Object[0]);
            int minor = (Integer)minorMethod.invoke(v, new Object[0]);
            return new int[]{major, minor};
        }
        catch (Exception ignored) {
            String[] parts = JAVA_VERSION.split("\\.");
            int major = Integer.parseInt(parts[0]);
            int minor = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            return new int[]{major, minor};
        }
    }

    public static long getCurrentProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return 0L;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException ignored) {
            return 0L;
        }
    }

    public static File createTempDirectory(String prefix) {
        try {
            File tempDir = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
            tempDir.deleteOnExit();
            return tempDir.getCanonicalFile();
        }
        catch (IOException e) {
            ExceptionUtilities.uncheckedThrow(e);
            return null;
        }
    }

    public static TimeZone getSystemTimeZone() {
        String tzEnv = System.getenv("TZ");
        if (tzEnv != null && !tzEnv.isEmpty()) {
            return TimeZone.getTimeZone(tzEnv);
        }
        return TimeZone.getDefault();
    }

    public static boolean hasAvailableMemory(long requiredBytes) {
        MemoryInfo info = SystemUtilities.getMemoryInfo();
        return info.getFreeMemory() >= requiredBytes;
    }

    public static Map<String, String> getEnvironmentVariables(Predicate<String> filter) {
        return System.getenv().entrySet().stream().filter(e -> filter == null || filter.test((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new));
    }

    public static List<NetworkInfo> getNetworkInterfaces() {
        ArrayList<NetworkInfo> interfaces = new ArrayList<NetworkInfo>();
        Enumeration<NetworkInterface> en = null;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            ExceptionUtilities.uncheckedThrow(e);
        }
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            try {
                if (!ni.isUp()) continue;
                ArrayList<InetAddress> addresses = Collections.list(ni.getInetAddresses());
                interfaces.add(new NetworkInfo(ni.getName(), ni.getDisplayName(), addresses, ni.isLoopback()));
            }
            catch (SocketException e) {
                LOG.log(Level.WARNING, "Failed to inspect network interface " + ni.getName(), e);
            }
        }
        return interfaces;
    }

    public static void addShutdownHook(Runnable hook) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                hook.run();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Shutdown hook threw exception", e);
            }
        }));
    }

    static {
        LoggingConfig.init();
    }

    public static class MemoryInfo {
        private final long totalMemory;
        private final long freeMemory;
        private final long maxMemory;

        public MemoryInfo(long totalMemory, long freeMemory, long maxMemory) {
            this.totalMemory = totalMemory;
            this.freeMemory = freeMemory;
            this.maxMemory = maxMemory;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }
    }

    public static class NetworkInfo {
        private final String name;
        private final String displayName;
        private final List<InetAddress> addresses;
        private final boolean loopback;

        public NetworkInfo(String name, String displayName, List<InetAddress> addresses, boolean loopback) {
            this.name = name;
            this.displayName = displayName;
            ArrayList<InetAddress> safe = addresses == null ? Collections.emptyList() : new ArrayList<InetAddress>(addresses);
            this.addresses = Collections.unmodifiableList(safe);
            this.loopback = loopback;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<InetAddress> getAddresses() {
            return this.addresses;
        }

        public boolean isLoopback() {
            return this.loopback;
        }
    }

    public static class ProcessResult {
        private final int exitCode;
        private final String output;
        private final String error;

        public ProcessResult(int exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.output = output;
            this.error = error;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public String getError() {
            return this.error;
        }
    }
}

