/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.Arrays;

public final class ByteUtilities {
    static final char[] HEX_ARRAY;
    private static final int[] HEX_LOOKUP;

    private ByteUtilities() {
    }

    public static char toHexChar(int value) {
        return HEX_ARRAY[value & 0xF];
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if ((len & 1) != 0) {
            return null;
        }
        byte[] bytes = new byte[len >> 1];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            char c1 = s.charAt(i);
            char c2 = s.charAt(i + 1);
            if (c1 >= HEX_LOOKUP.length || c2 >= HEX_LOOKUP.length) {
                return null;
            }
            int hi = HEX_LOOKUP[c1];
            int lo = HEX_LOOKUP[c2];
            if (hi == -1 || lo == -1) {
                return null;
            }
            bytes[j++] = (byte)(hi << 4 | lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[j++] = HEX_ARRAY[v >>> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static boolean isGzipped(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117;
    }

    static {
        int c;
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        HEX_LOOKUP = new int[128];
        Arrays.fill(HEX_LOOKUP, -1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = c - 48;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 65);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            ByteUtilities.HEX_LOOKUP[c] = 10 + (c - 97);
        }
    }
}

