/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.BigIntegerConversions;
import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class OffsetTimeConversions {
    private OffsetTimeConversions() {
    }

    static String toString(Object from, Converter converter) {
        OffsetTime offsetTime = (OffsetTime)from;
        return offsetTime.format(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        OffsetTime ot = (OffsetTime)from;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("offsetTime", ot.toString());
        return map;
    }

    static int toInteger(Object from, Converter converter) {
        return (int)OffsetTimeConversions.toLong(from, converter);
    }

    static long toLong(Object from, Converter converter) {
        OffsetTime ot = (OffsetTime)from;
        return ot.atDate(LocalDate.of(1970, 1, 1)).toInstant().toEpochMilli();
    }

    static double toDouble(Object from, Converter converter) {
        OffsetTime ot = (OffsetTime)from;
        Instant epoch = OffsetTimeConversions.getEpoch(ot);
        return (double)epoch.getEpochSecond() + (double)epoch.getNano() / 1.0E9;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        OffsetTime ot = (OffsetTime)from;
        Instant epoch = OffsetTimeConversions.getEpoch(ot);
        return BigInteger.valueOf(epoch.getEpochSecond()).multiply(BigIntegerConversions.BILLION).add(BigInteger.valueOf(epoch.getNano()));
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        OffsetTime ot = (OffsetTime)from;
        Instant epoch = OffsetTimeConversions.getEpoch(ot);
        BigDecimal seconds = BigDecimal.valueOf(epoch.getEpochSecond());
        BigDecimal nanos = BigDecimal.valueOf(epoch.getNano()).divide(BigDecimalConversions.BILLION);
        return seconds.add(nanos);
    }

    static AtomicInteger toAtomicInteger(Object from, Converter converter) {
        return new AtomicInteger((int)OffsetTimeConversions.toLong(from, converter));
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(OffsetTimeConversions.toLong(from, converter));
    }

    private static Instant getEpoch(OffsetTime ot) {
        return ot.atDate(LocalDate.of(1970, 1, 1)).toInstant();
    }
}

