/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class LocalDateTimeConversions {
    private LocalDateTimeConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        LocalDateTime ldt = (LocalDateTime)from;
        return ZonedDateTime.of(ldt, converter.getOptions().getZoneId());
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        LocalDateTime ldt = (LocalDateTime)from;
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(converter.getOptions().getTimeZone().getOffset(System.currentTimeMillis()) / 1000);
        return ldt.atOffset(zoneOffset);
    }

    static Instant toInstant(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toInstant();
    }

    static long toLong(Object from, Converter converter) {
        return LocalDateTimeConversions.toInstant(from, converter).toEpochMilli();
    }

    static double toDouble(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toDouble(instant, converter);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(LocalDateTimeConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        LocalDateTime ldt = (LocalDateTime)from;
        return Timestamp.from(ldt.atZone(converter.getOptions().getZoneId()).toInstant());
    }

    static Calendar toCalendar(Object from, Converter converter) {
        ZonedDateTime time = LocalDateTimeConversions.toZonedDateTime(from, converter);
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(time.toInstant().toEpochMilli());
        return calendar;
    }

    static Date toSqlDate(Object from, Converter converter) {
        LocalDateTime ldt = (LocalDateTime)from;
        return Date.valueOf(ldt.atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return new java.util.Date(LocalDateTimeConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static Year toYear(Object from, Converter converter) {
        return Year.from(((LocalDateTime)from).atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return YearMonth.from(((LocalDateTime)from).atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MonthDay.from(((LocalDateTime)from).atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static String toString(Object from, Converter converter) {
        LocalDateTime localDateTime = (LocalDateTime)from;
        return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    static Map<?, ?> toMap(Object from, Converter converter) {
        LocalDateTime localDateTime = (LocalDateTime)from;
        LinkedHashMap<String, String> target = new LinkedHashMap<String, String>();
        target.put("localDateTime", localDateTime.toString());
        return target;
    }
}

