/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.BigDecimalConversions;
import com.cedarsoftware.util.convert.CalendarConversions;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class DateConversions {
    static final DateTimeFormatter MILLIS_FMT = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

    private DateConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        return Instant.ofEpochMilli(date.getTime()).atZone(converter.getOptions().getZoneId());
    }

    static long toLong(Object from, Converter converter) {
        return ((java.util.Date)from).getTime();
    }

    static double toDouble(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        return (double)date.getTime() / 1000.0;
    }

    static Date toSqlDate(Object from, Converter converter) {
        return Date.valueOf(((java.util.Date)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static java.util.Date toDate(Object from, Converter converter) {
        return new java.util.Date(DateConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(DateConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        return CalendarConversions.create(DateConversions.toLong(from, converter), converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        long epochMillis = date.getTime();
        return new BigDecimal(epochMillis).divide(BigDecimalConversions.GRAND, 9, RoundingMode.DOWN);
    }

    static Instant toInstant(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        if (date instanceof Date) {
            return new java.util.Date(date.getTime()).toInstant();
        }
        return date.toInstant();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        return DateConversions.toInstant(from, converter).atZone(converter.getOptions().getZoneId()).toOffsetDateTime();
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return DateConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, converter.getOptions().getZoneId());
        return localDateTime.toLocalTime();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = DateConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(DateConversions.toLong(from, converter));
    }

    static Year toYear(Object from, Converter converter) {
        return Year.from(((java.util.Date)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static YearMonth toYearMonth(Object from, Converter converter) {
        return YearMonth.from(((java.util.Date)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static MonthDay toMonthDay(Object from, Converter converter) {
        return MonthDay.from(((java.util.Date)from).toInstant().atZone(converter.getOptions().getZoneId()).toLocalDate());
    }

    static String toString(Object from, Converter converter) {
        java.util.Date date = (java.util.Date)from;
        Instant instant = date.toInstant();
        return MILLIS_FMT.format(instant);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("date", DateConversions.toString(from, converter));
        return map;
    }
}

