/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class ZonedDateTimeConversions {
    private ZonedDateTimeConversions() {
    }

    static long toLong(Object from, Converter converter) {
        return ((ZonedDateTime)from).toInstant().toEpochMilli();
    }

    static double toDouble(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        return InstantConversions.toDouble(zdt.toInstant(), converter);
    }

    static Instant toInstant(Object from, Converter converter) {
        return ((ZonedDateTime)from).toInstant();
    }

    private static ZonedDateTime toDifferentZone(Object from, Converter converter) {
        return ((ZonedDateTime)from).withZoneSameInstant(converter.getOptions().getZoneId());
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        ZonedDateTime adjustedZonedDateTime = zdt.withZoneSameInstant(converter.getOptions().getZoneId());
        return adjustedZonedDateTime.toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return ZonedDateTimeConversions.toDifferentZone(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return ZonedDateTimeConversions.toDifferentZone(from, converter).toLocalTime();
    }

    static OffsetDateTime toOffsetDateTime(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        return zdt.toOffsetDateTime();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(ZonedDateTimeConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        return Timestamp.from(zdt.toInstant());
    }

    static Calendar toCalendar(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        Calendar cal = Calendar.getInstance(converter.getOptions().getTimeZone());
        cal.setTimeInMillis(zdt.toInstant().toEpochMilli());
        return cal;
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(ZonedDateTimeConversions.toLong(from, converter));
    }

    static Date toDate(Object from, Converter converter) {
        return new Date(ZonedDateTimeConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = ZonedDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Instant instant = ZonedDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static String toString(Object from, Converter converter) {
        ZonedDateTime zonedDateTime = (ZonedDateTime)from;
        return zonedDateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        ZonedDateTime zdt = (ZonedDateTime)from;
        CompactMap<String, Object> target = CompactMap.builder().insertionOrder().build();
        target.put("date", zdt.toLocalDate().toString());
        target.put("time", zdt.toLocalTime().toString());
        target.put("zone", zdt.getZone().toString());
        return target;
    }
}

