/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.EncryptionUtilities;
import com.cedarsoftware.util.StringUtilities;
import com.cedarsoftware.util.SystemUtilities;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class UniqueIdGenerator {
    public static final String JAVA_UTIL_CLUSTERID = "JAVA_UTIL_CLUSTERID";
    public static final String KUBERNETES_POD_NAME = "HOSTNAME";
    public static final String TANZU_INSTANCE_ID = "VMWARE_TANZU_INSTANCE_ID";
    public static final String CF_INSTANCE_INDEX = "CF_INSTANCE_INDEX";
    private static final Lock lock;
    private static final Lock lock19;
    private static int count;
    private static int count2;
    private static long lastTimeMillis;
    private static long lastTimeMillis19;
    private static long lastGeneratedId;
    private static long lastGeneratedId19;
    private static final int serverId;

    private UniqueIdGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId() {
        lock.lock();
        try {
            long newId;
            long currentTime = System.currentTimeMillis();
            if (currentTime < lastTimeMillis) {
                currentTime = lastTimeMillis;
            }
            if (currentTime == lastTimeMillis) {
                if (++count >= 1000) {
                    currentTime = UniqueIdGenerator.waitForNextMillis(lastTimeMillis);
                    count = 0;
                }
            } else {
                count = 0;
                lastTimeMillis = currentTime;
            }
            if ((newId = currentTime * 100000L + (long)count * 100L + (long)serverId) <= lastGeneratedId) {
                newId = lastGeneratedId + 1L;
            }
            lastGeneratedId = newId;
            long l = newId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId19() {
        lock19.lock();
        try {
            long newId;
            long currentTime = System.currentTimeMillis();
            if (currentTime < lastTimeMillis19) {
                currentTime = lastTimeMillis19;
            }
            if (currentTime == lastTimeMillis19) {
                if (++count2 >= 10000) {
                    currentTime = UniqueIdGenerator.waitForNextMillis(lastTimeMillis19);
                    count2 = 0;
                }
            } else {
                count2 = 0;
                lastTimeMillis19 = currentTime;
            }
            if ((newId = currentTime * 1000000L + (long)count2 * 100L + (long)serverId) <= lastGeneratedId19) {
                newId = lastGeneratedId19 + 1L;
            }
            lastGeneratedId19 = newId;
            long l = newId;
            return l;
        }
        finally {
            lock19.unlock();
        }
    }

    public static Date getDate(long uniqueId) {
        return new Date(uniqueId / 100000L);
    }

    public static Date getDate19(long uniqueId) {
        return new Date(uniqueId / 1000000L);
    }

    public static Instant getInstant(long uniqueId) {
        if (uniqueId < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId: must be positive");
        }
        return Instant.ofEpochMilli(uniqueId / 100000L);
    }

    public static Instant getInstant19(long uniqueId19) {
        if (uniqueId19 < 0L) {
            throw new IllegalArgumentException("Invalid uniqueId19: must be positive");
        }
        return Instant.ofEpochMilli(uniqueId19 / 1000000L);
    }

    private static long waitForNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            Thread.yield();
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    private static int getServerId(String externalVarName) {
        try {
            String id = SystemUtilities.getExternalVariable(externalVarName);
            if (StringUtilities.isEmpty(id)) {
                return -1;
            }
            int parsedId = Integer.parseInt(id);
            if (parsedId == Integer.MIN_VALUE) {
                return 0;
            }
            return Math.abs(parsedId) % 100;
        }
        catch (Throwable ignored) {
            return -1;
        }
    }

    static {
        String hostName;
        String podName;
        String envName;
        lock = new ReentrantLock();
        lock19 = new ReentrantLock();
        count = 0;
        count2 = 0;
        lastTimeMillis = 0L;
        lastTimeMillis19 = 0L;
        lastGeneratedId = 0L;
        lastGeneratedId19 = 0L;
        int id = UniqueIdGenerator.getServerId(JAVA_UTIL_CLUSTERID);
        String setVia = "environment variable: JAVA_UTIL_CLUSTERID";
        if (id == -1 && StringUtilities.hasContent(envName = SystemUtilities.getExternalVariable(JAVA_UTIL_CLUSTERID))) {
            String envValue = SystemUtilities.getExternalVariable(envName);
            id = UniqueIdGenerator.getServerId(envValue);
            setVia = "environment variable: " + envName;
        }
        if (id == -1 && StringUtilities.hasContent(podName = SystemUtilities.getExternalVariable(KUBERNETES_POD_NAME))) {
            try {
                if (podName.contains("-")) {
                    String ordinal = podName.substring(podName.lastIndexOf(45) + 1);
                    id = Math.abs(Integer.parseInt(ordinal)) % 100;
                    setVia = "Kubernetes pod name: " + podName;
                }
            }
            catch (Exception ordinal) {
                // empty catch block
            }
        }
        if (id == -1 && (id = UniqueIdGenerator.getServerId(TANZU_INSTANCE_ID)) != -1) {
            setVia = "VMware Tanzu instance ID";
        }
        if (id == -1 && (id = UniqueIdGenerator.getServerId(CF_INSTANCE_INDEX)) != -1) {
            setVia = "Cloud Foundry instance index";
        }
        if (id == -1 && StringUtilities.hasContent(hostName = SystemUtilities.getExternalVariable(KUBERNETES_POD_NAME))) {
            String hostnameSha256 = EncryptionUtilities.calculateSHA256Hash(hostName.getBytes(StandardCharsets.UTF_8));
            try {
                String hashSegment = hostnameSha256.substring(0, 8);
                int hashInt = Integer.parseUnsignedInt(hashSegment, 16);
                id = hashInt % 100;
                setVia = "hostname hash: " + hostName + " (" + hostnameSha256 + ")";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (id == -1) {
            SecureRandom random = new SecureRandom();
            id = Math.abs(random.nextInt()) % 100;
            setVia = "SecureRandom";
        }
        System.out.println("java-util using server id=" + id + " for last two digits of generated unique IDs. Set using " + setVia);
        serverId = id;
    }
}

