/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.StringUtilities;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;

public class CompactMap<K, V>
implements Map<K, V> {
    private static final String EMPTY_MAP = "_\ufe3f_\u03c8_\u263c";
    private Object val = "_\ufe3f_\u03c8_\u263c";

    public CompactMap() {
        if (this.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
    }

    public CompactMap(Map<K, V> other) {
        this();
        this.putAll(other);
    }

    @Override
    public int size() {
        if (this.val instanceof Object[]) {
            return ((Object[])this.val).length >> 1;
        }
        if (this.val instanceof Map) {
            return ((Map)this.val).size();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.val == EMPTY_MAP;
    }

    private boolean compareKeys(Object key, Object aKey) {
        if (key instanceof String) {
            if (aKey instanceof String) {
                if (this.isCaseInsensitive()) {
                    return ((String)aKey).equalsIgnoreCase((String)key);
                }
                return aKey.equals(key);
            }
            return false;
        }
        return Objects.equals(key, aKey);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                if (!this.compareKeys(key, entries[i])) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsKey(key);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return this.compareKeys(key, this.getLogicalSingleKey());
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aValue = entries[i + 1];
                if (!Objects.equals(value, aValue)) continue;
                return true;
            }
            return false;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.containsValue(value);
        }
        if (this.val == EMPTY_MAP) {
            return false;
        }
        return this.getLogicalSingleValue() == value;
    }

    @Override
    public V get(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aKey = entries[i];
                if (!this.compareKeys(key, aKey)) continue;
                return (V)entries[i + 1];
            }
            return null;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.get(key);
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        return this.compareKeys(key, this.getLogicalSingleKey()) ? (V)this.getLogicalSingleValue() : null;
    }

    @Override
    public V put(K key, V value) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aKey = entries[i];
                Object aValue = entries[i + 1];
                if (!this.compareKeys(key, aKey)) continue;
                entries[i + 1] = value;
                return (V)aValue;
            }
            if (this.size() < this.compactSize()) {
                Object[] expand = new Object[len + 2];
                System.arraycopy(entries, 0, expand, 0, len);
                expand[expand.length - 2] = key;
                expand[expand.length - 1] = value;
                this.val = expand;
            } else {
                Map<Object, Object> map = this.getNewMap(this.size() + 1);
                entries = (Object[])this.val;
                int len2 = entries.length;
                for (int i = 0; i < len2; i += 2) {
                    Object aKey = entries[i];
                    Object aValue = entries[i + 1];
                    map.put(aKey, aValue);
                }
                map.put(key, value);
                this.val = map;
            }
            return null;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            return map.put(key, value);
        }
        if (this.val == EMPTY_MAP) {
            this.val = this.compareKeys(key, this.getLogicalSingleKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return null;
        }
        if (this.compareKeys(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.val = this.compareKeys(key, this.getSingleValueKey()) && !(value instanceof Map) && !(value instanceof Object[]) ? value : new CompactMapEntry(key, value);
            return save;
        }
        Object[] entries = new Object[]{this.getLogicalSingleKey(), this.getLogicalSingleValue(), key, value};
        this.val = entries;
        return null;
    }

    @Override
    public V remove(Object key) {
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            if (this.size() == 2) {
                if (this.compareKeys(key, entries[0])) {
                    Object prevValue = entries[1];
                    this.clear();
                    this.put(entries[2], entries[3]);
                    return (V)prevValue;
                }
                if (this.compareKeys(key, entries[2])) {
                    Object prevValue = entries[3];
                    this.clear();
                    this.put(entries[0], entries[1]);
                    return (V)prevValue;
                }
            } else {
                int len = entries.length;
                for (int i = 0; i < len; i += 2) {
                    Object aKey = entries[i];
                    if (!this.compareKeys(key, aKey)) continue;
                    Object prior = entries[i + 1];
                    Object[] shrink = new Object[len - 2];
                    System.arraycopy(entries, 0, shrink, 0, i);
                    System.arraycopy(entries, i + 2, shrink, i, shrink.length - i);
                    this.val = shrink;
                    return (V)prior;
                }
            }
            return null;
        }
        if (this.val instanceof Map) {
            Map map = (Map)this.val;
            if (!map.containsKey(key)) {
                return null;
            }
            Object save = map.remove(key);
            if (map.size() == this.compactSize()) {
                Object[] entries = new Object[this.compactSize() * 2];
                Iterator i = map.entrySet().iterator();
                int idx = 0;
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    entries[idx] = entry.getKey();
                    entries[idx + 1] = entry.getValue();
                    idx += 2;
                }
                this.val = entries;
            }
            return save;
        }
        if (this.val == EMPTY_MAP) {
            return null;
        }
        if (this.compareKeys(key, this.getLogicalSingleKey())) {
            V save = this.getLogicalSingleValue();
            this.val = EMPTY_MAP;
            return save;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return;
        }
        int mSize = map.size();
        if (this.val instanceof Map || mSize > this.compactSize()) {
            if (this.val == EMPTY_MAP) {
                this.val = this.getNewMap(mSize);
            }
            ((Map)this.val).putAll(map);
        } else {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.val = EMPTY_MAP;
    }

    @Override
    public int hashCode() {
        if (this.val instanceof Object[]) {
            int h = 0;
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                Object aKey = entries[i];
                Object aValue = entries[i + 1];
                h += this.computeKeyHashCode(aKey) ^ this.computeValueHashCode(aValue);
            }
            return h;
        }
        if (this.val instanceof Map) {
            return this.val.hashCode();
        }
        if (this.val == EMPTY_MAP) {
            return 0;
        }
        return this.computeKeyHashCode(this.getLogicalSingleKey()) ^ this.computeValueHashCode(this.getLogicalSingleValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.val instanceof Object[]) {
            for (Map.Entry entry : other.entrySet()) {
                Object thatKey = entry.getKey();
                if (!this.containsKey(thatKey)) {
                    return false;
                }
                Object thatValue = entry.getValue();
                V thisValue = this.get(thatKey);
                if (!(thatValue == null || thisValue == null ? thatValue != thisValue : !thisValue.equals(thatValue))) continue;
                return false;
            }
        } else {
            if (this.val instanceof Map) {
                Map map = (Map)this.val;
                return map.equals(other);
            }
            if (this.val == EMPTY_MAP) {
                return other.isEmpty();
            }
        }
        return this.entrySet().equals(other.entrySet());
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                if (CompactMap.this.useCopyIterator()) {
                    return new CopyKeyIterator();
                }
                return new CompactKeyIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return CompactMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                int size = this.size();
                CompactMap.this.remove(o);
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    CompactMap.this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(final Collection c) {
                CompactMap other = new CompactMap<K, V>(){

                    @Override
                    protected boolean isCaseInsensitive() {
                        return CompactMap.this.isCaseInsensitive();
                    }

                    @Override
                    protected int compactSize() {
                        return CompactMap.this.compactSize();
                    }

                    @Override
                    protected Map<K, V> getNewMap() {
                        return CompactMap.this.getNewMap(c.size());
                    }
                };
                for (Object o : c) {
                    other.put(o, null);
                }
                int size = this.size();
                CompactMap.this.keySet().removeIf(key -> !other.containsKey(key));
                return this.size() != size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                if (CompactMap.this.useCopyIterator()) {
                    return new CopyValueIterator();
                }
                return new CompactValueIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                if (CompactMap.this.useCopyIterator()) {
                    return new CopyEntryIterator();
                }
                return new CompactEntryIterator();
            }

            @Override
            public int size() {
                return CompactMap.this.size();
            }

            @Override
            public void clear() {
                CompactMap.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object entryKey = entry.getKey();
                    Object value = CompactMap.this.get(entryKey);
                    if (value != null) {
                        return Objects.equals(value, entry.getValue());
                    }
                    if (CompactMap.this.containsKey(entryKey)) {
                        value = CompactMap.this.get(entryKey);
                        return Objects.equals(value, entry.getValue());
                    }
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                int size = this.size();
                Map.Entry that = (Map.Entry)o;
                CompactMap.this.remove(that.getKey());
                return this.size() != size;
            }

            @Override
            public boolean removeAll(Collection c) {
                int size = this.size();
                for (Object o : c) {
                    this.remove(o);
                }
                return this.size() != size;
            }

            @Override
            public boolean retainAll(final Collection c) {
                CompactMap other = new CompactMap<K, V>(){

                    @Override
                    protected boolean isCaseInsensitive() {
                        return CompactMap.this.isCaseInsensitive();
                    }

                    @Override
                    protected int compactSize() {
                        return CompactMap.this.compactSize();
                    }

                    @Override
                    protected Map<K, V> getNewMap() {
                        return CompactMap.this.getNewMap(c.size());
                    }
                };
                for (Object o : c) {
                    if (!(o instanceof Map.Entry)) continue;
                    other.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                }
                int origSize = this.size();
                Iterator i = CompactMap.this.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!other.containsKey(key)) {
                        i.remove();
                        continue;
                    }
                    Object v = other.get(key);
                    if (Objects.equals(v, value)) continue;
                    i.remove();
                }
                return this.size() != origSize;
            }
        };
    }

    private Map<K, V> getCopy() {
        Map<Object, Object> copy = this.getNewMap(this.size());
        if (this.val instanceof Object[]) {
            Object[] entries = (Object[])this.val;
            int len = entries.length;
            for (int i = 0; i < len; i += 2) {
                copy.put(entries[i], entries[i + 1]);
            }
        } else if (this.val instanceof Map) {
            copy.putAll((Map)this.val);
        } else if (this.val != EMPTY_MAP) {
            copy.put(this.getLogicalSingleKey(), this.getLogicalSingleValue());
        }
        return copy;
    }

    private void iteratorRemove(Map.Entry<K, V> currentEntry, Iterator<Map.Entry<K, V>> i) {
        if (currentEntry == null) {
            throw new IllegalStateException("remove() called on an Iterator before calling next()");
        }
        this.remove(currentEntry.getKey());
    }

    public Map<K, V> minus(Object removeMe) {
        throw new UnsupportedOperationException("Unsupported operation [minus] or [-] between Maps.  Use removeAll() or retainAll() instead.");
    }

    public Map<K, V> plus(Object right) {
        throw new UnsupportedOperationException("Unsupported operation [plus] or [+] between Maps.  Use putAll() instead.");
    }

    protected LogicalValueType getLogicalValueType() {
        if (this.val instanceof Object[]) {
            return LogicalValueType.ARRAY;
        }
        if (this.val instanceof Map) {
            return LogicalValueType.MAP;
        }
        if (this.val == EMPTY_MAP) {
            return LogicalValueType.EMPTY;
        }
        if (CompactMapEntry.class.isInstance(this.val)) {
            return LogicalValueType.ENTRY;
        }
        return LogicalValueType.OBJECT;
    }

    protected int computeKeyHashCode(Object key) {
        if (key instanceof String) {
            if (this.isCaseInsensitive()) {
                return StringUtilities.hashCodeIgnoreCase((String)key);
            }
            return key.hashCode();
        }
        if (key == null) {
            return 0;
        }
        int keyHash = key == this ? 37 : key.hashCode();
        return keyHash;
    }

    protected int computeValueHashCode(Object value) {
        if (value == this) {
            return 17;
        }
        return value == null ? 0 : value.hashCode();
    }

    private K getLogicalSingleKey() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getKey();
        }
        return this.getSingleValueKey();
    }

    private V getLogicalSingleValue() {
        if (CompactMapEntry.class.isInstance(this.val)) {
            CompactMapEntry entry = (CompactMapEntry)this.val;
            return entry.getValue();
        }
        return (V)this.val;
    }

    protected K getSingleValueKey() {
        return (K)"key";
    }

    protected Map<K, V> getNewMap() {
        return new HashMap(this.compactSize() + 1);
    }

    protected Map<K, V> getNewMap(int size) {
        Map<K, V> map = this.getNewMap();
        try {
            Constructor<?> constructor = ReflectionUtils.getConstructor(map.getClass(), Integer.TYPE);
            return (Map)constructor.newInstance(size);
        }
        catch (Exception e) {
            return map;
        }
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    protected int compactSize() {
        return 80;
    }

    protected boolean useCopyIterator() {
        Map<K, V> newMap = this.getNewMap();
        if (newMap instanceof CaseInsensitiveMap) {
            newMap = ((CaseInsensitiveMap)newMap).getWrappedMap();
        }
        return newMap instanceof SortedMap;
    }

    public class CompactMapEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public CompactMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public V setValue(V value) {
            Object save = this.getValue();
            super.setValue(value);
            CompactMap.this.put(this.getKey(), value);
            return save;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Map.Entry e = (Map.Entry)o;
            return CompactMap.this.compareKeys(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            return CompactMap.this.computeKeyHashCode(this.getKey()) ^ CompactMap.this.computeValueHashCode(this.getValue());
        }
    }

    protected static enum LogicalValueType {
        EMPTY,
        OBJECT,
        ENTRY,
        MAP,
        ARRAY;

    }

    final class CopyEntryIterator
    extends CopyIterator
    implements Iterator<Map.Entry<K, V>> {
        CopyEntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class CopyValueIterator
    extends CopyIterator
    implements Iterator<V> {
        CopyValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class CopyKeyIterator
    extends CopyIterator
    implements Iterator<K> {
        CopyKeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class CopyIterator {
        Iterator<Map.Entry<K, V>> iter;
        Map.Entry<K, V> currentEntry = null;

        public CopyIterator() {
            this.iter = CompactMap.this.getCopy().entrySet().iterator();
        }

        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        public final Map.Entry<K, V> nextEntry() {
            this.currentEntry = this.iter.next();
            return this.currentEntry;
        }

        public final void remove() {
            CompactMap.this.iteratorRemove(this.currentEntry, this.iter);
            this.currentEntry = null;
        }
    }

    final class CompactEntryIterator
    extends CompactIterator
    implements Iterator<Map.Entry<K, V>> {
        CompactEntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            this.advance();
            if (this.mapIterator != null) {
                return (Map.Entry)this.current;
            }
            if (this.expectedSize == 1) {
                if (CompactMap.this.val instanceof CompactMapEntry) {
                    return (CompactMapEntry)CompactMap.this.val;
                }
                return new CompactMapEntry(CompactMap.this.getLogicalSingleKey(), CompactMap.this.getLogicalSingleValue());
            }
            Object[] objs = (Object[])CompactMap.this.val;
            return new CompactMapEntry(objs[this.index * 2], objs[this.index * 2 + 1]);
        }
    }

    final class CompactValueIterator
    extends CompactIterator
    implements Iterator<V> {
        CompactValueIterator() {
        }

        @Override
        public final V next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getValue();
            }
            if (this.expectedSize == 1) {
                return CompactMap.this.getLogicalSingleValue();
            }
            return ((Object[])CompactMap.this.val)[this.index * 2 + 1];
        }
    }

    final class CompactKeyIterator
    extends CompactIterator
    implements Iterator<K> {
        CompactKeyIterator() {
        }

        @Override
        public final K next() {
            this.advance();
            if (this.mapIterator != null) {
                return ((Map.Entry)this.current).getKey();
            }
            return this.current;
        }
    }

    abstract class CompactIterator {
        Iterator<Map.Entry<K, V>> mapIterator;
        Object current;
        int expectedSize;
        int index;

        CompactIterator() {
            this.expectedSize = CompactMap.this.size();
            this.current = CompactMap.EMPTY_MAP;
            this.index = -1;
            if (CompactMap.this.val instanceof Map) {
                this.mapIterator = ((Map)CompactMap.this.val).entrySet().iterator();
            }
        }

        public final boolean hasNext() {
            if (this.mapIterator != null) {
                return this.mapIterator.hasNext();
            }
            return this.index + 1 < CompactMap.this.size();
        }

        final void advance() {
            if (this.expectedSize != CompactMap.this.size()) {
                throw new ConcurrentModificationException();
            }
            if (++this.index >= CompactMap.this.size()) {
                throw new NoSuchElementException();
            }
            this.current = this.mapIterator != null ? this.mapIterator.next() : (this.expectedSize == 1 ? CompactMap.this.getLogicalSingleKey() : ((Object[])CompactMap.this.val)[this.index * 2]);
        }

        public final void remove() {
            if (this.current == CompactMap.EMPTY_MAP) {
                throw new IllegalStateException();
            }
            if (CompactMap.this.size() != this.expectedSize) {
                throw new ConcurrentModificationException();
            }
            int newSize = this.expectedSize - 1;
            if (this.mapIterator != null && newSize == CompactMap.this.compactSize()) {
                this.current = ((Map.Entry)this.current).getKey();
                this.mapIterator = null;
            }
            if (this.mapIterator == null) {
                CompactMap.this.remove(this.current);
            } else {
                this.mapIterator.remove();
            }
            --this.index;
            this.current = CompactMap.EMPTY_MAP;
            --this.expectedSize;
        }
    }
}

