/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;

public class ConcurrentNavigableSetNullSafe<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    private final NavigableSet<Object> internalSet;
    private final Comparator<? super E> originalComparator;
    private static final String NULL_ELEMENT_SENTINEL = "null_" + UUID.randomUUID();

    public ConcurrentNavigableSetNullSafe() {
        this.originalComparator = null;
        Comparator<Object> comp = this.wrapComparator(null);
        this.internalSet = new ConcurrentSkipListSet<Object>(comp);
    }

    public ConcurrentNavigableSetNullSafe(Comparator<? super E> comparator) {
        this.originalComparator = comparator;
        Comparator<Object> comp = this.wrapComparator(comparator);
        this.internalSet = new ConcurrentSkipListSet<Object>(comp);
    }

    public ConcurrentNavigableSetNullSafe(Collection<? extends E> c) {
        this.originalComparator = null;
        Comparator<Object> comp = this.wrapComparator(null);
        this.internalSet = new ConcurrentSkipListSet<Object>(comp);
        this.addAll(c);
    }

    public ConcurrentNavigableSetNullSafe(Collection<? extends E> c, Comparator<? super E> comparator) {
        this.originalComparator = comparator;
        Comparator<Object> comp = this.wrapComparator(comparator);
        this.internalSet = new ConcurrentSkipListSet<Object>(comp);
        this.addAll(c);
    }

    private ConcurrentNavigableSetNullSafe(NavigableSet<Object> internalSet, Comparator<? super E> comparator) {
        this.internalSet = internalSet;
        this.originalComparator = comparator;
    }

    private Object maskNull(E element) {
        return element == null ? NULL_ELEMENT_SENTINEL : element;
    }

    private E unmaskNull(Object maskedElement) {
        return (E)(maskedElement == NULL_ELEMENT_SENTINEL ? null : maskedElement);
    }

    private Comparator<Object> wrapComparator(Comparator<? super E> comparator) {
        return (o1, o2) -> {
            Object e2;
            boolean o1IsNullSentinel = NULL_ELEMENT_SENTINEL.equals(o1);
            boolean o2IsNullSentinel = NULL_ELEMENT_SENTINEL.equals(o2);
            Object e1 = o1IsNullSentinel ? null : o1;
            Object object = e2 = o2IsNullSentinel ? null : o2;
            if (comparator != null) {
                return comparator.compare((Object)e1, (Object)e2);
            }
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null) {
                return 1;
            }
            if (e2 == null) {
                return -1;
            }
            return ((Comparable)e1).compareTo(e2);
        };
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.originalComparator;
    }

    @Override
    public E lower(E e) {
        Object masked = this.internalSet.lower(this.maskNull(e));
        return this.unmaskNull(masked);
    }

    @Override
    public E floor(E e) {
        Object masked = this.internalSet.floor(this.maskNull(e));
        return this.unmaskNull(masked);
    }

    @Override
    public E ceiling(E e) {
        Object masked = this.internalSet.ceiling(this.maskNull(e));
        return this.unmaskNull(masked);
    }

    @Override
    public E higher(E e) {
        Object masked = this.internalSet.higher(this.maskNull(e));
        return this.unmaskNull(masked);
    }

    @Override
    public E pollFirst() {
        Object masked = this.internalSet.pollFirst();
        return this.unmaskNull(masked);
    }

    @Override
    public E pollLast() {
        Object masked = this.internalSet.pollLast();
        return this.unmaskNull(masked);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<Object> it = this.internalSet.iterator();
        return new Iterator<E>(){
            final /* synthetic */ ConcurrentNavigableSetNullSafe this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                return this.this$0.unmaskNull(it.next());
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    public NavigableSet<E> descendingSet() {
        NavigableSet<Object> descendingInternalSet = this.internalSet.descendingSet();
        return new ConcurrentNavigableSetNullSafe<E>(descendingInternalSet, this.originalComparator);
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Iterator<Object> it = this.internalSet.descendingIterator();
        return new Iterator<E>(){
            final /* synthetic */ ConcurrentNavigableSetNullSafe this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                return this.this$0.unmaskNull(it.next());
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Object maskedFrom = this.maskNull(fromElement);
        Object maskedTo = this.maskNull(toElement);
        NavigableSet<Object> subInternal = this.internalSet.subSet(maskedFrom, fromInclusive, maskedTo, toInclusive);
        return new ConcurrentNavigableSetNullSafe<E>(subInternal, this.originalComparator);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        NavigableSet<Object> headInternal = this.internalSet.headSet(this.maskNull(toElement), inclusive);
        return new ConcurrentNavigableSetNullSafe<E>(headInternal, this.originalComparator);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        NavigableSet<Object> tailInternal = this.internalSet.tailSet(this.maskNull(fromElement), inclusive);
        return new ConcurrentNavigableSetNullSafe<E>(tailInternal, this.originalComparator);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public E first() {
        Object masked = this.internalSet.first();
        return this.unmaskNull(masked);
    }

    @Override
    public E last() {
        Object masked = this.internalSet.last();
        return this.unmaskNull(masked);
    }

    @Override
    public int size() {
        return this.internalSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalSet.contains(this.maskNull(o));
    }

    @Override
    public boolean add(E e) {
        return this.internalSet.add(this.maskNull(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.internalSet.remove(this.maskNull(o));
    }

    @Override
    public void clear() {
        this.internalSet.clear();
    }
}

