/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ClassUtilities {
    private static final Set<Class<?>> prims = new HashSet();
    private static final Map<Class<?>, Class<?>> primitiveToWrapper = new HashMap(20, 0.8f);
    private static final Map<String, Class<?>> nameToClass = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperMap = new HashMap();

    public static void addPermanentClassAlias(Class<?> clazz, String alias) {
        nameToClass.put(alias, clazz);
    }

    public static void removePermanentClassAlias(String alias) {
        nameToClass.remove(alias);
    }

    public static int computeInheritanceDistance(Class<?> source, Class<?> destination) {
        if (source == null || destination == null) {
            return -1;
        }
        if (source.equals(destination)) {
            return 0;
        }
        if (source.isPrimitive()) {
            if (destination.isPrimitive()) {
                return -1;
            }
            if (!ClassUtilities.isPrimitive(destination)) {
                return -1;
            }
            return ClassUtilities.comparePrimitiveToWrapper(destination, source);
        }
        if (destination.isPrimitive()) {
            if (!ClassUtilities.isPrimitive(source)) {
                return -1;
            }
            return ClassUtilities.comparePrimitiveToWrapper(source, destination);
        }
        LinkedList queue = new LinkedList();
        IdentityHashMap visited = new IdentityHashMap();
        queue.add(source);
        visited.put(source, null);
        int distance = 0;
        while (!queue.isEmpty()) {
            int levelSize = queue.size();
            ++distance;
            for (int i = 0; i < levelSize; ++i) {
                Class current = (Class)queue.poll();
                if (current.getSuperclass() != null) {
                    if (current.getSuperclass().equals(destination)) {
                        return distance;
                    }
                    if (!visited.containsKey(current.getSuperclass())) {
                        queue.add(current.getSuperclass());
                        visited.put(current.getSuperclass(), null);
                    }
                }
                for (Class<?> interfaceClass : current.getInterfaces()) {
                    if (interfaceClass.equals(destination)) {
                        return distance;
                    }
                    if (visited.containsKey(interfaceClass)) continue;
                    queue.add(interfaceClass);
                    visited.put(interfaceClass, null);
                }
            }
        }
        return -1;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || prims.contains(c);
    }

    private static int comparePrimitiveToWrapper(Class<?> source, Class<?> destination) {
        try {
            return source.getField("TYPE").get(null).equals(destination) ? 0 : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static Class<?> forName(String name, ClassLoader classLoader) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return ClassUtilities.internalClassForName(name, classLoader);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Security exception, classForName() call on: " + name, e);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> internalClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> c = nameToClass.get(name);
        if (c != null) {
            return c;
        }
        c = ClassUtilities.loadClass(name, classLoader);
        if (ClassLoader.class.isAssignableFrom(c) || ProcessBuilder.class.isAssignableFrom(c) || Process.class.isAssignableFrom(c) || Constructor.class.isAssignableFrom(c) || Method.class.isAssignableFrom(c) || Field.class.isAssignableFrom(c)) {
            throw new SecurityException("For security reasons, cannot instantiate: " + c.getName() + " when loading JSON.");
        }
        nameToClass.put(name, c);
        return c;
    }

    private static Class<?> loadClass(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<Object> currentClass = null;
        if (null == primitiveArray) {
            try {
                currentClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        if (arrayType) {
            Class clazz = currentClass = null != primitiveArray ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    public static boolean isClassFinal(Class<?> c) {
        return (c.getModifiers() & 0x10) != 0;
    }

    public static boolean areAllConstructorsPrivate(Class<?> c) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = c.getDeclaredConstructors()) {
            if ((constructor.getModifiers() & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public static Class<?> toPrimitiveWrapperClass(Class<?> primitiveClass) {
        if (!primitiveClass.isPrimitive()) {
            return primitiveClass;
        }
        Class<?> c = primitiveToWrapper.get(primitiveClass);
        if (c == null) {
            throw new IllegalArgumentException("Passed in class: " + primitiveClass + " is not a primitive class");
        }
        return c;
    }

    public static boolean doesOneWrapTheOther(Class<?> x, Class<?> y) {
        return wrapperMap.get(x) == y;
    }

    static {
        prims.add(Byte.class);
        prims.add(Short.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Float.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Boolean.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("string", String.class);
        nameToClass.put("date", Date.class);
        nameToClass.put("class", Class.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Void.TYPE, Void.class);
        wrapperMap.put(Integer.TYPE, Integer.class);
        wrapperMap.put(Integer.class, Integer.TYPE);
        wrapperMap.put(Character.TYPE, Character.class);
        wrapperMap.put(Character.class, Character.TYPE);
        wrapperMap.put(Byte.TYPE, Byte.class);
        wrapperMap.put(Byte.class, Byte.TYPE);
        wrapperMap.put(Short.TYPE, Short.class);
        wrapperMap.put(Short.class, Short.TYPE);
        wrapperMap.put(Long.TYPE, Long.class);
        wrapperMap.put(Long.class, Long.TYPE);
        wrapperMap.put(Float.TYPE, Float.class);
        wrapperMap.put(Float.class, Float.TYPE);
        wrapperMap.put(Double.TYPE, Double.class);
        wrapperMap.put(Double.class, Double.TYPE);
        wrapperMap.put(Boolean.TYPE, Boolean.class);
        wrapperMap.put(Boolean.class, Boolean.TYPE);
    }
}

