/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.cache.LockingLRUCacheStrategy;
import com.cedarsoftware.util.cache.ThreadedLRUCacheStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class LRUCache<K, V>
implements Map<K, V> {
    private final Map<K, V> strategy;

    public LRUCache(int capacity) {
        this.strategy = new LockingLRUCacheStrategy(capacity);
    }

    public LRUCache(int capacity, StrategyType strategyType) {
        if (strategyType == StrategyType.THREADED) {
            this.strategy = new ThreadedLRUCacheStrategy(capacity, 10, null);
        } else if (strategyType == StrategyType.LOCKING) {
            this.strategy = new LockingLRUCacheStrategy(capacity);
        } else {
            throw new IllegalArgumentException("Unsupported strategy type: " + (Object)((Object)strategyType));
        }
    }

    public LRUCache(int capacity, int cleanupDelayMillis, ScheduledExecutorService scheduler) {
        this.strategy = new ThreadedLRUCacheStrategy(capacity, cleanupDelayMillis, scheduler);
    }

    @Override
    public V get(Object key) {
        return this.strategy.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.strategy.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.strategy.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.strategy.remove(key);
    }

    @Override
    public void clear() {
        this.strategy.clear();
    }

    @Override
    public int size() {
        return this.strategy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.strategy.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.strategy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.strategy.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.strategy.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.strategy.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.strategy.values();
    }

    public String toString() {
        return this.strategy.toString();
    }

    @Override
    public int hashCode() {
        return this.strategy.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LRUCache other = (LRUCache)obj;
        return this.strategy.equals(other.strategy);
    }

    public void shutdown() {
        if (this.strategy instanceof ThreadedLRUCacheStrategy) {
            ((ThreadedLRUCacheStrategy)this.strategy).shutdown();
        }
    }

    public static enum StrategyType {
        THREADED,
        LOCKING;

    }
}

