/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.io.IOException;
import java.io.Writer;

public class FastWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Writer out;
    private char[] cb;
    private int nextChar;

    public FastWriter(Writer out) {
        this(out, 8192);
    }

    public FastWriter(Writer out, int bufferSize) {
        super((Object)out);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.cb = new char[bufferSize];
        this.nextChar = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.nextChar == 0) {
            return;
        }
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.out == null) {
            throw new IOException("FastWriter stream is closed.");
        }
        if (this.nextChar >= this.cb.length) {
            this.flushBuffer();
        }
        this.cb[this.nextChar++] = (char)c;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException("FastWriter stream is closed.");
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.cb.length) {
            this.flushBuffer();
            this.out.write(cbuf, off, len);
            return;
        }
        if (len > this.cb.length - this.nextChar) {
            this.flushBuffer();
        }
        System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
        this.nextChar += len;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException("FastWriter stream is closed.");
        }
        int b = off;
        int t = off + len;
        while (b < t) {
            int d = Math.min(this.cb.length - this.nextChar, t - b);
            str.getChars(b, b + d, this.cb, this.nextChar);
            b += d;
            this.nextChar += d;
            if (this.nextChar < this.cb.length) continue;
            this.flushBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            this.flushBuffer();
        }
        finally {
            this.out.close();
            this.out = null;
            this.cb = null;
        }
    }
}

