/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static final Map<Class, Collection<Field>> _reflectedFields = new ConcurrentHashMap<Class, Collection<Field>>();

    public static Annotation getMethodAnnotation(Method method, Class annoClass) {
        Object a = method.getAnnotation(annoClass);
        if (a != null) {
            return a;
        }
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        if (interfaces != null) {
            for (Class<?> interFace : interfaces) {
                try {
                    Method m = interFace.getMethod(method.getName(), method.getParameterTypes());
                    a = m.getAnnotation(annoClass);
                    if (a != null) {
                        return a;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Collection<Field> getDeepDeclaredFields(Class c) {
        if (_reflectedFields.containsKey(c)) {
            return _reflectedFields.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class curr = c; curr != null; curr = curr.getSuperclass()) {
            try {
                Field[] local;
                for (Field field : local = curr.getDeclaredFields()) {
                    int modifiers;
                    if (!field.isAccessible()) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    if (Modifier.isStatic(modifiers = field.getModifiers()) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                    fields.add(field);
                }
                continue;
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _reflectedFields.put(c, fields);
        return fields;
    }

    public static Map<String, Field> getDeepDeclaredFieldMap(Class c) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(c);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldMap.containsKey(fieldName)) {
                fieldMap.put(field.getDeclaringClass().getName() + '.' + fieldName, field);
                continue;
            }
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }
}

