/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UniqueIdGenerator {
    private static long count;
    private static final int lastIp;
    private static final Map<Long, Long> lastId;
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueId() {
        Class<UniqueIdGenerator> clazz = UniqueIdGenerator.class;
        synchronized (UniqueIdGenerator.class) {
            long newId = UniqueIdGenerator.getUniqueIdAttempt();
            while (lastId.containsKey(newId)) {
                newId = UniqueIdGenerator.getUniqueIdAttempt();
            }
            lastId.put(newId, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return newId;
        }
    }

    private static long getUniqueIdAttempt() {
        if (++count >= 100L) {
            count = 0L;
        }
        return System.currentTimeMillis() * 10000L + count * 100L + (long)(lastIp % 100);
    }

    static {
        byte[] ip;
        count = 0L;
        lastId = new LinkedHashMap<Long, Long>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                return this.size() > 100;
            }
        };
        LOG = LogFactory.getLog(UniqueIdGenerator.class);
        try {
            ip = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            ip = new byte[]{0, 0, 0, 0};
            LOG.warn((Object)"Failed to obtain computer's IP address", (Throwable)e);
        }
        lastIp = ip[3] & 0xFF;
    }
}

