/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ExceptionUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ReflectionUtils {
    private static final ConcurrentMap<Class<?>, Collection<Field>> FIELD_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, Method> METHOD_MAP = new ConcurrentHashMap<String, Method>();
    private static final ConcurrentMap<String, Method> METHOD_MAP2 = new ConcurrentHashMap<String, Method>();

    private ReflectionUtils() {
    }

    public static <T extends Annotation> T getClassAnnotation(Class<?> classToCheck, Class<T> annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.add(classToCheck);
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            T a = classToChk.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(classToChk, stack);
        }
        return null;
    }

    private static void addInterfaces(Class<?> classToCheck, LinkedList<Class<?>> stack) {
        for (Class<?> interFace : classToCheck.getInterfaces()) {
            stack.push(interFace);
        }
    }

    public static <T extends Annotation> T getMethodAnnotation(Method method, Class<T> annoClass) {
        HashSet<Class> visited = new HashSet<Class>();
        LinkedList stack = new LinkedList();
        stack.add(method.getDeclaringClass());
        while (!stack.isEmpty()) {
            Class classToChk = (Class)stack.pop();
            if (classToChk == null || visited.contains(classToChk)) continue;
            visited.add(classToChk);
            Method m = ReflectionUtils.getMethod(classToChk, method.getName(), method.getParameterTypes());
            if (m == null) continue;
            T a = m.getAnnotation(annoClass);
            if (a != null) {
                return a;
            }
            stack.push(classToChk.getSuperclass());
            ReflectionUtils.addInterfaces(method.getDeclaringClass(), stack);
        }
        return null;
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... types) {
        try {
            Method other;
            StringBuilder builder = new StringBuilder(c.getName());
            builder.append('.');
            builder.append(methodName);
            for (Class<?> clz : types) {
                builder.append('|');
                builder.append(clz.getName());
            }
            String methodKey = builder.toString();
            Method method = (Method)METHOD_MAP.get(methodKey);
            if (method == null && (other = METHOD_MAP.putIfAbsent(methodKey, method = c.getMethod(methodName, types))) != null) {
                method = other;
            }
            return method;
        }
        catch (Exception nse) {
            return null;
        }
    }

    public static Collection<Field> getDeepDeclaredFields(Class<?> c) {
        if (FIELD_MAP.containsKey(c)) {
            return (Collection)FIELD_MAP.get(c);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
            ReflectionUtils.getDeclaredFields(curr, fields);
        }
        FIELD_MAP.put(c, fields);
        return fields;
    }

    public static void getDeclaredFields(Class<?> c, Collection<Field> fields) {
        try {
            Field[] local;
            for (Field field : local = c.getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || field.getName().startsWith("this$") || Modifier.isTransient(modifiers)) continue;
                fields.add(field);
            }
        }
        catch (Throwable ignored) {
            ExceptionUtilities.safelyIgnoreException(ignored);
        }
    }

    public static Map<String, Field> getDeepDeclaredFieldMap(Class<?> c) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(c);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldMap.containsKey(fieldName)) {
                fieldMap.put(field.getDeclaringClass().getName() + '.' + fieldName, field);
                continue;
            }
            fieldMap.put(fieldName, field);
        }
        return fieldMap;
    }

    public static Object call(Object bean, Method method, Object ... args) {
        if (method == null) {
            String className = bean == null ? "null bean" : bean.getClass().getName();
            throw new IllegalArgumentException("null Method passed to ReflectionUtils.call() on bean of type: " + className);
        }
        if (bean == null) {
            throw new IllegalArgumentException("Cannot call [" + method.getName() + "()] on a null object.");
        }
        try {
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException occurred attempting to reflectively call method: " + method.getName() + "()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown inside reflectively called method: " + method.getName() + "()", e.getTargetException());
        }
    }

    public static Object call(Object bean, String methodName, Object ... args) {
        Method method = ReflectionUtils.getMethod(bean, methodName, args.length);
        try {
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException occurred attempting to reflectively call method: " + method.getName() + "()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception thrown inside reflectively called method: " + method.getName() + "()", e.getTargetException());
        }
    }

    public static Method getMethod(Object bean, String methodName, int argCount) {
        if (bean == null) {
            throw new IllegalArgumentException("Attempted to call getMethod() [" + methodName + "()] on a null instance.");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Attempted to call getMethod() with a null method name on an instance of: " + bean.getClass().getName());
        }
        StringBuilder builder = new StringBuilder(bean.getClass().getName());
        builder.append('.');
        builder.append(methodName);
        builder.append('|');
        builder.append(argCount);
        String methodKey = builder.toString();
        Method method = (Method)METHOD_MAP2.get(methodKey);
        if (method == null) {
            method = ReflectionUtils.getMethod(bean.getClass(), methodName, argCount);
            if (method == null) {
                throw new IllegalArgumentException("Method: " + methodName + "() is not found on class: " + bean.getClass().getName() + ". Perhaps the method is protected, private, or misspelled?");
            }
            Method other = METHOD_MAP2.putIfAbsent(methodKey, method);
            if (other != null) {
                method = other;
            }
        }
        return method;
    }

    private static Method getMethod(Class c, String methodName, int argc) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            if (!methodName.equals(method.getName()) || method.getParameterTypes().length != argc) continue;
            return method;
        }
        return null;
    }

    public static String getClassName(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }

    public static String getClassNameFromByteCode(byte[] byteCode) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(byteCode);
        DataInputStream dis = new DataInputStream(is);
        dis.readLong();
        int cpcnt = (dis.readShort() & 0xFFFF) - 1;
        int[] classes = new int[cpcnt];
        String[] strings = new String[cpcnt];
        for (int i = 0; i < cpcnt; ++i) {
            int t = dis.read();
            if (t == 7) {
                classes[i] = dis.readShort() & 0xFFFF;
                continue;
            }
            if (t == 1) {
                strings[i] = dis.readUTF();
                continue;
            }
            if (t == 5 || t == 6) {
                dis.readLong();
                ++i;
                continue;
            }
            if (t == 8) {
                dis.readShort();
                continue;
            }
            dis.readInt();
        }
        dis.readShort();
        return strings[classes[(dis.readShort() & 0xFFFF) - 1] - 1].replace('/', '.');
    }
}

