/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtilities {
    private EncryptionUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fastMD5(File file) {
        String string;
        FileInputStream in = null;
        try {
            int nRead;
            in = new FileInputStream(file);
            FileChannel ch = in.getChannel();
            MessageDigest d = EncryptionUtilities.getMD5Digest();
            ByteBuffer bb = ByteBuffer.allocateDirect(65536);
            while ((nRead = ch.read(bb)) != -1) {
                if (nRead == 0) continue;
                bb.position(0);
                bb.limit(nRead);
                d.update(bb);
                bb.clear();
            }
            string = StringUtilities.encode(d.digest());
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
            IOUtilities.close(in);
            return string2;
        }
        IOUtilities.close(in);
        return string;
    }

    public static String calculateMD5Hash(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(bytes);
        return StringUtilities.encode(d.digest());
    }

    public static MessageDigest getMD5Digest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte[] createCipherBytes(String key, int bitsNeeded) {
        String word = EncryptionUtilities.calculateMD5Hash(key.getBytes());
        return word.substring(0, bitsNeeded / 8).getBytes();
    }

    public static Cipher createAesEncryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 1);
    }

    public static Cipher createAesDecryptionCipher(String key) throws Exception {
        return EncryptionUtilities.createAesCipher(key, 2);
    }

    public static Cipher createAesCipher(String key, int mode) throws Exception {
        SecretKeySpec sKey = new SecretKeySpec(EncryptionUtilities.createCipherBytes(key, 128), "AES");
        return EncryptionUtilities.createAesCipher(sKey, mode);
    }

    public static Cipher createAesCipher(Key key, int mode) throws Exception {
        MessageDigest d = EncryptionUtilities.getMD5Digest();
        d.update(key.getEncoded());
        byte[] iv = d.digest();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    public static String encrypt(String key, String content) {
        try {
            return StringUtilities.encode(EncryptionUtilities.createAesEncryptionCipher(key).doFinal(content.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String decrypt(String key, String hexStr) {
        try {
            return new String(EncryptionUtilities.createAesDecryptionCipher(key).doFinal(StringUtilities.decode(hexStr)));
        }
        catch (Exception e) {
            return null;
        }
    }
}

