/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DateUtilities;
import com.cedarsoftware.util.SafeSimpleDateFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Converter {
    public static Object convert(Object fromInstance, Class toType) {
        if (toType == null) {
            throw new IllegalArgumentException("Type cannot be null in Converter.convert(value, type)");
        }
        if (fromInstance == null) {
            return null;
        }
        switch (toType.getName()) {
            case "byte": 
            case "java.lang.Byte": {
                try {
                    if (fromInstance instanceof Byte) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).byteValue();
                    }
                    if (fromInstance instanceof String) {
                        return Byte.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? (byte)1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? (byte)1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Byte'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Byte'");
            }
            case "short": 
            case "java.lang.Short": {
                try {
                    if (fromInstance instanceof Short) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).shortValue();
                    }
                    if (fromInstance instanceof String) {
                        return Short.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? (short)1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? (short)1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Short'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Short'");
            }
            case "int": 
            case "java.lang.Integer": {
                try {
                    if (fromInstance instanceof Integer) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).intValue();
                    }
                    if (fromInstance instanceof String) {
                        return Integer.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1 : 0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1 : 0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to an 'Integer'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Integer'");
            }
            case "long": 
            case "java.lang.Long": {
                try {
                    if (fromInstance instanceof Long) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).longValue();
                    }
                    if (fromInstance instanceof String) {
                        return Long.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return ((java.util.Date)fromInstance).getTime();
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1L : 0L;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1L : 0L;
                    }
                    if (fromInstance instanceof Calendar) {
                        return ((Calendar)fromInstance).getTime().getTime();
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Long'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Long'");
            }
            case "java.lang.String": {
                if (fromInstance instanceof String) {
                    return fromInstance;
                }
                if (fromInstance instanceof BigDecimal) {
                    return ((BigDecimal)fromInstance).stripTrailingZeros().toPlainString();
                }
                if (fromInstance instanceof Number || fromInstance instanceof Boolean || fromInstance instanceof AtomicBoolean) {
                    return fromInstance.toString();
                }
                if (fromInstance instanceof java.util.Date) {
                    return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(fromInstance);
                }
                if (fromInstance instanceof Calendar) {
                    return SafeSimpleDateFormat.getDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(((Calendar)fromInstance).getTime());
                }
                if (fromInstance instanceof Character) {
                    return "" + fromInstance;
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'String'");
            }
            case "java.math.BigDecimal": {
                try {
                    if (fromInstance instanceof BigDecimal) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigInteger) {
                        return new BigDecimal((BigInteger)fromInstance);
                    }
                    if (fromInstance instanceof String) {
                        return new BigDecimal(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Number) {
                        return new BigDecimal(((Number)fromInstance).doubleValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigDecimal(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigDecimal(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'BigDecimal'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'BigDecimal'");
            }
            case "java.math.BigInteger": {
                try {
                    if (fromInstance instanceof BigInteger) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof BigDecimal) {
                        return ((BigDecimal)fromInstance).toBigInteger();
                    }
                    if (fromInstance instanceof String) {
                        return new BigInteger(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Number) {
                        return new BigInteger(Long.toString(((Number)fromInstance).longValue()));
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? BigInteger.ONE : BigInteger.ZERO;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new BigInteger(Long.toString(((java.util.Date)fromInstance).getTime()));
                    }
                    if (fromInstance instanceof Calendar) {
                        return new BigInteger(Long.toString(((Calendar)fromInstance).getTime().getTime()));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'BigInteger'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'BigInteger'");
            }
            case "java.util.Date": {
                try {
                    if (fromInstance instanceof Date) {
                        return new java.util.Date(((Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof String) {
                        return DateUtilities.parseDate(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Calendar) {
                        return ((Calendar)fromInstance).getTime();
                    }
                    if (fromInstance instanceof Long) {
                        return new java.util.Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new java.util.Date(((AtomicLong)fromInstance).get());
                    }
                    throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Date'");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Date'", e);
                }
            }
            case "java.sql.Date": {
                try {
                    if (fromInstance instanceof Date) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new Date(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof String) {
                        java.util.Date date = DateUtilities.parseDate(((String)fromInstance).trim());
                        return new Date(date.getTime());
                    }
                    if (fromInstance instanceof Calendar) {
                        return new Date(((Calendar)fromInstance).getTime().getTime());
                    }
                    if (fromInstance instanceof Long) {
                        return new Date((Long)fromInstance);
                    }
                    if (fromInstance instanceof AtomicLong) {
                        return new Date(((AtomicLong)fromInstance).get());
                    }
                    throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'java.sql.Date'");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'java.sql.Date'", e);
                }
            }
            case "float": 
            case "java.lang.Float": {
                try {
                    if (fromInstance instanceof Float) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return Float.valueOf(((Number)fromInstance).floatValue());
                    }
                    if (fromInstance instanceof String) {
                        return Float.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return Float.valueOf((Boolean)fromInstance != false ? 1.0f : 0.0f);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return Float.valueOf(((AtomicBoolean)fromInstance).get() ? 1.0f : 0.0f);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Float'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Float'");
            }
            case "double": 
            case "java.lang.Double": {
                try {
                    if (fromInstance instanceof Double) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return ((Number)fromInstance).doubleValue();
                    }
                    if (fromInstance instanceof String) {
                        return Double.valueOf(((String)fromInstance).trim());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? 1.0 : 0.0;
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? 1.0 : 0.0;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to a 'Double'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Double'");
            }
            case "java.util.concurrent.atomic.AtomicInteger": {
                try {
                    if (fromInstance instanceof AtomicInteger) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof String) {
                        return new AtomicInteger(Integer.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicInteger(((Number)fromInstance).intValue());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicInteger(1) : new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to an 'AtomicInteger'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'AtomicInteger'");
            }
            case "java.util.concurrent.atomic.AtomicLong": {
                try {
                    if (fromInstance instanceof AtomicLong) {
                        return fromInstance;
                    }
                    if (fromInstance instanceof Number) {
                        return new AtomicLong(((Number)fromInstance).longValue());
                    }
                    if (fromInstance instanceof String) {
                        return new AtomicLong(Long.valueOf(((String)fromInstance).trim()));
                    }
                    if (fromInstance instanceof java.util.Date) {
                        return new AtomicLong(((java.util.Date)fromInstance).getTime());
                    }
                    if (fromInstance instanceof Boolean) {
                        return (Boolean)fromInstance != false ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof AtomicBoolean) {
                        return ((AtomicBoolean)fromInstance).get() ? new AtomicLong(1L) : new AtomicLong(0L);
                    }
                    if (fromInstance instanceof Calendar) {
                        return new AtomicLong(((Calendar)fromInstance).getTime().getTime());
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("value [" + fromInstance.getClass().getName() + "] could not be converted to an 'AtomicLong'", e);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'AtomicLong'");
            }
            case "boolean": 
            case "java.lang.Boolean": {
                if (fromInstance instanceof Boolean) {
                    return fromInstance;
                }
                if (fromInstance instanceof Number) {
                    return ((Number)fromInstance).longValue() != 0L;
                }
                if (fromInstance instanceof String) {
                    String value = (String)fromInstance;
                    return "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (fromInstance instanceof AtomicBoolean) {
                    return ((AtomicBoolean)fromInstance).get();
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'Boolean'");
            }
            case "java.util.concurrent.atomic.AtomicBoolean": {
                if (fromInstance instanceof AtomicBoolean) {
                    return fromInstance;
                }
                if (fromInstance instanceof String) {
                    String value = (String)fromInstance;
                    return new AtomicBoolean("true".equalsIgnoreCase(value));
                }
                if (fromInstance instanceof Number) {
                    return new AtomicBoolean(((Number)fromInstance).longValue() != 0L);
                }
                if (fromInstance instanceof Boolean) {
                    return new AtomicBoolean((Boolean)fromInstance);
                }
                throw new IllegalArgumentException("Unsupported value type [" + fromInstance.getClass().getName() + "] attempting to convert to 'AtomicBoolean'");
            }
        }
        throw new IllegalArgumentException("Unsupported type '" + toType.getName() + "' for conversion");
    }
}

