/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization.jdom;

import com.cedarsoft.Version;
import com.cedarsoft.VersionRange;
import com.cedarsoft.serialization.SerializingStrategySupport;
import com.cedarsoft.serialization.jdom.AbstractJDomSerializer;
import com.cedarsoft.serialization.jdom.JDomSerializingStrategy;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AbstractDelegatingJDomSerializer<T>
extends AbstractJDomSerializer<T> {
    @NotNull
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NotNull
    private final SerializingStrategySupport<T, JDomSerializingStrategy<T>> serializingStrategySupport;

    public AbstractDelegatingJDomSerializer(@NotNull String defaultElementName, @NonNls @NotNull String nameSpaceUriBase, @NotNull VersionRange formatVersionRange, JDomSerializingStrategy<? extends T> ... strategies) {
        this(defaultElementName, nameSpaceUriBase, formatVersionRange, Arrays.asList(strategies));
    }

    public AbstractDelegatingJDomSerializer(@NotNull String defaultElementName, @NonNls @NotNull String nameSpaceUriBase, @NotNull VersionRange formatVersionRange, @NotNull Collection<? extends JDomSerializingStrategy<? extends T>> strategies) {
        super(defaultElementName, nameSpaceUriBase, formatVersionRange);
        this.serializingStrategySupport = new SerializingStrategySupport(strategies);
    }

    public void serialize(@NotNull Element serializeTo, @NotNull T object) throws IOException {
        JDomSerializingStrategy strategy = (JDomSerializingStrategy)this.serializingStrategySupport.findStrategy(object);
        serializeTo.setAttribute(ATTRIBUTE_TYPE, strategy.getId());
        strategy.serialize(serializeTo, object);
    }

    @NotNull
    public T deserialize(@NotNull Element deserializeFrom, @NotNull Version formatVersion) throws IOException {
        String type = deserializeFrom.getAttributeValue(ATTRIBUTE_TYPE);
        JDomSerializingStrategy strategy = (JDomSerializingStrategy)this.serializingStrategySupport.findStrategy(type);
        return (T)strategy.deserialize(deserializeFrom, formatVersion);
    }

    @NotNull
    public Collection<? extends JDomSerializingStrategy<T>> getStrategies() {
        return this.serializingStrategySupport.getStrategies();
    }
}

