/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization.ui;

import com.cedarsoft.Version;
import com.cedarsoft.serialization.DelegateMapping;
import com.cedarsoft.serialization.DelegatesMappings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DelegatesMappingVisualizer {
    @NotNull
    @NonNls
    private static final String COL_SEPARATOR = "  ";
    @NotNull
    @NonNls
    private static final String FIRST_COLUMN_SEPARATOR = " -->";
    private static final int COL_WIDTH = 8;
    @NotNull
    @NonNls
    private static final String COL_VERSION_REPEAT = "|  ";
    @NotNull
    private final DelegatesMappings<?, ?, ?> mappings;

    public DelegatesMappingVisualizer(@NotNull DelegatesMappings<?, ?, ?> mappings) {
        this.mappings = mappings;
    }

    @NotNull
    @NonNls
    public String visualize() throws IOException {
        StringWriter writer = new StringWriter();
        this.visualize(writer);
        return writer.toString();
    }

    public void visualize(@NotNull Writer out) throws IOException {
        ArrayList<Column> columns = new ArrayList<Column>();
        SortedSet<Version> keyVersions = this.mappings.getMappedVersions();
        ArrayList keys = new ArrayList(this.mappings.getMappings().keySet());
        Collections.sort(keys, new Comparator<Class<?>>(){

            @Override
            public int compare(@NonNls Class<?> o1, @NonNls Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class clazz : keys) {
            DelegateMapping mapping = this.mappings.getMapping(clazz);
            ArrayList<Version> versions = new ArrayList<Version>();
            for (Version keyVersion : keyVersions) {
                versions.add(mapping.resolveVersion(keyVersion));
            }
            columns.add(new Column(clazz, versions));
        }
        this.writeHeadline(columns, out);
        DelegatesMappingVisualizer.writeSeparator(columns.size(), out);
        DelegatesMappingVisualizer.writeContent(new ArrayList<Version>(keyVersions), columns, out);
        DelegatesMappingVisualizer.writeSeparator(columns.size(), out);
    }

    private static void writeContent(@NotNull List<? extends Version> keyVersions, @NotNull Iterable<? extends Column> columns, @NotNull Writer out) throws IOException {
        int keyVersionsSize = keyVersions.size();
        for (int i = 0; i < keyVersionsSize; ++i) {
            Version keyVersion = keyVersions.get(i);
            out.write(DelegatesMappingVisualizer.extend(keyVersion.format()));
            out.write(FIRST_COLUMN_SEPARATOR);
            for (Column column : columns) {
                out.write(COL_SEPARATOR);
                out.write(DelegatesMappingVisualizer.extend((String)column.lines.get(i)));
            }
            out.write("\n");
        }
    }

    private static void writeSeparator(int columnsSize, @NotNull Writer out) throws IOException {
        int count = 8;
        count += FIRST_COLUMN_SEPARATOR.length();
        count += COL_SEPARATOR.length() * columnsSize;
        out.write(StringUtils.repeat((String)"-", (int)(count += 8 * columnsSize)) + "\n");
    }

    protected void writeHeadline(@NotNull Iterable<? extends Column> columns, @NotNull Writer out) throws IOException {
        out.write(DelegatesMappingVisualizer.extend(""));
        out.write(FIRST_COLUMN_SEPARATOR);
        for (Column column : columns) {
            out.write(COL_SEPARATOR);
            out.write(DelegatesMappingVisualizer.extend(column.header));
        }
        out.write("\n");
    }

    @NotNull
    @NonNls
    private static String extend(@NonNls @NotNull String string) {
        if (string.length() > 8) {
            return string.substring(0, 8);
        }
        return StringUtils.leftPad((String)string, (int)8);
    }

    public static class Column {
        @NotNull
        @NonNls
        private final String header;
        @NotNull
        private final List<String> lines = new ArrayList<String>();

        public Column(@NotNull Class<?> type, @NotNull Iterable<? extends Version> versions) {
            this.header = Column.getRepresentation(type);
            Version lastVersion = null;
            for (Version version : versions) {
                if (version.equals(lastVersion)) {
                    this.lines.add(DelegatesMappingVisualizer.COL_VERSION_REPEAT);
                } else {
                    this.lines.add(version.format());
                }
                lastVersion = version;
            }
        }

        @NotNull
        @NonNls
        private static String getRepresentation(@NotNull Class<?> type) {
            String[] parts = type.getName().split("\\.");
            return parts[parts.length - 1];
        }
    }
}

