/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization;

import com.cedarsoft.serialization.NotFoundException;
import com.cedarsoft.serialization.SerializingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SerializingStrategySupport<T, S extends SerializingStrategy<? extends T, ?, ?, ?>> {
    @NotNull
    private final List<S> strategies = new ArrayList<S>();

    public SerializingStrategySupport(@NotNull Iterable<? extends SerializingStrategy<? extends T, ?, ?, ?>> strategies) {
        for (SerializingStrategy<T, ?, ?, ?> serializingStrategy : strategies) {
            this.strategies.add(serializingStrategy);
        }
        if (this.strategies.isEmpty()) {
            throw new IllegalArgumentException("Need at least one strategy");
        }
    }

    @NotNull
    public S findStrategy(@NotNull @NonNls String id) throws NotFoundException {
        for (SerializingStrategy strategy : this.strategies) {
            if (!strategy.getId().equals(id)) continue;
            return (S)strategy;
        }
        throw new NotFoundException("No strategy found for id <" + id + ">");
    }

    @NotNull
    public S findStrategy(@NotNull T object) throws NotFoundException {
        for (SerializingStrategy strategy : this.strategies) {
            if (!strategy.supports(object)) continue;
            return (S)strategy;
        }
        throw new NotFoundException("No strategy found for object <" + object + ">");
    }

    @NotNull
    public Collection<? extends S> getStrategies() {
        return Collections.unmodifiableList(this.strategies);
    }
}

