/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization;

import com.cedarsoft.UnsupportedVersionException;
import com.cedarsoft.UnsupportedVersionRangeException;
import com.cedarsoft.Version;
import com.cedarsoft.VersionException;
import com.cedarsoft.VersionMismatchException;
import com.cedarsoft.VersionRange;
import com.cedarsoft.serialization.DelegateMapping;
import com.cedarsoft.serialization.PluggableSerializer;
import com.cedarsoft.serialization.Serializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class DelegatesMappings<S, D, E extends Throwable> {
    @NotNull
    private final VersionRange versionRange;
    @NotNull
    private final Map<Class<?>, DelegateMapping> mappings = new HashMap();
    @NotNull
    private final Map<Class<?>, Serializer<?>> serializers = new HashMap();

    public DelegatesMappings(@NotNull VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    @NotNull
    public Map<? extends Class<?>, ? extends DelegateMapping> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    @NotNull
    public <T> FluentFactory<T> add(@NotNull PluggableSerializer<? super T, S, D, E> serializer) {
        return new FluentFactory<T>(serializer);
    }

    @NotNull
    public <T> Version resolveVersion(@NotNull Class<? extends T> key, @NotNull Version version) {
        return this.getMapping(key).resolveVersion(version);
    }

    @NotNull
    public DelegateMapping getMapping(@NotNull Class<?> key) {
        DelegateMapping mapping = this.mappings.get(key);
        if (mapping == null) {
            throw new IllegalArgumentException("No mapping found for <" + key + ">");
        }
        return mapping;
    }

    public <T> void serialize(@NotNull T object, @NotNull Class<T> type, @NotNull S outputElement) throws E, IOException {
        PluggableSerializer<T, S, D, E> serializer = this.getSerializer(type);
        serializer.serialize(outputElement, object);
    }

    @NotNull
    public <T> PluggableSerializer<? super T, S, D, E> getSerializer(@NotNull Class<T> type) {
        PluggableSerializer serializer = (PluggableSerializer)this.serializers.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("No serializer found for <" + type.getName() + ">");
        }
        return serializer;
    }

    @NotNull
    public <T> T deserialize(@NotNull Class<T> type, @NotNull Version formatVersion, @NotNull D deserializeFrom) throws E, IOException {
        PluggableSerializer<T, S, D, E> serializer = this.getSerializer(type);
        return type.cast(serializer.deserialize(deserializeFrom, this.resolveVersion(type, formatVersion)));
    }

    public boolean verify() throws VersionException {
        SortedSet<Version> mappedVersions = this.getMappedVersions();
        if (this.mappings.isEmpty()) {
            throw new VersionException("No mappings available");
        }
        for (Map.Entry<Class<?>, DelegateMapping> entry : this.mappings.entrySet()) {
            DelegateMapping mapping = entry.getValue();
            if (!mapping.getSourceVersionRange().equals((Object)this.versionRange)) {
                throw new UnsupportedVersionRangeException(this.versionRange, mapping.getSourceVersionRange(), "Invalid mapping for <" + entry.getKey().getName() + ">. ");
            }
            try {
                mapping.verify();
                mapping.verifyMappedVersions(mappedVersions);
            }
            catch (VersionMismatchException e) {
                VersionMismatchException newException = new VersionMismatchException(e.getExpected(), e.getActual(), "Invalid mapping for <" + entry.getKey().getName() + ">: " + e.getMessage(), false);
                newException.setStackTrace(e.getStackTrace());
                throw newException;
            }
            catch (UnsupportedVersionException e) {
                UnsupportedVersionException newException = new UnsupportedVersionException(e.getActual(), e.getSupportedRange(), "Invalid mapping for <" + entry.getKey().getName() + ">: " + e.getMessage(), false);
                newException.setStackTrace(e.getStackTrace());
                throw newException;
            }
            PluggableSerializer<?, S, D, E> serializer = this.getSerializer(entry.getKey());
            if (serializer.getFormatVersion().equals((Object)mapping.getDelegateWriteVersion())) continue;
            throw new VersionMismatchException(serializer.getFormatVersion(), mapping.getDelegateWriteVersion(), "Invalid serialization/output version for <" + entry.getKey().getName() + ">. ");
        }
        return true;
    }

    @NotNull
    public SortedSet<Version> getMappedVersions() {
        TreeSet<Version> keyVersions = new TreeSet<Version>();
        for (DelegateMapping mapping : this.getMappings().values()) {
            keyVersions.add(mapping.getSourceVersionRange().getMin());
            keyVersions.add(mapping.getSourceVersionRange().getMax());
            for (DelegateMapping.Entry entry : mapping.getEntries()) {
                keyVersions.add(entry.getVersionRange().getMin());
                keyVersions.add(entry.getVersionRange().getMax());
            }
        }
        return keyVersions;
    }

    public class FluentFactory<T> {
        @NotNull
        private final PluggableSerializer<? super T, S, D, E> serializer;

        public FluentFactory(PluggableSerializer<? super T, S, D, E> serializer) {
            this.serializer = serializer;
        }

        @NotNull
        public DelegateMapping responsibleFor(@NotNull Class<? extends T> key) {
            if (DelegatesMappings.this.mappings.containsKey(key)) {
                throw new IllegalArgumentException("A serializer for the key <" + key + "> has still been added");
            }
            DelegateMapping mapping = new DelegateMapping(DelegatesMappings.this.versionRange, this.serializer.getFormatVersionRange());
            DelegatesMappings.this.mappings.put(key, mapping);
            DelegatesMappings.this.serializers.put(key, this.serializer);
            return mapping;
        }
    }
}

