/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization;

import com.cedarsoft.UnsupportedVersionException;
import com.cedarsoft.UnsupportedVersionRangeException;
import com.cedarsoft.Version;
import com.cedarsoft.VersionException;
import com.cedarsoft.VersionMismatchException;
import com.cedarsoft.VersionRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DelegateMapping {
    @NotNull
    private final VersionRange sourceVersionRange;
    @NotNull
    private final VersionRange delegateVersionRange;
    @NotNull
    private final List<Entry> entries = new ArrayList<Entry>();

    public DelegateMapping(@NotNull VersionRange sourceVersionRange, @NotNull VersionRange delegateVersionRange) {
        this.sourceVersionRange = sourceVersionRange;
        this.delegateVersionRange = delegateVersionRange;
    }

    @NotNull
    public Collection<? extends Entry> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @NotNull
    public VersionRange getSourceVersionRange() {
        return this.sourceVersionRange;
    }

    @NotNull
    public VersionRange getDelegateVersionRange() {
        return this.delegateVersionRange;
    }

    @NotNull
    public FluentFactory map(@NotNull VersionRange range) throws VersionException {
        return new FluentFactory(range);
    }

    @NotNull
    public FluentFactory map(@NotNull Version version) throws VersionException {
        return new FluentFactory(VersionRange.from((Version)version).single());
    }

    @NotNull
    public FluentFactory map(int major, int minor, int build) throws VersionException {
        return this.map(Version.valueOf((int)major, (int)minor, (int)build));
    }

    public void addMapping(@NotNull VersionRange sourceRange, @NotNull Version delegateVersion) throws VersionException {
        if (!this.sourceVersionRange.containsCompletely(sourceRange)) {
            throw new UnsupportedVersionRangeException(sourceRange, this.sourceVersionRange, "Invalid source range: ");
        }
        if (!this.delegateVersionRange.contains(delegateVersion)) {
            throw new UnsupportedVersionException(delegateVersion, this.delegateVersionRange, "Invalid delegate version: ");
        }
        if (this.containsMappingIn(sourceRange)) {
            throw new UnsupportedVersionRangeException(sourceRange, null, "The version range has still been mapped: ");
        }
        this.entries.add(new Entry(sourceRange, delegateVersion));
    }

    private boolean containsMappingIn(@NotNull VersionRange range) {
        for (Entry entry : this.entries) {
            if (!entry.versionRange.overlaps(range)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Version resolveVersion(@NotNull Version version) throws UnsupportedVersionException {
        for (Entry entry : this.entries) {
            if (!entry.versionRange.contains(version)) continue;
            return entry.delegateVersion;
        }
        throw new UnsupportedVersionException(version, null, "No delegate version mapped for source version <" + version + ">", false);
    }

    public void verify() throws VersionException {
        if (this.entries.isEmpty()) {
            throw new VersionException("No mappings available");
        }
        Version currentMin = this.entries.get(0).getVersionRange().getMin();
        if (!currentMin.equals((Object)this.sourceVersionRange.getMin())) {
            throw new VersionMismatchException(this.sourceVersionRange.getMin(), currentMin, "Lower border of source range not mapped: ");
        }
        Entry last = this.entries.get(this.entries.size() - 1);
        Version currentMax = last.getVersionRange().getMax();
        if (!currentMax.equals((Object)this.sourceVersionRange.getMax())) {
            throw new VersionMismatchException(this.sourceVersionRange.getMax(), currentMax, "Upper border of source range not mapped: ");
        }
    }

    @NotNull
    public Version getDelegateWriteVersion() {
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("Contains no entries");
        }
        return this.entries.get(this.entries.size() - 1).getDelegateVersion();
    }

    public void verifyMappedVersions(Iterable<? extends Version> mappedVersions) throws UnsupportedVersionException {
        for (Version version : mappedVersions) {
            this.resolveVersion(version);
        }
    }

    public class FluentFactory {
        @NotNull
        private final VersionRange range;

        public FluentFactory(VersionRange range) {
            this.range = range;
        }

        @NotNull
        public DelegateMapping toDelegateVersion(int major, int minor, int build) {
            return this.toDelegateVersion(Version.valueOf((int)major, (int)minor, (int)build));
        }

        @NotNull
        public DelegateMapping toDelegateVersion(@NotNull Version version) {
            DelegateMapping.this.addMapping(this.range, version);
            return DelegateMapping.this;
        }

        @NotNull
        public FluentFactory to(int major, int minor, int build) {
            return new FluentFactory(VersionRange.from((Version)this.range.getMin()).to(major, minor, build));
        }
    }

    public static class Entry {
        @NotNull
        private final VersionRange versionRange;
        @NotNull
        private final Version delegateVersion;

        Entry(@NotNull VersionRange versionRange, @NotNull Version delegateVersion) {
            this.versionRange = versionRange;
            this.delegateVersion = delegateVersion;
        }

        @NotNull
        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        @NotNull
        public Version getDelegateVersion() {
            return this.delegateVersion;
        }
    }
}

