/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization;

import com.cedarsoft.Version;
import com.cedarsoft.VersionException;
import com.cedarsoft.VersionRange;
import com.cedarsoft.serialization.AbstractSerializer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlSerializer<T, S, D, E extends Throwable>
extends AbstractSerializer<T, S, D, E> {
    @NotNull
    @NonNls
    private final String defaultElementName;
    @NotNull
    @NonNls
    private final String nameSpaceUriBase;

    protected AbstractXmlSerializer(@NotNull @NonNls String defaultElementName, @NonNls @NotNull String nameSpaceUriBase, @NotNull VersionRange formatVersionRange) {
        super(formatVersionRange);
        this.defaultElementName = defaultElementName;
        this.nameSpaceUriBase = nameSpaceUriBase;
    }

    @NotNull
    @NonNls
    protected String createNameSpaceUri(@NotNull Version formatVersion) {
        return this.getNameSpaceUriBase() + "/" + formatVersion.format();
    }

    @NotNull
    @NonNls
    public String getNameSpaceUri() {
        return this.createNameSpaceUri(this.getFormatVersion());
    }

    @NonNls
    @NotNull
    public String getNameSpaceUriBase() {
        return this.nameSpaceUriBase;
    }

    @NotNull
    @NonNls
    public String getDefaultElementName() {
        return this.defaultElementName;
    }

    @NotNull
    public static Version parseVersionFromNamespaceUri(@Nullable @NonNls String namespaceURI) throws IllegalArgumentException, VersionException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            throw new VersionException("No version information found");
        }
        String[] parts = namespaceURI.split("/");
        String last = parts[parts.length - 1];
        return Version.parse((String)last);
    }

    @Override
    @NotNull
    public <T> AbstractXmlSerializer<? super T, S, D, E> getSerializer(@NotNull Class<T> type) {
        return (AbstractXmlSerializer)super.getSerializer(type);
    }
}

