/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.serialization;

import com.cedarsoft.Version;
import com.cedarsoft.VersionRange;
import com.cedarsoft.serialization.DelegatesMappings;
import com.cedarsoft.serialization.PluggableSerializer;
import com.cedarsoft.serialization.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSerializer<T, S, D, E extends Throwable>
implements PluggableSerializer<T, S, D, E> {
    @NotNull
    private final VersionRange formatVersionRange;
    @NotNull
    protected final DelegatesMappings<S, D, E> delegatesMappings;

    protected AbstractSerializer(@NotNull VersionRange formatVersionRange) {
        this.formatVersionRange = formatVersionRange;
        this.delegatesMappings = new DelegatesMappings(formatVersionRange);
    }

    @Override
    @NotNull
    public Version getFormatVersion() {
        return this.formatVersionRange.getMax();
    }

    @Override
    @NotNull
    public VersionRange getFormatVersionRange() {
        return this.formatVersionRange;
    }

    @NotNull
    public byte[] serializeToByteArray(@NotNull T object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(object, out);
        return out.toByteArray();
    }

    @NotNull
    public DelegatesMappings<S, D, E> getDelegatesMappings() {
        return this.delegatesMappings;
    }

    @NotNull
    public <T> DelegatesMappings.FluentFactory<T> add(@NotNull PluggableSerializer<? super T, S, D, E> sdePluggableSerializer) {
        return this.delegatesMappings.add(sdePluggableSerializer);
    }

    public <T> void serialize(@NotNull T object, @NotNull Class<T> type, @NotNull S outputElement) throws E, IOException {
        this.delegatesMappings.serialize(object, type, outputElement);
    }

    @NotNull
    public <T> PluggableSerializer<? super T, S, D, E> getSerializer(@NotNull Class<T> type) {
        return this.delegatesMappings.getSerializer(type);
    }

    @NotNull
    public <T> T deserialize(@NotNull Class<T> type, @NotNull Version formatVersion, @NotNull D deserializeFrom) throws E, IOException {
        return this.delegatesMappings.deserialize(type, formatVersion, deserializeFrom);
    }

    protected static void verifyDelegatingSerializerVersion(@NotNull Serializer<?> delegate, @NotNull Version expectedFormatVersion) {
        Version actualVersion = delegate.getFormatVersion();
        if (!actualVersion.equals((Object)expectedFormatVersion)) {
            throw new IllegalArgumentException("Invalid versions. Expected <" + expectedFormatVersion + "> but was <" + actualVersion + ">");
        }
    }
}

