/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft;

import com.cedarsoft.Version;
import java.io.Serializable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VersionRange
implements Serializable {
    @NotNull
    private final Version min;
    @NotNull
    private final Version max;
    private final boolean includeLower;
    private final boolean includeUpper;

    public VersionRange(@NotNull Version min, @NotNull Version max) {
        this(min, max, true, true);
    }

    public VersionRange(@NotNull Version min, @NotNull Version max, boolean includeLower, boolean includeUpper) {
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("Max <" + max + "> is smaller than min <" + min + ">");
        }
        this.min = min;
        this.max = max;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @NotNull
    public Version getMin() {
        return this.min;
    }

    @NotNull
    public Version getMax() {
        return this.max;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public boolean containsCompletely(@NotNull VersionRange other) {
        boolean lower = this.includeLower ? this.getMin().sameOrSmallerThan(other.getMin()) : this.getMin().smallerThan(other.getMin());
        if (!lower) {
            return false;
        }
        if (this.includeUpper) {
            return this.getMax().sameOrGreaterThan(other.getMax());
        }
        return this.getMax().greaterThan(other.getMax());
    }

    public boolean contains(@NotNull Version version) {
        if (this.includeLower ? !version.sameOrGreaterThan(this.min) : !version.greaterThan(this.min)) {
            return false;
        }
        if (this.includeUpper) {
            return version.sameOrSmallerThan(this.max);
        }
        return version.smallerThan(this.max);
    }

    public boolean overlaps(@NotNull VersionRange other) {
        boolean lower = this.includeLower && other.includeUpper ? this.getMin().sameOrSmallerThan(other.getMax()) : this.getMin().smallerThan(other.getMax());
        boolean upper = this.includeUpper && other.includeLower ? this.getMax().sameOrGreaterThan(other.getMin()) : this.getMax().greaterThan(other.getMin());
        return lower && upper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionRange)) {
            return false;
        }
        VersionRange range = (VersionRange)o;
        if (!this.max.equals(range.max)) {
            return false;
        }
        return this.min.equals(range.min);
    }

    public int hashCode() {
        int result = this.min.hashCode();
        result = 31 * result + this.max.hashCode();
        return result;
    }

    @NotNull
    @NonNls
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeLower) {
            builder.append("[");
            builder.append(this.min);
        } else {
            builder.append("]");
            builder.append(this.min);
        }
        builder.append("-");
        if (this.includeUpper) {
            builder.append(this.max);
            builder.append("]");
        } else {
            builder.append(this.max);
            builder.append("[");
        }
        return builder.toString();
    }

    @NotNull
    public static Factory from(@NotNull Version min) {
        return new Factory(min);
    }

    @NotNull
    public static Factory from(int major, int minor, int build) {
        return new Factory(new Version(major, minor, build));
    }

    @NotNull
    public VersionRange single(int major, int minor, int build) {
        return new VersionRange(Version.valueOf(major, minor, build), Version.valueOf(major, minor, build));
    }

    public static class Factory {
        @NotNull
        private final Version min;

        public Factory(@NotNull Version min) {
            this.min = min;
        }

        @NotNull
        public VersionRange to(@NotNull Version max) {
            return new VersionRange(this.min, max);
        }

        @NotNull
        public VersionRange to(int major, int minor, int build) {
            return this.to(new Version(major, minor, build));
        }

        @NotNull
        public VersionRange to() {
            return this.single();
        }

        @NotNull
        public VersionRange single() {
            return new VersionRange(this.min, this.min);
        }
    }
}

