/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft;

import com.cedarsoft.VersionException;
import com.cedarsoft.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsupportedVersionRangeException
extends VersionException {
    @NotNull
    private final VersionRange actual;
    @Nullable
    private final VersionRange supportedRange;

    public UnsupportedVersionRangeException(@NotNull VersionRange actual) {
        this(actual, null);
    }

    public UnsupportedVersionRangeException(@NotNull VersionRange actual, @Nullable VersionRange supportedRange) {
        this(actual, supportedRange, "Unsupported version range. ", true);
    }

    public UnsupportedVersionRangeException(@NotNull VersionRange actual, @Nullable VersionRange supportedRange, @NotNull String messagePrefix) {
        this(actual, supportedRange, messagePrefix, true);
    }

    public UnsupportedVersionRangeException(@NotNull VersionRange actual, @Nullable VersionRange supportedRange, @NotNull String message, boolean appendSuffix) {
        super(message, UnsupportedVersionRangeException.createMessageSuffix(actual, supportedRange), appendSuffix);
        this.actual = actual;
        this.supportedRange = supportedRange;
    }

    @NotNull
    public VersionRange getActual() {
        return this.actual;
    }

    @Nullable
    public VersionRange getSupportedRange() {
        return this.supportedRange;
    }

    private static String createMessageSuffix(@NotNull VersionRange actual, @Nullable VersionRange supportedRange) {
        if (supportedRange == null) {
            return "Was <" + actual + ">";
        }
        return "Was <" + actual + "> but expected <" + supportedRange.toString() + ">";
    }
}

