/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.crypt.xml;

import com.cedarsoft.crypt.X509Support;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureSupport {
    @Nonnull
    private static final XMLSignatureFactory SIGNATURE_FACTORY = XMLSignatureFactory.getInstance("DOM");
    @Nonnull
    private final X509Support x509Support;

    @Inject
    public XmlSignatureSupport(@Nonnull X509Support x509Support) {
        this.x509Support = x509Support;
    }

    public Document sign(@Nonnull Document xmlDocument) {
        try {
            String elementName = xmlDocument.getFirstChild().getNodeName();
            Reference ref = SIGNATURE_FACTORY.newReference('#' + elementName, SIGNATURE_FACTORY.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null));
            Element invoice = xmlDocument.getDocumentElement();
            DOMStructure content = new DOMStructure(invoice);
            XMLObject obj = SIGNATURE_FACTORY.newXMLObject(Collections.singletonList(content), elementName, null, null);
            SignedInfo si = SIGNATURE_FACTORY.newSignedInfo(SIGNATURE_FACTORY.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), SIGNATURE_FACTORY.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            XMLSignature signature = SIGNATURE_FACTORY.newXMLSignature(si, null, Collections.singletonList(obj), null, null);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document signedDoc = documentBuilderFactory.newDocumentBuilder().newDocument();
            DOMSignContext dsc = new DOMSignContext(this.x509Support.getPrivateKey(), (Node)signedDoc);
            signature.sign(dsc);
            return signedDoc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasValidSignature(@Nonnull Document doc) throws Exception {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new IllegalStateException("Cannot find Signature element!");
        }
        DOMValidateContext valContext = new DOMValidateContext(this.x509Support.getCertificate().getPublicKey(), nl.item(0));
        XMLSignature signature = SIGNATURE_FACTORY.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }

    @Nonnull
    public Node getOriginalNode(@Nonnull Document signedDocument) {
        NodeList nl = signedDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        if (nl.getLength() == 0) {
            throw new IllegalStateException("Cannot find Object element!");
        }
        Node objectNode = nl.item(0);
        return objectNode.getFirstChild();
    }

    @Nonnull
    public Document getOriginalDocument(@Nonnull Document signedDocument) {
        try {
            Node node = this.getOriginalNode(signedDocument);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document originalDoc = documentBuilderFactory.newDocumentBuilder().newDocument();
            originalDoc.appendChild(originalDoc.adoptNode(node));
            return originalDoc;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

