/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.crypt;

import com.cedarsoft.crypt.Algorithm;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class Hash
implements Serializable {
    private static final long serialVersionUID = 5728176239480983210L;
    @Nonnull
    private final Algorithm algorithm;
    @Nonnull
    private final byte[] value;

    public Hash(@Nonnull Algorithm algorithm, @Nonnull byte[] value) {
        this.algorithm = algorithm;
        this.value = (byte[])value.clone();
    }

    @Nonnull
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Nonnull
    public String getValueAsHex() {
        return new String(Hex.encodeHex((byte[])this.value));
    }

    @Nonnull
    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    @Nonnull
    public String toString() {
        return "[" + (Object)((Object)this.algorithm) + ": " + this.getValueAsHex() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash hash = (Hash)o;
        if (this.algorithm != hash.algorithm) {
            return false;
        }
        return Arrays.equals(this.value, hash.value);
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = 31 * result + (this.value != null ? Arrays.hashCode(this.value) : 0);
        return result;
    }

    @Nonnull
    public static Hash fromHex(@Nonnull Algorithm algorithm, @Nonnull String valueAsHex) {
        try {
            return new Hash(algorithm, Hex.decodeHex((char[])valueAsHex.toCharArray()));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Invalid hex string <" + valueAsHex + ">", e);
        }
    }
}

