/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.schema;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.exception.InternalException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;

public final class Schema {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public final JsonOrCedar type;
    public final Optional<JsonNode> schemaJson;
    public final Optional<String> schemaText;

    public Schema(JsonOrCedar type, Optional<String> schemaJson, Optional<String> schemaText) {
        this.type = type;
        this.schemaJson = schemaJson.map(jsonStr -> {
            try {
                return OBJECT_MAPPER.readTree(jsonStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        this.schemaText = schemaText;
    }

    public Schema(JsonNode schemaJson) {
        if (schemaJson == null) {
            throw new NullPointerException("schemaJson");
        }
        this.type = JsonOrCedar.Json;
        this.schemaJson = Optional.of(schemaJson);
        this.schemaText = Optional.empty();
    }

    public Schema(String schemaText) {
        if (schemaText == null) {
            throw new NullPointerException("schemaText");
        }
        this.type = JsonOrCedar.Cedar;
        this.schemaJson = Optional.empty();
        this.schemaText = Optional.of(schemaText);
    }

    public String toString() {
        if (this.type == JsonOrCedar.Json) {
            return "Schema(schemaJson=" + this.schemaJson.get() + ")";
        }
        return "Schema(schemaText=" + this.schemaText.get() + ")";
    }

    public static Schema parse(JsonOrCedar type, String str) throws InternalException, NullPointerException {
        if (type == JsonOrCedar.Json) {
            Schema.parseJsonSchemaJni(str);
            return new Schema(JsonOrCedar.Json, Optional.of(str), Optional.empty());
        }
        Schema.parseCedarSchemaJni(str);
        return new Schema(JsonOrCedar.Cedar, Optional.empty(), Optional.of(str));
    }

    private static native String parseJsonSchemaJni(String var0) throws InternalException, NullPointerException;

    private static native String parseCedarSchemaJni(String var0) throws InternalException, NullPointerException;

    static {
        LibraryLoader.loadLibrary();
    }

    public static enum JsonOrCedar {
        Json,
        Cedar;

    }
}

