/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.DetailedError;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ValidationResponse {
    @JsonProperty(value="type")
    public final SuccessOrFailure type;
    public final Optional<ValidationSuccessResponse> success;
    public final Optional<ImmutableList<DetailedError>> errors;
    public final ImmutableList<DetailedError> warnings;

    @JsonCreator
    public ValidationResponse(@JsonProperty(value="type") SuccessOrFailure type, @JsonProperty(value="validationErrors") Optional<List<ValidationError>> validationErrors, @JsonProperty(value="validationWarnings") Optional<List<ValidationError>> validationWarnings, @JsonProperty(value="errors") Optional<List<DetailedError>> errors, @JsonProperty(value="warnings") @JsonAlias(value={"otherWarnings"}) Optional<List<DetailedError>> warnings) {
        this.type = type;
        this.errors = errors.map(list -> ImmutableList.copyOf((Collection)list));
        this.success = type == SuccessOrFailure.Success ? Optional.of(new ValidationSuccessResponse(validationErrors, validationWarnings)) : Optional.empty();
        this.warnings = warnings.isPresent() ? ImmutableList.copyOf((Collection)warnings.get()) : ImmutableList.of();
    }

    public boolean validationPassed() {
        if (this.success.isPresent()) {
            return this.success.get().validationErrors.isEmpty();
        }
        return false;
    }

    public String toString() {
        if (this.success.isPresent()) {
            return "ValidationResponse(validationErrors = " + this.success.get().validationErrors + ", validationWarnings = " + this.success.get().validationWarnings + ")";
        }
        return "ValidationResponse(errors = " + this.errors.get() + ")";
    }

    public static enum SuccessOrFailure {
        Success,
        Failure;

    }

    public static final class ValidationSuccessResponse {
        @JsonProperty(value="validationErrors")
        public final ImmutableList<ValidationError> validationErrors;
        @JsonProperty(value="validationWarnings")
        public final ImmutableList<ValidationError> validationWarnings;

        @JsonCreator
        public ValidationSuccessResponse(@JsonProperty(value="validationErrors") Optional<List<ValidationError>> validationErrors, @JsonProperty(value="validationWarnings") Optional<List<ValidationError>> validationWarnings) {
            this.validationErrors = validationErrors.isPresent() ? ImmutableList.copyOf((Collection)validationErrors.get()) : ImmutableList.of();
            this.validationWarnings = validationWarnings.isPresent() ? ImmutableList.copyOf((Collection)validationWarnings.get()) : ImmutableList.of();
        }
    }

    public static final class ValidationError {
        @JsonProperty(value="policyId")
        private final String policyId;
        @JsonProperty(value="error")
        private final DetailedError error;

        @JsonCreator
        public ValidationError(@JsonProperty(value="policyId") String policyId, @JsonProperty(value="error") DetailedError error) {
            this.policyId = policyId;
            this.error = error;
        }

        public String getPolicyId() {
            return this.policyId;
        }

        public DetailedError getError() {
            return this.error;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ValidationError)) {
                return false;
            }
            ValidationError other = (ValidationError)o;
            return this.policyId.equals(other.policyId) && this.error.equals(other.error);
        }

        public int hashCode() {
            return Objects.hash(this.policyId, this.error);
        }

        public String toString() {
            return "Error(policyId=" + this.policyId + ", error=" + this.error + ")";
        }
    }
}

