/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy;

import com.cedarpolicy.model.entity.Entity;
import com.cedarpolicy.model.policy.PolicySet;
import com.cedarpolicy.model.policy.TemplateLink;
import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.serializer.EntityDeserializer;
import com.cedarpolicy.serializer.EntitySerializer;
import com.cedarpolicy.serializer.PolicySetSerializer;
import com.cedarpolicy.serializer.SchemaSerializer;
import com.cedarpolicy.serializer.TemplateLinkSerializer;
import com.cedarpolicy.serializer.ValueDeserializer;
import com.cedarpolicy.serializer.ValueSerializer;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;

public final class CedarJson {
    private static final ObjectMapper OBJECT_MAPPER = CedarJson.createObjectMapper();

    private CedarJson() {
        throw new IllegalStateException("Utility class");
    }

    public static ObjectMapper objectMapper() {
        return OBJECT_MAPPER.copy();
    }

    public static ObjectWriter objectWriter() {
        return OBJECT_MAPPER.writer();
    }

    public static ObjectReader objectReader() {
        return OBJECT_MAPPER.reader();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Entity.class, (JsonSerializer)new EntitySerializer());
        module.addSerializer(Schema.class, (JsonSerializer)new SchemaSerializer());
        module.addSerializer(TemplateLink.class, (JsonSerializer)new TemplateLinkSerializer());
        module.addSerializer(PolicySet.class, (JsonSerializer)new PolicySetSerializer());
        module.addSerializer(Value.class, (JsonSerializer)new ValueSerializer());
        module.addDeserializer(Value.class, (JsonDeserializer)new ValueDeserializer());
        module.addDeserializer(Entity.class, (JsonDeserializer)new EntityDeserializer());
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)new Jdk8Module());
        return mapper;
    }
}

