/*
 * Decompiled with CFR 0.152.
 */
package com.cbman.roundimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.cbman.roundimageview.R;

public class RoundImageView
extends ImageView {
    private static final int LEFT_TOP = 0;
    private static final int LEFT_BOTTOM = 1;
    private static final int RIGHT_TOP = 2;
    private static final int RIGHT_BOTTOM = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int MONOSPACE = 3;
    private Paint mPaint = null;
    private float borderWidth = 2.0f;
    private int borderColor = Color.parseColor((String)"#8A2BE2");
    private boolean displayBorder;
    private float leftTopRadius;
    private float rightTopRadius;
    private float leftBottomRadius;
    private float rightBottomRadius;
    private DisplayType displayType;
    private boolean displayLabel = false;
    private String labelText;
    private int textColor = -1;
    private int textSize = 15;
    private int labelBackground = Color.parseColor((String)"#9FFF0000");
    private int labelGravity = 2;
    private int labelWidth = 15;
    private int startMargin = 20;
    private TextPaint mTextPaint = null;
    private String text;
    private static final DisplayType[] displayTypeArray = new DisplayType[]{DisplayType.NORMAL, DisplayType.CIRCLE, DisplayType.ROUND_RECT};

    public RoundImageView(Context context) {
        this(context, null);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context ctx, AttributeSet attrs) {
        this.setLayerType(2, null);
        this.mPaint = new Paint();
        this.mTextPaint = new TextPaint();
        if (attrs != null) {
            int index;
            TypedArray a = ctx.obtainStyledAttributes(attrs, R.styleable.RoundImageView);
            this.borderWidth = a.getDimension(R.styleable.RoundImageView_borderWidth, this.borderWidth);
            this.borderColor = a.getColor(R.styleable.RoundImageView_borderColor, this.borderColor);
            this.displayBorder = a.getBoolean(R.styleable.RoundImageView_displayBorder, this.displayBorder);
            this.leftTopRadius = a.getDimension(R.styleable.RoundImageView_android_topLeftRadius, this.leftTopRadius);
            this.rightTopRadius = a.getDimension(R.styleable.RoundImageView_android_topRightRadius, this.rightTopRadius);
            this.leftBottomRadius = a.getDimension(R.styleable.RoundImageView_android_bottomLeftRadius, this.leftBottomRadius);
            this.rightBottomRadius = a.getDimension(R.styleable.RoundImageView_android_bottomRightRadius, this.rightBottomRadius);
            float radius = a.getDimension(R.styleable.RoundImageView_android_radius, 0.0f);
            if (radius > 0.0f) {
                this.rightTopRadius = this.rightBottomRadius = radius;
                this.leftBottomRadius = this.rightBottomRadius;
                this.leftTopRadius = this.rightBottomRadius;
            }
            this.displayType = (index = a.getInt(R.styleable.RoundImageView_displayType, -1)) >= 0 ? displayTypeArray[index] : DisplayType.NORMAL;
            this.displayLabel = a.getBoolean(R.styleable.RoundImageView_displayLabel, this.displayLabel);
            this.labelText = a.getString(R.styleable.RoundImageView_android_text);
            this.labelBackground = a.getColor(R.styleable.RoundImageView_labelBackground, this.labelBackground);
            this.textSize = a.getDimensionPixelSize(R.styleable.RoundImageView_android_textSize, this.textSize);
            this.textColor = a.getColor(R.styleable.RoundImageView_android_textColor, this.textColor);
            this.labelWidth = a.getDimensionPixelSize(R.styleable.RoundImageView_labelWidth, this.labelWidth);
            this.labelGravity = a.getInt(R.styleable.RoundImageView_labelGravity, this.labelGravity);
            this.startMargin = a.getDimensionPixelSize(R.styleable.RoundImageView_startMargin, this.startMargin);
            int typefaceIndex = a.getInt(R.styleable.RoundImageView_android_typeface, -1);
            int styleIndex = a.getInt(R.styleable.RoundImageView_android_textStyle, -1);
            this.setTypefaceFromAttrs(typefaceIndex, styleIndex);
            this.text = this.labelText;
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.displayType == DisplayType.CIRCLE) {
            int measureSpec = widthSize < heightSize ? widthMeasureSpec : heightMeasureSpec;
            if (widthSize <= 0) {
                measureSpec = heightMeasureSpec;
            }
            super.onMeasure(measureSpec, measureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() != null) {
            this.resetSize((float)Math.min(this.getWidth(), this.getHeight()) / 2.0f);
            Bitmap bm = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas mCanvas = new Canvas(bm);
            super.onDraw(mCanvas);
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.drawMyContent(mCanvas);
            canvas.drawBitmap(bm, 0.0f, 0.0f, this.mPaint);
            bm.recycle();
        } else {
            super.onDraw(canvas);
        }
    }

    private void resetSize(float size) {
        this.leftTopRadius = Math.min(this.leftTopRadius, size);
        this.rightTopRadius = Math.min(this.rightTopRadius, size);
        this.leftBottomRadius = Math.min(this.leftBottomRadius, size);
        this.rightBottomRadius = Math.min(this.rightBottomRadius, size);
        this.borderWidth = Math.min(this.borderWidth, size / 2.0f);
        this.labelWidth = (int)Math.min((float)this.labelWidth, size / 2.0f);
        this.textSize = Math.min(this.textSize, this.labelWidth);
        this.startMargin = Math.min(this.startMargin, (int)(size * 2.0f - this.getBevelLineLength()));
    }

    private float getBevelLineLength() {
        return (float)Math.sqrt(Math.pow(this.labelWidth, 2.0) * 2.0);
    }

    private void drawMyContent(Canvas mCanvas) {
        if (this.displayType != DisplayType.NORMAL) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            Path path = this.createPath();
            path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            mCanvas.drawPath(path, this.mPaint);
            this.mPaint.setXfermode(null);
        }
        if (this.displayBorder) {
            this.drawBorders(mCanvas);
        }
        if (this.displayLabel) {
            this.drawLabels(mCanvas);
        }
    }

    private void drawLabels(Canvas mCanvas) {
        Path path = new Path();
        Path mTextPath = new Path();
        switch (this.labelGravity) {
            case 0: {
                path.moveTo((float)this.startMargin, 0.0f);
                path.rLineTo(this.getBevelLineLength(), 0.0f);
                path.lineTo(0.0f, (float)this.startMargin + this.getBevelLineLength());
                path.rLineTo(0.0f, -this.getBevelLineLength());
                path.close();
                mTextPath.moveTo(0.0f, (float)this.startMargin + this.getBevelLineLength() / 2.0f);
                mTextPath.lineTo((float)this.startMargin + this.getBevelLineLength() / 2.0f, 0.0f);
                break;
            }
            case 1: {
                path.moveTo((float)this.startMargin, (float)this.getHeight());
                path.rLineTo(this.getBevelLineLength(), 0.0f);
                path.lineTo(0.0f, (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength()));
                path.rLineTo(0.0f, this.getBevelLineLength());
                path.close();
                mTextPath.moveTo(0.0f, (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f));
                mTextPath.lineTo((float)this.startMargin + this.getBevelLineLength() / 2.0f, (float)this.getHeight());
                break;
            }
            case 2: {
                path.moveTo((float)(this.getWidth() - this.startMargin), 0.0f);
                path.rLineTo(-this.getBevelLineLength(), 0.0f);
                path.lineTo((float)this.getWidth(), (float)this.startMargin + this.getBevelLineLength());
                path.rLineTo(0.0f, -this.getBevelLineLength());
                path.close();
                mTextPath.moveTo((float)this.getWidth() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f), 0.0f);
                mTextPath.lineTo((float)this.getWidth(), (float)this.startMargin + this.getBevelLineLength() / 2.0f);
                break;
            }
            case 3: {
                path.moveTo((float)(this.getWidth() - this.startMargin), (float)this.getHeight());
                path.rLineTo(-this.getBevelLineLength(), 0.0f);
                path.lineTo((float)this.getWidth(), (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength()));
                path.rLineTo(0.0f, this.getBevelLineLength());
                path.close();
                mTextPath.moveTo((float)this.getWidth() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f), (float)this.getHeight());
                mTextPath.lineTo((float)this.getWidth(), (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f));
            }
        }
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setColor(this.labelBackground);
        mCanvas.drawPath(path, (Paint)this.mTextPaint);
        this.mTextPaint.setTextSize((float)this.textSize);
        this.mTextPaint.setColor(this.textColor);
        if (null == this.text) {
            this.text = "";
        }
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        float textWidth = this.mTextPaint.measureText(this.text);
        PathMeasure pathMeasure = new PathMeasure(mTextPath, false);
        float pathLength = pathMeasure.getLength();
        if (textWidth > pathLength) {
            float sl = textWidth / (float)this.text.length();
            float le = textWidth - pathLength;
            int num = (int)Math.floor(le / sl);
            this.text = this.text.substring(0, this.text.length() - (num + 2)) + "...";
        }
        Paint.FontMetricsInt fm = this.mTextPaint.getFontMetricsInt();
        float v = (float)(fm.bottom - fm.top) / 2.0f - (float)fm.bottom;
        mCanvas.drawTextOnPath(this.text, mTextPath, 0.0f, v, (Paint)this.mTextPaint);
    }

    private void drawBorders(Canvas mCanvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.borderColor);
        this.mPaint.setStrokeWidth(this.borderWidth);
        Path path = this.createPath();
        mCanvas.drawPath(path, this.mPaint);
    }

    private Path createPath() {
        Path mPath = new Path();
        float size = this.borderWidth / 2.0f;
        switch (this.displayType) {
            case CIRCLE: {
                mPath.addCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f - size, Path.Direction.CW);
                break;
            }
            case ROUND_RECT: {
                RectF rectF = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rectF.inset(size, size);
                mPath.addRoundRect(rectF, new float[]{this.leftTopRadius, this.leftTopRadius, this.rightTopRadius, this.rightTopRadius, this.rightBottomRadius, this.rightBottomRadius, this.leftBottomRadius, this.leftBottomRadius}, Path.Direction.CW);
                break;
            }
            default: {
                RectF rect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rect.inset(size, size);
                mPath.addRect(rect, Path.Direction.CW);
            }
        }
        return mPath;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        if (this.borderWidth != borderWidth) {
            this.borderWidth = borderWidth;
            if (this.displayBorder) {
                this.postInvalidate();
            }
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        if (this.borderColor != borderColor) {
            this.borderColor = borderColor;
            if (this.displayBorder) {
                this.postInvalidate();
            }
        }
    }

    public boolean isDisplayBorder() {
        return this.displayBorder;
    }

    public void setDisplayBorder(boolean displayBorder) {
        if (this.displayBorder != displayBorder) {
            this.displayBorder = displayBorder;
            this.postInvalidate();
        }
    }

    public float getLeftTopRadius() {
        return this.leftTopRadius;
    }

    public void setLeftTopRadius(float leftTopRadius) {
        if (this.leftTopRadius != leftTopRadius) {
            this.leftTopRadius = leftTopRadius;
            if (this.displayType != DisplayType.NORMAL) {
                this.postInvalidate();
            }
        }
    }

    public float getRightTopRadius() {
        return this.rightTopRadius;
    }

    public void setRightTopRadius(float rightTopRadius) {
        if (this.rightTopRadius != rightTopRadius) {
            this.rightTopRadius = rightTopRadius;
            if (this.displayType != DisplayType.NORMAL) {
                this.postInvalidate();
            }
        }
    }

    public float getLeftBottomRadius() {
        return this.leftBottomRadius;
    }

    public void setLeftBottomRadius(float leftBottomRadius) {
        if (this.leftBottomRadius != leftBottomRadius) {
            this.leftBottomRadius = leftBottomRadius;
            if (this.displayType != DisplayType.NORMAL) {
                this.postInvalidate();
            }
        }
    }

    public float getRightBottomRadius() {
        return this.rightBottomRadius;
    }

    public void setRightBottomRadius(float rightBottomRadius) {
        if (this.rightBottomRadius != rightBottomRadius) {
            this.rightBottomRadius = rightBottomRadius;
            if (this.displayType != DisplayType.NORMAL) {
                this.postInvalidate();
            }
        }
    }

    public void setRadius(float leftTopRadius, float rightTopRadius, float leftBottomRadius, float rightBottomRadius) {
        if (this.leftTopRadius == leftTopRadius && this.rightTopRadius == rightTopRadius && this.leftBottomRadius == leftBottomRadius && this.rightBottomRadius == rightBottomRadius) {
            return;
        }
        this.leftTopRadius = leftTopRadius;
        this.rightTopRadius = rightTopRadius;
        this.leftBottomRadius = leftBottomRadius;
        this.rightBottomRadius = rightBottomRadius;
        if (this.displayType != DisplayType.NORMAL) {
            this.postInvalidate();
        }
    }

    public void setRadius(float radius) {
        this.setRadius(radius, radius, radius, radius);
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        if (this.displayType != displayType) {
            this.displayType = displayType;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setDisplayLabel(boolean displayLabel) {
        if (this.displayLabel != displayLabel) {
            this.displayLabel = displayLabel;
            if (displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setLabelText(String labelText) {
        if (!TextUtils.equals((CharSequence)this.labelText, (CharSequence)labelText)) {
            this.labelText = labelText;
            this.text = labelText;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setTextColor(int textColor) {
        if (this.textColor != textColor) {
            this.textColor = textColor;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setTextSize(int textSize) {
        if (this.textSize != textSize) {
            this.textSize = textSize;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setLabelBackground(int labelBackground) {
        if (this.labelBackground != labelBackground) {
            this.labelBackground = labelBackground;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setLabelGravity(int labelGravity) {
        if (this.labelGravity != labelGravity) {
            this.labelGravity = labelGravity;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setLabelWidth(int labelWidth) {
        if (this.labelWidth != labelWidth) {
            this.labelWidth = labelWidth;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public void setStartMargin(int startMargin) {
        if (this.startMargin != startMargin) {
            this.startMargin = startMargin;
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public boolean isDisplayLabel() {
        return this.displayLabel;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public int getLabelBackground() {
        return this.labelBackground;
    }

    public int getLabelGravity() {
        return this.labelGravity;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public int getStartMargin() {
        return this.startMargin;
    }

    private void setTypefaceFromAttrs(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    public void setTypeface(Typeface tf, int style) {
        if (style > 0) {
            tf = tf == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)tf, (int)style);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.displayLabel) {
                this.postInvalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    public static enum DisplayType {
        NORMAL(0),
        CIRCLE(1),
        ROUND_RECT(2);

        final int type;

        private DisplayType(int type) {
            this.type = type;
        }
    }
}

