/*
 * Decompiled with CFR 0.152.
 */
package com.cbman.roundimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.cbman.roundimageview.R;

public class RoundImageView
extends AppCompatImageView {
    private static final int LEFT_TOP = 0;
    private static final int LEFT_BOTTOM = 1;
    private static final int RIGHT_TOP = 2;
    private static final int RIGHT_BOTTOM = 3;
    private Paint mPaint = null;
    private float borderWidth = 2.0f;
    private int borderColor = Color.parseColor((String)"#8A2BE2");
    private boolean displayBorder;
    private float leftTopRadius;
    private float rightTopRadius;
    private float leftBottomRadius;
    private float rightBottomRadius;
    private DisplayType displayType;
    private boolean displayLable = false;
    private String lableText;
    private int textColor = -1;
    private int textSize = 15;
    private int lableBackground = Color.parseColor((String)"#9FFF0000");
    private int lableGravity = 2;
    private int lableWidth = 15;
    private int startMargin = 20;
    private TextPaint mTextPaint = null;
    private static final DisplayType[] displayTypeArray = new DisplayType[]{DisplayType.NORMAL, DisplayType.CIRCLE, DisplayType.ROUND_RECT};

    public RoundImageView(Context context) {
        this(context, null);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context ctx, AttributeSet attrs) {
        this.setLayerType(2, null);
        this.mPaint = new Paint();
        this.mTextPaint = new TextPaint();
        if (attrs != null) {
            int index;
            TypedArray a = ctx.obtainStyledAttributes(attrs, R.styleable.RoundImageView);
            this.borderWidth = a.getDimension(R.styleable.RoundImageView_borderWidth, this.borderWidth);
            this.borderColor = a.getColor(R.styleable.RoundImageView_borderColor, this.borderColor);
            this.displayBorder = a.getBoolean(R.styleable.RoundImageView_displayBorder, this.displayBorder);
            this.leftTopRadius = a.getDimension(R.styleable.RoundImageView_leftTopRadius, this.leftTopRadius);
            this.rightTopRadius = a.getDimension(R.styleable.RoundImageView_rightTopRadius, this.rightTopRadius);
            this.leftBottomRadius = a.getDimension(R.styleable.RoundImageView_leftBottomRadius, this.leftBottomRadius);
            this.rightBottomRadius = a.getDimension(R.styleable.RoundImageView_rightBottomRadius, this.rightBottomRadius);
            float radius = a.getDimension(R.styleable.RoundImageView_radius, 0.0f);
            if (radius > 0.0f) {
                this.rightTopRadius = this.rightBottomRadius = radius;
                this.leftBottomRadius = this.rightBottomRadius;
                this.leftTopRadius = this.rightBottomRadius;
            }
            this.displayType = (index = a.getInt(R.styleable.RoundImageView_displayType, -1)) >= 0 ? displayTypeArray[index] : DisplayType.NORMAL;
            this.displayLable = a.getBoolean(R.styleable.RoundImageView_displayLable, this.displayLable);
            this.lableText = a.getString(R.styleable.RoundImageView_text);
            this.lableBackground = a.getColor(R.styleable.RoundImageView_lableBackground, this.lableBackground);
            this.textSize = a.getDimensionPixelSize(R.styleable.RoundImageView_textSize, this.textSize);
            this.textColor = a.getColor(R.styleable.RoundImageView_textColor, this.textColor);
            this.lableWidth = a.getDimensionPixelSize(R.styleable.RoundImageView_lableWidth, this.lableWidth);
            this.lableGravity = a.getInt(R.styleable.RoundImageView_lableGravity, this.lableGravity);
            this.startMargin = a.getDimensionPixelSize(R.styleable.RoundImageView_startMargin, this.startMargin);
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, this.displayType == DisplayType.CIRCLE ? widthMeasureSpec : heightMeasureSpec);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() != null) {
            this.resetSize(Math.min(this.getWidth(), this.getHeight()) / 2);
            Bitmap bm = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
            Canvas mCanvas = new Canvas(bm);
            super.onDraw(mCanvas);
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.drawMyContent(mCanvas);
            canvas.drawBitmap(bm, 0.0f, 0.0f, this.mPaint);
            bm.recycle();
        } else {
            super.onDraw(canvas);
        }
    }

    private void resetSize(int size) {
        this.leftTopRadius = Math.min(this.leftTopRadius, (float)size);
        this.rightTopRadius = Math.min(this.rightTopRadius, (float)size);
        this.leftBottomRadius = Math.min(this.leftBottomRadius, (float)size);
        this.rightBottomRadius = Math.min(this.rightBottomRadius, (float)size);
        this.borderWidth = Math.min(this.borderWidth, (float)(size / 2));
        this.lableWidth = Math.min(this.lableWidth, size / 2);
        this.textSize = Math.min(this.textSize, this.lableWidth);
        this.startMargin = Math.min(this.startMargin, (int)((float)(size * 2) - this.getBevelLineLength()));
    }

    private float getBevelLineLength() {
        return (float)Math.sqrt(Math.pow(this.lableWidth, 2.0) * 2.0);
    }

    private void drawMyContent(Canvas mCanvas) {
        if (this.displayType != DisplayType.NORMAL) {
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            Path path = this.createPath();
            path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            mCanvas.drawPath(path, this.mPaint);
            this.mPaint.setXfermode(null);
        }
        if (this.displayBorder) {
            this.drawBorders(mCanvas);
        }
        if (this.displayLable) {
            this.drawLables(mCanvas);
        }
    }

    private void drawLables(Canvas mCanvas) {
        Path path = new Path();
        Path mTextPath = new Path();
        switch (this.lableGravity) {
            case 0: {
                path.moveTo((float)this.startMargin, 0.0f);
                path.rLineTo(this.getBevelLineLength(), 0.0f);
                path.lineTo(0.0f, (float)this.startMargin + this.getBevelLineLength());
                path.rLineTo(0.0f, -this.getBevelLineLength());
                path.close();
                mTextPath.moveTo(0.0f, (float)this.startMargin + this.getBevelLineLength() / 2.0f);
                mTextPath.lineTo((float)this.startMargin + this.getBevelLineLength() / 2.0f, 0.0f);
                break;
            }
            case 1: {
                path.moveTo((float)this.startMargin, (float)this.getHeight());
                path.rLineTo(this.getBevelLineLength(), 0.0f);
                path.lineTo(0.0f, (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength()));
                path.rLineTo(0.0f, this.getBevelLineLength());
                path.close();
                mTextPath.moveTo(0.0f, (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f));
                mTextPath.lineTo((float)this.startMargin + this.getBevelLineLength() / 2.0f, (float)this.getHeight());
                break;
            }
            case 2: {
                path.moveTo((float)(this.getWidth() - this.startMargin), 0.0f);
                path.rLineTo(-this.getBevelLineLength(), 0.0f);
                path.lineTo((float)this.getWidth(), (float)this.startMargin + this.getBevelLineLength());
                path.rLineTo(0.0f, -this.getBevelLineLength());
                path.close();
                mTextPath.moveTo((float)this.getWidth() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f), 0.0f);
                mTextPath.lineTo((float)this.getWidth(), (float)this.startMargin + this.getBevelLineLength() / 2.0f);
                break;
            }
            case 3: {
                path.moveTo((float)(this.getWidth() - this.startMargin), (float)this.getHeight());
                path.rLineTo(-this.getBevelLineLength(), 0.0f);
                path.lineTo((float)this.getWidth(), (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength()));
                path.rLineTo(0.0f, this.getBevelLineLength());
                path.close();
                mTextPath.moveTo((float)this.getWidth() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f), (float)this.getHeight());
                mTextPath.lineTo((float)this.getWidth(), (float)this.getHeight() - ((float)this.startMargin + this.getBevelLineLength() / 2.0f));
            }
        }
        this.mTextPaint.reset();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setColor(this.lableBackground);
        mCanvas.drawPath(path, (Paint)this.mTextPaint);
        this.mTextPaint.setTextSize((float)this.textSize);
        this.mTextPaint.setColor(this.textColor);
        if (null == this.lableText) {
            this.lableText = "";
        }
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        float textWidth = this.mTextPaint.measureText(this.lableText);
        PathMeasure pathMeasure = new PathMeasure(mTextPath, false);
        float pathLength = pathMeasure.getLength();
        if (textWidth > pathLength) {
            float sl = textWidth / (float)this.lableText.length();
            float le = textWidth - pathLength;
            int num = (int)Math.floor(le / sl);
            this.lableText = this.lableText.substring(0, this.lableText.length() - (num + 2)) + "...";
        }
        Paint.FontMetricsInt fm = this.mTextPaint.getFontMetricsInt();
        float v = (fm.bottom - fm.top) / 2 - fm.bottom;
        mCanvas.drawTextOnPath(this.lableText, mTextPath, 0.0f, v, (Paint)this.mTextPaint);
    }

    private void drawBorders(Canvas mCanvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.borderColor);
        this.mPaint.setStrokeWidth(this.borderWidth);
        Path path = this.createPath();
        mCanvas.drawPath(path, this.mPaint);
    }

    private Path createPath() {
        Path mPath = new Path();
        float size = this.borderWidth / 2.0f;
        switch (this.displayType) {
            case CIRCLE: {
                mPath.addCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - size, Path.Direction.CW);
                break;
            }
            case ROUND_RECT: {
                RectF rectF = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rectF.inset(size, size);
                mPath.addRoundRect(rectF, new float[]{this.leftTopRadius, this.leftTopRadius, this.rightTopRadius, this.rightTopRadius, this.rightBottomRadius, this.rightBottomRadius, this.leftBottomRadius, this.leftBottomRadius}, Path.Direction.CW);
                break;
            }
            default: {
                RectF rect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rect.inset(size, size);
                mPath.addRect(rect, Path.Direction.CW);
            }
        }
        return mPath;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        this.postInvalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.postInvalidate();
    }

    public boolean isDisplayBorder() {
        return this.displayBorder;
    }

    public void setDisplayBorder(boolean displayBorder) {
        this.displayBorder = displayBorder;
        this.postInvalidate();
    }

    public float getLeftTopRadius() {
        return this.leftTopRadius;
    }

    public void setLeftTopRadius(float leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
        this.postInvalidate();
    }

    public float getRightTopRadius() {
        return this.rightTopRadius;
    }

    public void setRightTopRadius(float rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
        this.postInvalidate();
    }

    public float getLeftBottomRadius() {
        return this.leftBottomRadius;
    }

    public void setLeftBottomRadius(float leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
        this.postInvalidate();
    }

    public float getRightBottomRadius() {
        return this.rightBottomRadius;
    }

    public void setRightBottomRadius(float rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
        this.postInvalidate();
    }

    public void setRadius(float leftTopRadius, float rightTopRadius, float leftBottomRadius, float rightBottomRadius) {
        this.leftTopRadius = leftTopRadius;
        this.rightTopRadius = rightTopRadius;
        this.leftBottomRadius = leftBottomRadius;
        this.rightBottomRadius = rightBottomRadius;
        this.postInvalidate();
    }

    public void setRadius(float radius) {
        this.setRadius(radius, radius, radius, radius);
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        this.postInvalidate();
    }

    public void setDisplayLable(boolean displayLable) {
        this.displayLable = displayLable;
        this.postInvalidate();
    }

    public void setLableText(String lableText) {
        this.lableText = lableText;
        this.postInvalidate();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.postInvalidate();
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
        this.postInvalidate();
    }

    public void setLableBackground(int lableBackground) {
        this.lableBackground = lableBackground;
        this.postInvalidate();
    }

    public void setLableGravity(int lableGravity) {
        this.lableGravity = lableGravity;
        this.postInvalidate();
    }

    public void setLableWidth(int lableWidth) {
        this.lableWidth = lableWidth;
        this.postInvalidate();
    }

    public void setStartMargin(int startMargin) {
        this.startMargin = startMargin;
        this.postInvalidate();
    }

    public boolean isDisplayLable() {
        return this.displayLable;
    }

    public String getLableText() {
        return this.lableText == null ? "" : this.lableText;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public int getLableBackground() {
        return this.lableBackground;
    }

    public int getLableGravity() {
        return this.lableGravity;
    }

    public int getLableWidth() {
        return this.lableWidth;
    }

    public int getStartMargin() {
        return this.startMargin;
    }

    public static enum DisplayType {
        NORMAL(0),
        CIRCLE(1),
        ROUND_RECT(2);

        final int type;

        private DisplayType(int type) {
            this.type = type;
        }
    }
}

