/*
 * Decompiled with CFR 0.152.
 */
package com.cbman.roundimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.cbman.roundimageview.R;

public class RoundImageView
extends AppCompatImageView {
    private Paint mPaint;
    private float borderWidth = 2.0f;
    private int borderColor = Color.parseColor((String)"#8A2BE2");
    private boolean displayBorder;
    private float leftTopRadius;
    private float rightTopRadius;
    private float leftBottomRadius;
    private float rightBottomRadius;
    private DisplayType displayType;
    private static final DisplayType[] displayTypeArray = new DisplayType[]{DisplayType.NORMAL, DisplayType.CIRCLE, DisplayType.ROUND_RECT};

    public RoundImageView(Context context) {
        this(context, null);
    }

    public RoundImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context ctx, AttributeSet attrs) {
        this.setLayerType(2, null);
        this.mPaint = new Paint();
        if (attrs != null) {
            int index;
            TypedArray typedArray = ctx.obtainStyledAttributes(attrs, R.styleable.RoundImageView);
            this.borderWidth = typedArray.getDimension(R.styleable.RoundImageView_borderWidth, this.borderWidth);
            this.borderColor = typedArray.getColor(R.styleable.RoundImageView_borderColor, this.borderColor);
            this.displayBorder = typedArray.getBoolean(R.styleable.RoundImageView_displayBorder, this.displayBorder);
            this.leftTopRadius = typedArray.getDimension(R.styleable.RoundImageView_leftTopRadius, this.leftTopRadius);
            this.rightTopRadius = typedArray.getDimension(R.styleable.RoundImageView_rightTopRadius, this.rightTopRadius);
            this.leftBottomRadius = typedArray.getDimension(R.styleable.RoundImageView_leftBottomRadius, this.leftBottomRadius);
            this.rightBottomRadius = typedArray.getDimension(R.styleable.RoundImageView_rightBottomRadius, this.rightBottomRadius);
            float radius = typedArray.getDimension(R.styleable.RoundImageView_radius, 0.0f);
            if (radius > 0.0f) {
                this.rightTopRadius = this.rightBottomRadius = radius;
                this.leftBottomRadius = this.rightBottomRadius;
                this.leftTopRadius = this.rightBottomRadius;
            }
            this.displayType = (index = typedArray.getInt(R.styleable.RoundImageView_displayType, -1)) >= 0 ? displayTypeArray[index] : DisplayType.NORMAL;
            typedArray.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, this.displayType == DisplayType.CIRCLE ? widthMeasureSpec : heightMeasureSpec);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() != null) {
            this.resetSize(Math.min(this.getWidth(), this.getHeight()) / 2);
            Bitmap bm = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas mCanvas = new Canvas(bm);
            super.onDraw(mCanvas);
            this.mPaint.reset();
            this.mPaint.setAntiAlias(true);
            this.drawMyContent(mCanvas);
            canvas.drawBitmap(bm, 0.0f, 0.0f, this.mPaint);
            bm.recycle();
        } else {
            super.onDraw(canvas);
        }
    }

    private void resetSize(int size) {
        this.leftTopRadius = Math.min(this.leftTopRadius, (float)size);
        this.rightTopRadius = Math.min(this.rightTopRadius, (float)size);
        this.leftBottomRadius = Math.min(this.leftBottomRadius, (float)size);
        this.rightBottomRadius = Math.min(this.rightBottomRadius, (float)size);
        this.borderWidth = Math.min(this.borderWidth, (float)(size / 2));
    }

    private void drawMyContent(Canvas mCanvas) {
        if (this.displayType != DisplayType.NORMAL) {
            this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
            Path path = this.createPath();
            path.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            mCanvas.drawPath(path, this.mPaint);
            this.mPaint.setXfermode(null);
        }
        if (this.displayBorder) {
            this.drawBorders(mCanvas);
        }
    }

    private void drawBorders(Canvas mCanvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(this.borderColor);
        this.mPaint.setStrokeWidth(this.borderWidth);
        Path path = this.createPath();
        mCanvas.drawPath(path, this.mPaint);
    }

    private Path createPath() {
        Path mPath = new Path();
        float size = this.borderWidth / 2.0f;
        switch (this.displayType) {
            case CIRCLE: {
                mPath.addCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - size, Path.Direction.CW);
                break;
            }
            case ROUND_RECT: {
                RectF rectF = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rectF.inset(size, size);
                mPath.addRoundRect(rectF, new float[]{this.leftTopRadius, this.leftTopRadius, this.rightTopRadius, this.rightTopRadius, this.rightBottomRadius, this.rightBottomRadius, this.leftBottomRadius, this.leftBottomRadius}, Path.Direction.CW);
                break;
            }
            default: {
                RectF rect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
                rect.inset(size, size);
                mPath.addRect(rect, Path.Direction.CW);
            }
        }
        return mPath;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        this.postInvalidate();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.postInvalidate();
    }

    public boolean isDisplayBorder() {
        return this.displayBorder;
    }

    public void setDisplayBorder(boolean displayBorder) {
        this.displayBorder = displayBorder;
        this.postInvalidate();
    }

    public float getLeftTopRadius() {
        return this.leftTopRadius;
    }

    public void setLeftTopRadius(float leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
        this.postInvalidate();
    }

    public float getRightTopRadius() {
        return this.rightTopRadius;
    }

    public void setRightTopRadius(float rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
        this.postInvalidate();
    }

    public float getLeftBottomRadius() {
        return this.leftBottomRadius;
    }

    public void setLeftBottomRadius(float leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
        this.postInvalidate();
    }

    public float getRightBottomRadius() {
        return this.rightBottomRadius;
    }

    public void setRightBottomRadius(float rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
        this.postInvalidate();
    }

    public void setRadius(float leftTopRadius, float rightTopRadius, float leftBottomRadius, float rightBottomRadius) {
        this.leftTopRadius = leftTopRadius;
        this.rightTopRadius = rightTopRadius;
        this.leftBottomRadius = leftBottomRadius;
        this.rightBottomRadius = rightBottomRadius;
        this.postInvalidate();
    }

    public void setRadius(float radius) {
        this.setRadius(radius, radius, radius, radius);
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        this.postInvalidate();
    }

    public static enum DisplayType {
        NORMAL(0),
        CIRCLE(1),
        ROUND_RECT(2);

        final int type;

        private DisplayType(int type) {
            this.type = type;
        }
    }
}

