/*
 * Decompiled with CFR 0.152.
 */
package com.cblong.http;

import android.text.TextUtils;
import com.cblong.http.HexHttpManager;
import com.cblong.http.callback.HexHttpCallback;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class HexOkHexHttpManager
extends HexHttpManager {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType XML = MediaType.parse((String)"application/xml; charset=utf-8");
    public static final MediaType MEDIA_TYPE_MARKDOWN = MediaType.parse((String)"text/x-markdown; charset=utf-8");
    private static final boolean isDebug = false;
    private static HexOkHexHttpManager hexHttp;
    private OkHttpClient.Builder builder = new OkHttpClient.Builder();
    private long connectTime = 60L;
    private long writeTime = 30L;
    private long readTime = 60L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HexOkHexHttpManager getInstance() {
        if (hexHttp != null) return hexHttp;
        Class<HexOkHexHttpManager> clazz = HexOkHexHttpManager.class;
        synchronized (HexOkHexHttpManager.class) {
            if (hexHttp != null) return hexHttp;
            hexHttp = new HexOkHexHttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hexHttp;
        }
    }

    public HexOkHexHttpManager setConnectTimeout(long timeout) {
        this.connectTime = timeout;
        return hexHttp;
    }

    public HexOkHexHttpManager setWriteTimeout(long timeout) {
        this.writeTime = timeout;
        return hexHttp;
    }

    public HexOkHexHttpManager setReadTimeout(long timeout) {
        this.readTime = timeout;
        return hexHttp;
    }

    private HexOkHexHttpManager() {
    }

    private OkHttpClient getClient() {
        return this.builder.connectTimeout(this.connectTime, TimeUnit.SECONDS).writeTimeout(this.writeTime, TimeUnit.SECONDS).readTimeout(this.readTime, TimeUnit.SECONDS).build();
    }

    private void init() {
    }

    @Override
    public void Request(int method, String url, Map<String, String> params, final HexHttpCallback callback) {
        Request request;
        if (url == null || url.equals("")) {
            return;
        }
        if (params == null) {
            return;
        }
        this.init();
        OkHttpClient client = this.getClient();
        if (method == 0) {
            String strUrl = this.restructureURL(0, url, params);
            request = new Request.Builder().url(strUrl).build();
        } else {
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            FormBody requestBody = builder.build();
            request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        }
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("key_call", call);
                errorMap.put("key_exception", e);
                callback.onFailure(errorMap);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    String result = response.body().string();
                    callback.onSuccess(result);
                }
            }
        });
    }

    @Override
    public String getRequest(String url, Map<String, String> params) {
        if (url == null || url.equals("")) {
            return null;
        }
        this.init();
        String strUrl = this.restructureURL(0, url, params);
        OkHttpClient client = this.getClient();
        Request request = new Request.Builder().url(strUrl).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String postRequest(String url, JSONObject jsonObject) {
        if (url == null || url.equals("")) {
            return null;
        }
        this.init();
        OkHttpClient client = this.getClient();
        String json = jsonObject.toString();
        if (json != null) {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).build();
            try {
                Response response = client.newCall(request).execute();
                return response.body().string();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String postXmlRequest(String url, String xmlString) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)xmlString)) {
            return null;
        }
        this.init();
        OkHttpClient client = this.getClient();
        RequestBody body = RequestBody.create((MediaType)XML, (String)xmlString);
        Request request = new Request.Builder().url(url).post(body).build();
        try {
            Response response = client.newCall(request).execute();
            try {
                return response.body().string();
            }
            catch (IOException ex) {
                ex.getMessage();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String postRequest(String url, Map<String, String> params) {
        if (url == null || url.equals("")) {
            return null;
        }
        this.init();
        OkHttpClient client = this.getClient();
        String json = this.getJson(params);
        if (json != null) {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
            Request request = new Request.Builder().url(url).post(body).build();
            try {
                Response response = client.newCall(request).execute();
                return response.body().string();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String postRequest(String url, RequestBody params) {
        if (url == null || url.equals("")) {
            return null;
        }
        this.init();
        OkHttpClient client = this.getClient();
        Request request = new Request.Builder().url(url).post(params).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void postRequest(String url, RequestBody params, final HexHttpCallback callback) {
        if (url == null || url.equals("")) {
            return;
        }
        this.init();
        OkHttpClient client = this.getClient();
        Request request = new Request.Builder().url(url).post(params).build();
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("key_call", call);
                errorMap.put("key_exception", e);
                callback.onFailure(errorMap);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    String result = response.body().string();
                    callback.onSuccess(result);
                }
            }
        });
    }

    private String getJson(Map<String, String> params) {
        JSONObject jsonObject = new JSONObject();
        boolean error = false;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || value == null) continue;
            try {
                jsonObject.put(key, (Object)value);
            }
            catch (JSONException e) {
                e.printStackTrace();
                error = true;
            }
            if (!error) continue;
            break;
        }
        return jsonObject.toString();
    }

    @Override
    public String upload(String urlStr, String uploadKey, File file, MediaType mediaType) {
        Request request = HexOkHexHttpManager.getFileUploadRequest(urlStr, uploadKey, file, mediaType);
        String result = null;
        try {
            Response response = this.getClient().newCall(request).execute();
            result = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String upload(String urlStr, Map<String, String> params, String uploadKey, File file, MediaType mediaType) {
        Request request = HexOkHexHttpManager.getFileUploadRequest(urlStr, params, uploadKey, file, mediaType);
        String result = null;
        try {
            Response response = this.getClient().newCall(request).execute();
            result = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Response initRequest(String url, String lastModify) throws IOException {
        Request request = new Request.Builder().url(url).header("Range", "bytes=0-").header("If-Range", lastModify).build();
        return this.builder.build().newCall(request).execute();
    }

    public void downloadEnqueue(String url, long start, long end, final HexHttpCallback callback) {
        Request request = new Request.Builder().url(url).header("Range", "bytes=" + start + "-" + end).build();
        Call call = this.builder.build().newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("key_call", call);
                errorMap.put("key_exception", e);
                callback.onFailure(errorMap);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(response.body().string());
                }
            }
        });
    }

    public Response downloadEnqueue(String url) {
        Request request = new Request.Builder().url(url).build();
        try {
            return this.getClient().newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean downloadAndSave(String url, String path, String fileName) {
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = this.getClient().newCall(request).execute();
            if (response != null) {
                File file = this.createFile(path, fileName);
                if (file == null) {
                    return false;
                }
                InputStream is = response.body().byteStream();
                BufferedInputStream input = new BufferedInputStream(is);
                try {
                    FileOutputStream output = new FileOutputStream(file);
                    byte[] data = new byte[1024];
                    try {
                        int count;
                        while ((count = input.read(data)) != -1) {
                            ((OutputStream)output).write(data, 0, count);
                        }
                        output.flush();
                        ((OutputStream)output).close();
                        input.close();
                        return true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Response initRequest(String url) throws IOException {
        Request request = new Request.Builder().url(url).header("Range", "bytes=0-").build();
        return this.builder.build().newCall(request).execute();
    }

    @Override
    public void download(String url) {
    }

    private static Request getFileUploadRequest(String url, String name, File file, MediaType mediaType) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        if (file.exists() && name != null && !"".equals(name)) {
            builder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
        }
        MultipartBody requestBody = builder.build();
        return new Request.Builder().url(url).post((RequestBody)requestBody).build();
    }

    private static Request getFileUploadRequest(String url, Map<String, String> params, String name, File file, MediaType mediaType) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        if (file.exists() && name != null && !"".equals(name)) {
            builder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.addFormDataPart(key, value);
        }
        MultipartBody requestBody = builder.build();
        return new Request.Builder().url(url).post((RequestBody)requestBody).build();
    }

    public static Request getPicUploadRequest(String url, String name, File file) {
        MediaType PNG_TYPE = MediaType.parse((String)"image/png");
        MediaType JPG_TYPE = MediaType.parse((String)"image/jpg");
        MediaType mediaType = PNG_TYPE;
        MultipartBody.Builder builder = new MultipartBody.Builder();
        if (file.exists() && name != null && !"".equals(name)) {
            if (".jpg".endsWith(file.getName())) {
                mediaType = JPG_TYPE;
            }
            if (".png".endsWith(file.getName())) {
                mediaType = PNG_TYPE;
            }
            builder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
        }
        MultipartBody requestBody = builder.build();
        return new Request.Builder().url(url).post((RequestBody)requestBody).build();
    }

    public static Request getPicUploadRequest(String url, String name, File file, Map<String, String> params) {
        MediaType PNG_TYPE = MediaType.parse((String)"image/png");
        MediaType JPG_TYPE = MediaType.parse((String)"image/jpg");
        MediaType mediaType = PNG_TYPE;
        MultipartBody.Builder builder = new MultipartBody.Builder();
        if (file.exists() && name != null && !"".equals(name)) {
            if (".jpg".endsWith(file.getName())) {
                mediaType = JPG_TYPE;
            }
            if (".png".endsWith(file.getName())) {
                mediaType = PNG_TYPE;
            }
            builder.addFormDataPart(name, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.addFormDataPart(key, value);
        }
        MultipartBody requestBody = builder.build();
        return new Request.Builder().url(url).post((RequestBody)requestBody).build();
    }

    private synchronized File createFile(String path, String name) {
        File file;
        if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        File parentFile = new File(path);
        if (!parentFile.exists()) {
            parentFile.mkdir();
        }
        if (!(file = new File(parentFile, name)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }
}

