/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.util.Log;
import com.caverock.androidsvg.CSSParseException;
import com.caverock.androidsvg.IntegerParser;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class CSSParser {
    private static final String TAG = "CSSParser";
    static final String CSS_MIME_TYPE = "text/css";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final int SPECIFICITY_ID_ATTRIBUTE = 1000000;
    private static final int SPECIFICITY_ATTRIBUTE_OR_PSEUDOCLASS = 1000;
    private static final int SPECIFICITY_ELEMENT_OR_PSEUDOELEMENT = 1;
    private MediaType deviceMediaType = null;
    private Source source = null;
    private boolean inMediaRule = false;

    CSSParser() {
        this(MediaType.screen, Source.Document);
    }

    CSSParser(Source source) {
        this(MediaType.screen, source);
    }

    CSSParser(MediaType rendererMediaType, Source source) {
        this.deviceMediaType = rendererMediaType;
        this.source = source;
    }

    Ruleset parse(String sheet) {
        CSSTextScanner scan = new CSSTextScanner(sheet);
        scan.skipWhitespace();
        return this.parseRuleset(scan);
    }

    static boolean mediaMatches(String mediaListStr, MediaType rendererMediaType) {
        CSSTextScanner scan = new CSSTextScanner(mediaListStr);
        scan.skipWhitespace();
        List<MediaType> mediaList = CSSParser.parseMediaList(scan);
        return CSSParser.mediaMatches(mediaList, rendererMediaType);
    }

    private static void warn(String format, Object ... args) {
        Log.w((String)TAG, (String)String.format(format, args));
    }

    private static boolean mediaMatches(List<MediaType> mediaList, MediaType rendererMediaType) {
        for (MediaType type : mediaList) {
            if (type != MediaType.all && type != rendererMediaType) continue;
            return true;
        }
        return false;
    }

    private static List<MediaType> parseMediaList(CSSTextScanner scan) {
        String type;
        ArrayList<MediaType> typeList = new ArrayList<MediaType>();
        while (!scan.empty() && (type = scan.nextWord()) != null) {
            try {
                typeList.add(MediaType.valueOf(type));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (scan.skipCommaWhitespace()) continue;
            break;
        }
        return typeList;
    }

    private void parseAtRule(Ruleset ruleset, CSSTextScanner scan) throws CSSParseException {
        String atKeyword = scan.nextIdentifier();
        scan.skipWhitespace();
        if (atKeyword == null) {
            throw new CSSParseException("Invalid '@' rule");
        }
        if (!this.inMediaRule && atKeyword.equals("media")) {
            List<MediaType> mediaList = CSSParser.parseMediaList(scan);
            if (!scan.consume('{')) {
                throw new CSSParseException("Invalid @media rule: missing rule set");
            }
            scan.skipWhitespace();
            if (CSSParser.mediaMatches(mediaList, this.deviceMediaType)) {
                this.inMediaRule = true;
                ruleset.addAll(this.parseRuleset(scan));
                this.inMediaRule = false;
            } else {
                this.parseRuleset(scan);
            }
            if (!scan.empty() && !scan.consume('}')) {
                throw new CSSParseException("Invalid @media rule: expected '}' at end of rule set");
            }
        } else if (!this.inMediaRule && atKeyword.equals("import")) {
            String file = scan.nextURL();
            if (file == null) {
                file = scan.nextCSSString();
            }
            if (file == null) {
                throw new CSSParseException("Invalid @import rule: expected string or url()");
            }
            scan.skipWhitespace();
            List<MediaType> mediaList = CSSParser.parseMediaList(scan);
            if (!scan.empty() && !scan.consume(';')) {
                throw new CSSParseException("Invalid @media rule: expected '}' at end of rule set");
            }
            if (SVG.getFileResolver() != null && CSSParser.mediaMatches(mediaList, this.deviceMediaType)) {
                String css = SVG.getFileResolver().resolveCSSStyleSheet(file);
                if (css == null) {
                    return;
                }
                ruleset.addAll(this.parse(css));
            }
        } else {
            CSSParser.warn("Ignoring @%s rule", atKeyword);
            this.skipAtRule(scan);
        }
        scan.skipWhitespace();
    }

    private void skipAtRule(CSSTextScanner scan) {
        int depth = 0;
        while (!scan.empty()) {
            int ch = scan.nextChar();
            if (ch == 59 && depth == 0) {
                return;
            }
            if (ch == 123) {
                ++depth;
                continue;
            }
            if (ch != 125 || depth <= 0 || --depth != 0) continue;
            return;
        }
    }

    private Ruleset parseRuleset(CSSTextScanner scan) {
        Ruleset ruleset = new Ruleset();
        try {
            while (!scan.empty()) {
                if (scan.consume("<!--") || scan.consume("-->")) continue;
                if (scan.consume('@')) {
                    this.parseAtRule(ruleset, scan);
                    continue;
                }
                if (this.parseRule(ruleset, scan)) {
                    continue;
                }
                break;
            }
        }
        catch (CSSParseException e) {
            Log.e((String)TAG, (String)("CSS parser terminated early due to error: " + e.getMessage()));
        }
        return ruleset;
    }

    private boolean parseRule(Ruleset ruleset, CSSTextScanner scan) throws CSSParseException {
        List selectors = scan.nextSelectorGroup();
        if (selectors != null && !selectors.isEmpty()) {
            if (!scan.consume('{')) {
                throw new CSSParseException("Malformed rule block: expected '{'");
            }
            scan.skipWhitespace();
            SVG.Style ruleStyle = this.parseDeclarations(scan);
            scan.skipWhitespace();
            for (Selector selector : selectors) {
                ruleset.add(new Rule(selector, ruleStyle, this.source));
            }
            return true;
        }
        return false;
    }

    private SVG.Style parseDeclarations(CSSTextScanner scan) throws CSSParseException {
        SVG.Style ruleStyle = new SVG.Style();
        do {
            String propertyName = scan.nextIdentifier();
            scan.skipWhitespace();
            if (!scan.consume(':')) {
                throw new CSSParseException("Expected ':'");
            }
            scan.skipWhitespace();
            String propertyValue = scan.nextPropertyValue();
            if (propertyValue == null) {
                throw new CSSParseException("Expected property value");
            }
            scan.skipWhitespace();
            if (scan.consume('!')) {
                scan.skipWhitespace();
                if (!scan.consume("important")) {
                    throw new CSSParseException("Malformed rule set: found unexpected '!'");
                }
                scan.skipWhitespace();
            }
            scan.consume(';');
            SVGParser.processStyleProperty(ruleStyle, propertyName, propertyValue);
            scan.skipWhitespace();
        } while (!scan.empty() && !scan.consume('}'));
        return ruleStyle;
    }

    public static List<String> parseClassAttribute(String val) {
        CSSTextScanner scan = new CSSTextScanner(val);
        ArrayList<String> classNameList = null;
        while (!scan.empty()) {
            String className = scan.nextToken();
            if (className == null) continue;
            if (classNameList == null) {
                classNameList = new ArrayList<String>();
            }
            classNameList.add(className);
            scan.skipWhitespace();
        }
        return classNameList;
    }

    static boolean ruleMatch(RuleMatchContext ruleMatchContext, Selector selector, SVG.SvgElementBase obj) {
        ArrayList<SVG.SvgContainer> ancestors = new ArrayList<SVG.SvgContainer>();
        SVG.SvgContainer parent = obj.parent;
        while (parent != null) {
            ancestors.add(0, parent);
            parent = ((SVG.SvgObject)((Object)parent)).parent;
        }
        int ancestorsPos = ancestors.size() - 1;
        if (selector.size() == 1) {
            return CSSParser.selectorMatch(ruleMatchContext, selector.get(0), ancestors, ancestorsPos, obj);
        }
        return CSSParser.ruleMatch(ruleMatchContext, selector, selector.size() - 1, ancestors, ancestorsPos, obj);
    }

    private static boolean ruleMatch(RuleMatchContext ruleMatchContext, Selector selector, int selPartPos, List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        SimpleSelector sel = selector.get(selPartPos);
        if (!CSSParser.selectorMatch(ruleMatchContext, sel, ancestors, ancestorsPos, obj)) {
            return false;
        }
        if (sel.combinator == Combinator.DESCENDANT) {
            if (selPartPos == 0) {
                return true;
            }
            while (ancestorsPos >= 0) {
                if (CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, selPartPos - 1, ancestors, ancestorsPos)) {
                    return true;
                }
                --ancestorsPos;
            }
            return false;
        }
        if (sel.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, selPartPos - 1, ancestors, ancestorsPos);
        }
        int childPos = CSSParser.getChildPosition(ancestors, ancestorsPos, obj);
        if (childPos <= 0) {
            return false;
        }
        SVG.SvgElementBase prevSibling = (SVG.SvgElementBase)obj.parent.getChildren().get(childPos - 1);
        return CSSParser.ruleMatch(ruleMatchContext, selector, selPartPos - 1, ancestors, ancestorsPos, prevSibling);
    }

    private static boolean ruleMatchOnAncestors(RuleMatchContext ruleMatchContext, Selector selector, int selPartPos, List<SVG.SvgContainer> ancestors, int ancestorsPos) {
        SVG.SvgElementBase obj;
        SimpleSelector sel = selector.get(selPartPos);
        if (!CSSParser.selectorMatch(ruleMatchContext, sel, ancestors, ancestorsPos, obj = (SVG.SvgElementBase)((Object)ancestors.get(ancestorsPos)))) {
            return false;
        }
        if (sel.combinator == Combinator.DESCENDANT) {
            if (selPartPos == 0) {
                return true;
            }
            while (ancestorsPos > 0) {
                if (!CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, selPartPos - 1, ancestors, --ancestorsPos)) continue;
                return true;
            }
            return false;
        }
        if (sel.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(ruleMatchContext, selector, selPartPos - 1, ancestors, ancestorsPos - 1);
        }
        int childPos = CSSParser.getChildPosition(ancestors, ancestorsPos, obj);
        if (childPos <= 0) {
            return false;
        }
        SVG.SvgElementBase prevSibling = (SVG.SvgElementBase)obj.parent.getChildren().get(childPos - 1);
        return CSSParser.ruleMatch(ruleMatchContext, selector, selPartPos - 1, ancestors, ancestorsPos, prevSibling);
    }

    private static int getChildPosition(List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        if (ancestorsPos < 0) {
            return 0;
        }
        if (ancestors.get(ancestorsPos) != obj.parent) {
            return -1;
        }
        int childPos = 0;
        for (SVG.SvgObject child : obj.parent.getChildren()) {
            if (child == obj) {
                return childPos;
            }
            ++childPos;
        }
        return -1;
    }

    private static boolean selectorMatch(RuleMatchContext ruleMatchContext, SimpleSelector sel, List<SVG.SvgContainer> ancestors, int ancestorsPos, SVG.SvgElementBase obj) {
        if (sel.tag != null && !sel.tag.equals(obj.getNodeName().toLowerCase(Locale.US))) {
            return false;
        }
        if (sel.attribs != null) {
            block8: for (Attrib attr : sel.attribs) {
                switch (attr.name) {
                    case "id": {
                        if (attr.value.equals(obj.id)) continue block8;
                        return false;
                    }
                    case "class": {
                        if (obj.classNames == null) {
                            return false;
                        }
                        if (obj.classNames.contains(attr.value)) continue block8;
                        return false;
                    }
                }
                return false;
            }
        }
        if (sel.pseudos != null) {
            for (PseudoClass pseudo : sel.pseudos) {
                if (pseudo.matches(ruleMatchContext, obj)) continue;
                return false;
            }
        }
        return true;
    }

    private static class PseudoClassNotSupported
    implements PseudoClass {
        private String clazz;

        PseudoClassNotSupported(String clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            return false;
        }

        public String toString() {
            return this.clazz;
        }
    }

    private static class PseudoClassTarget
    implements PseudoClass {
        private PseudoClassTarget() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            if (ruleMatchContext != null) {
                return obj == ruleMatchContext.targetElement;
            }
            return false;
        }

        public String toString() {
            return "target";
        }
    }

    private static class PseudoClassNot
    implements PseudoClass {
        private List<Selector> selectorGroup;

        PseudoClassNot(List<Selector> selectorGroup) {
            this.selectorGroup = selectorGroup;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            for (Selector selector : this.selectorGroup) {
                if (!CSSParser.ruleMatch(ruleMatchContext, selector, obj)) continue;
                return false;
            }
            return true;
        }

        int getSpecificity() {
            int highest = Integer.MIN_VALUE;
            for (Selector selector : this.selectorGroup) {
                if (selector.specificity <= highest) continue;
                highest = selector.specificity;
            }
            return highest;
        }

        public String toString() {
            return "not(" + this.selectorGroup + ")";
        }
    }

    private static class PseudoClassEmpty
    implements PseudoClass {
        private PseudoClassEmpty() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            if (obj instanceof SVG.SvgContainer) {
                return ((SVG.SvgContainer)((Object)obj)).getChildren().size() == 0;
            }
            return true;
        }

        public String toString() {
            return "empty";
        }
    }

    private static class PseudoClassRoot
    implements PseudoClass {
        private PseudoClassRoot() {
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            return obj.parent == null;
        }

        public String toString() {
            return "root";
        }
    }

    private static class PseudoClassOnlyChild
    implements PseudoClass {
        private boolean isOfType;
        private String nodeName;

        public PseudoClassOnlyChild(boolean isOfType, String nodeName) {
            this.isOfType = isOfType;
            this.nodeName = nodeName;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            String nodeNameToCheck = this.isOfType && this.nodeName == null ? obj.getNodeName() : this.nodeName;
            int childCount = 1;
            if (obj.parent != null) {
                childCount = 0;
                for (SVG.SvgObject node : obj.parent.getChildren()) {
                    SVG.SvgElementBase child = (SVG.SvgElementBase)node;
                    if (nodeNameToCheck != null && !child.getNodeName().equals(nodeNameToCheck)) continue;
                    ++childCount;
                }
            }
            return childCount == 1;
        }

        public String toString() {
            return this.isOfType ? String.format("only-of-type <%s>", this.nodeName) : String.format("only-child", new Object[0]);
        }
    }

    private static class PseudoClassAnPlusB
    implements PseudoClass {
        private int a;
        private int b;
        private boolean isFromStart;
        private boolean isOfType;
        private String nodeName;

        PseudoClassAnPlusB(int a, int b, boolean isFromStart, boolean isOfType, String nodeName) {
            this.a = a;
            this.b = b;
            this.isFromStart = isFromStart;
            this.isOfType = isOfType;
            this.nodeName = nodeName;
        }

        @Override
        public boolean matches(RuleMatchContext ruleMatchContext, SVG.SvgElementBase obj) {
            String nodeNameToCheck = this.isOfType && this.nodeName == null ? obj.getNodeName() : this.nodeName;
            int childPos = 0;
            int childCount = 1;
            if (obj.parent != null) {
                childCount = 0;
                for (SVG.SvgObject node : obj.parent.getChildren()) {
                    SVG.SvgElementBase child = (SVG.SvgElementBase)node;
                    if (child == obj) {
                        childPos = childCount;
                    }
                    if (nodeNameToCheck != null && !child.getNodeName().equals(nodeNameToCheck)) continue;
                    ++childCount;
                }
            }
            int n = childPos = this.isFromStart ? childPos + 1 : childCount - childPos;
            if (this.a == 0) {
                return childPos == this.b;
            }
            return (childPos - this.b) % this.a == 0 && (Integer.signum(childPos - this.b) == 0 || Integer.signum(childPos - this.b) == Integer.signum(this.a));
        }

        public String toString() {
            String last = this.isFromStart ? "" : "last-";
            return this.isOfType ? String.format("nth-%schild(%dn%+d of type <%s>)", last, this.a, this.b, this.nodeName) : String.format("nth-%schild(%dn%+d)", last, this.a, this.b);
        }
    }

    private static interface PseudoClass {
        public boolean matches(RuleMatchContext var1, SVG.SvgElementBase var2);
    }

    static class RuleMatchContext {
        SVG.SvgElementBase targetElement;

        RuleMatchContext() {
        }

        public String toString() {
            if (this.targetElement != null) {
                return String.format("<%s id=\"%s\">", this.targetElement.getNodeName(), this.targetElement.id);
            }
            return "";
        }
    }

    private static class CSSTextScanner
    extends SVGParser.TextScanner {
        CSSTextScanner(String input) {
            super(input.replaceAll("(?s)/\\*.*?\\*/", ""));
        }

        String nextIdentifier() {
            int end = this.scanForIdentifier();
            if (end == this.position) {
                return null;
            }
            String result = this.input.substring(this.position, end);
            this.position = end;
            return result;
        }

        private int scanForIdentifier() {
            if (this.empty()) {
                return this.position;
            }
            int start = this.position;
            int lastValidPos = this.position;
            int ch = this.input.charAt(this.position);
            if (ch == 45) {
                ch = this.advanceChar();
            }
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95) {
                ch = this.advanceChar();
                while (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch == 45 || ch == 95) {
                    ch = this.advanceChar();
                }
                lastValidPos = this.position;
            }
            this.position = start;
            return lastValidPos;
        }

        private List<Selector> nextSelectorGroup() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            ArrayList<Selector> selectorGroup = new ArrayList<Selector>(1);
            Selector selector = new Selector();
            while (!this.empty() && this.nextSimpleSelector(selector)) {
                if (!this.skipCommaWhitespace()) continue;
                selectorGroup.add(selector);
                selector = new Selector();
            }
            if (!selector.isEmpty()) {
                selectorGroup.add(selector);
            }
            return selectorGroup;
        }

        boolean nextSimpleSelector(Selector selector) throws CSSParseException {
            if (this.empty()) {
                return false;
            }
            int start = this.position;
            Combinator combinator = null;
            SimpleSelector selectorPart = null;
            if (!selector.isEmpty()) {
                if (this.consume('>')) {
                    combinator = Combinator.CHILD;
                    this.skipWhitespace();
                } else if (this.consume('+')) {
                    combinator = Combinator.FOLLOWS;
                    this.skipWhitespace();
                }
            }
            if (this.consume('*')) {
                selectorPart = new SimpleSelector(combinator, null);
            } else {
                String tag = this.nextIdentifier();
                if (tag != null) {
                    selectorPart = new SimpleSelector(combinator, tag);
                    selector.addedElement();
                }
            }
            while (!this.empty()) {
                String value;
                if (this.consume('.')) {
                    if (selectorPart == null) {
                        selectorPart = new SimpleSelector(combinator, null);
                    }
                    if ((value = this.nextIdentifier()) == null) {
                        throw new CSSParseException("Invalid \".class\" simpleSelectors");
                    }
                    selectorPart.addAttrib(CSSParser.CLASS, AttribOp.EQUALS, value);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (this.consume('#')) {
                    if (selectorPart == null) {
                        selectorPart = new SimpleSelector(combinator, null);
                    }
                    if ((value = this.nextIdentifier()) == null) {
                        throw new CSSParseException("Invalid \"#id\" simpleSelectors");
                    }
                    selectorPart.addAttrib(CSSParser.ID, AttribOp.EQUALS, value);
                    selector.addedIdAttribute();
                    continue;
                }
                if (this.consume('[')) {
                    if (selectorPart == null) {
                        selectorPart = new SimpleSelector(combinator, null);
                    }
                    this.skipWhitespace();
                    String attrName = this.nextIdentifier();
                    String attrValue = null;
                    if (attrName == null) {
                        throw new CSSParseException("Invalid attribute simpleSelectors");
                    }
                    this.skipWhitespace();
                    AttribOp op = null;
                    if (this.consume('=')) {
                        op = AttribOp.EQUALS;
                    } else if (this.consume("~=")) {
                        op = AttribOp.INCLUDES;
                    } else if (this.consume("|=")) {
                        op = AttribOp.DASHMATCH;
                    }
                    if (op != null) {
                        this.skipWhitespace();
                        attrValue = this.nextAttribValue();
                        if (attrValue == null) {
                            throw new CSSParseException("Invalid attribute simpleSelectors");
                        }
                        this.skipWhitespace();
                    }
                    if (!this.consume(']')) {
                        throw new CSSParseException("Invalid attribute simpleSelectors");
                    }
                    selectorPart.addAttrib(attrName, op == null ? AttribOp.EXISTS : op, attrValue);
                    selector.addedAttributeOrPseudo();
                    continue;
                }
                if (!this.consume(':')) break;
                if (selectorPart == null) {
                    selectorPart = new SimpleSelector(combinator, null);
                }
                this.parsePseudoClass(selector, selectorPart);
            }
            if (selectorPart != null) {
                selector.add(selectorPart);
                return true;
            }
            this.position = start;
            return false;
        }

        private AnPlusB nextAnPlusB() throws CSSParseException {
            AnPlusB result;
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            if (this.consume("odd")) {
                result = new AnPlusB(2, 1);
            } else if (this.consume("even")) {
                result = new AnPlusB(2, 0);
            } else {
                int aSign = 1;
                int bSign = 1;
                if (!this.consume('+') && this.consume('-')) {
                    bSign = -1;
                }
                IntegerParser a = null;
                IntegerParser b = IntegerParser.parseInt(this.input, this.position, this.inputLength, false);
                if (b != null) {
                    this.position = b.getEndPos();
                }
                if (this.consume('n') || this.consume('N')) {
                    a = b != null ? b : new IntegerParser(1L, this.position);
                    aSign = bSign;
                    b = null;
                    bSign = 1;
                    this.skipWhitespace();
                    boolean hasB = this.consume('+');
                    if (!hasB && (hasB = this.consume('-'))) {
                        bSign = -1;
                    }
                    if (hasB) {
                        this.skipWhitespace();
                        b = IntegerParser.parseInt(this.input, this.position, this.inputLength, false);
                        if (b != null) {
                            this.position = b.getEndPos();
                        } else {
                            this.position = start;
                            return null;
                        }
                    }
                }
                result = new AnPlusB(a == null ? 0 : aSign * a.value(), b == null ? 0 : bSign * b.value());
            }
            this.skipWhitespace();
            if (this.consume(')')) {
                return result;
            }
            this.position = start;
            return null;
        }

        private List<String> nextIdentListParam() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            ArrayList<String> result = null;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            do {
                String ident;
                if ((ident = this.nextIdentifier()) == null) {
                    this.position = start;
                    return null;
                }
                if (result == null) {
                    result = new ArrayList<String>();
                }
                result.add(ident);
                this.skipWhitespace();
            } while (this.skipCommaWhitespace());
            if (this.consume(')')) {
                return result;
            }
            this.position = start;
            return null;
        }

        private List<Selector> nextPseudoNotParam() throws CSSParseException {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            if (!this.consume('(')) {
                return null;
            }
            this.skipWhitespace();
            List<Selector> result = this.nextSelectorGroup();
            if (result == null) {
                this.position = start;
                return null;
            }
            if (!this.consume(')')) {
                this.position = start;
                return null;
            }
            block0: for (Selector selector : result) {
                if (selector.simpleSelectors == null) break;
                for (SimpleSelector simpleSelector : selector.simpleSelectors) {
                    if (simpleSelector.pseudos == null) continue block0;
                    for (PseudoClass pseudo : simpleSelector.pseudos) {
                        if (!(pseudo instanceof PseudoClassNot)) continue;
                        return null;
                    }
                }
            }
            return result;
        }

        private void parsePseudoClass(Selector selector, SimpleSelector selectorPart) throws CSSParseException {
            String ident = this.nextIdentifier();
            if (ident == null) {
                throw new CSSParseException("Invalid pseudo class");
            }
            PseudoClass pseudo = null;
            PseudoClassIdents identEnum = PseudoClassIdents.fromString(ident);
            switch (identEnum) {
                case first_child: {
                    pseudo = new PseudoClassAnPlusB(0, 1, true, false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case last_child: {
                    pseudo = new PseudoClassAnPlusB(0, 1, false, false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case only_child: {
                    pseudo = new PseudoClassOnlyChild(false, null);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case first_of_type: {
                    pseudo = new PseudoClassAnPlusB(0, 1, true, true, selectorPart.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case last_of_type: {
                    pseudo = new PseudoClassAnPlusB(0, 1, false, true, selectorPart.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case only_of_type: {
                    pseudo = new PseudoClassOnlyChild(true, selectorPart.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case root: {
                    pseudo = new PseudoClassRoot();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case empty: {
                    pseudo = new PseudoClassEmpty();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case nth_child: 
                case nth_last_child: 
                case nth_of_type: 
                case nth_last_of_type: {
                    boolean fromStart = identEnum == PseudoClassIdents.nth_child || identEnum == PseudoClassIdents.nth_of_type;
                    boolean ofType = identEnum == PseudoClassIdents.nth_of_type || identEnum == PseudoClassIdents.nth_last_of_type;
                    AnPlusB ab = this.nextAnPlusB();
                    if (ab == null) {
                        throw new CSSParseException("Invalid or missing parameter section for pseudo class: " + ident);
                    }
                    pseudo = new PseudoClassAnPlusB(ab.a, ab.b, fromStart, ofType, selectorPart.tag);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case not: {
                    List<Selector> notSelectorGroup = this.nextPseudoNotParam();
                    if (notSelectorGroup == null) {
                        throw new CSSParseException("Invalid or missing parameter section for pseudo class: " + ident);
                    }
                    pseudo = new PseudoClassNot(notSelectorGroup);
                    selector.specificity = ((PseudoClassNot)pseudo).getSpecificity();
                    break;
                }
                case target: {
                    pseudo = new PseudoClassTarget();
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case lang: {
                    List<String> langs = this.nextIdentListParam();
                    pseudo = new PseudoClassNotSupported(ident);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                case link: 
                case visited: 
                case hover: 
                case active: 
                case focus: 
                case enabled: 
                case disabled: 
                case checked: 
                case indeterminate: {
                    pseudo = new PseudoClassNotSupported(ident);
                    selector.addedAttributeOrPseudo();
                    break;
                }
                default: {
                    throw new CSSParseException("Unsupported pseudo class: " + ident);
                }
            }
            selectorPart.addPseudo(pseudo);
        }

        private String nextAttribValue() {
            if (this.empty()) {
                return null;
            }
            String result = this.nextQuotedString();
            if (result != null) {
                return result;
            }
            return this.nextIdentifier();
        }

        String nextPropertyValue() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            int lastValidPos = this.position;
            int ch = this.input.charAt(this.position);
            while (ch != -1 && ch != 59 && ch != 125 && ch != 33 && !this.isEOL(ch)) {
                if (!this.isWhitespace(ch)) {
                    lastValidPos = this.position + 1;
                }
                ch = this.advanceChar();
            }
            if (this.position > start) {
                return this.input.substring(start, lastValidPos);
            }
            this.position = start;
            return null;
        }

        String nextCSSString() {
            int ch;
            if (this.empty()) {
                return null;
            }
            int endQuote = ch = this.input.charAt(this.position);
            if (ch != 39 && ch != 34) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            ++this.position;
            ch = this.nextChar();
            while (ch != -1 && ch != endQuote) {
                if (ch == 92) {
                    ch = this.nextChar();
                    if (ch == -1) continue;
                    if (ch == 10 || ch == 13 || ch == 12) {
                        ch = this.nextChar();
                        continue;
                    }
                    int hc = this.hexChar(ch);
                    if (hc != -1) {
                        int codepoint = hc;
                        for (int i = 1; i <= 5 && (hc = this.hexChar(ch = this.nextChar().intValue())) != -1; ++i) {
                            codepoint = codepoint * 16 + hc;
                        }
                        sb.append((char)codepoint);
                        continue;
                    }
                }
                sb.append((char)ch);
                ch = this.nextChar();
            }
            return sb.toString();
        }

        private int hexChar(int ch) {
            if (ch >= 48 && ch <= 57) {
                return ch - 48;
            }
            if (ch >= 65 && ch <= 70) {
                return ch - 65 + 10;
            }
            if (ch >= 97 && ch <= 102) {
                return ch - 97 + 10;
            }
            return -1;
        }

        String nextURL() {
            if (this.empty()) {
                return null;
            }
            int start = this.position;
            if (!this.consume("url(")) {
                return null;
            }
            this.skipWhitespace();
            String url = this.nextCSSString();
            if (url == null) {
                url = this.nextLegacyURL();
            }
            if (url == null) {
                this.position = start;
                return null;
            }
            this.skipWhitespace();
            if (this.empty() || this.consume(")")) {
                return url;
            }
            this.position = start;
            return null;
        }

        String nextLegacyURL() {
            char ch;
            StringBuilder sb = new StringBuilder();
            while (!(this.empty() || (ch = this.input.charAt(this.position)) == '\'' || ch == '\"' || ch == '(' || ch == ')' || this.isWhitespace(ch) || Character.isISOControl((int)ch))) {
                ++this.position;
                if (ch == '\\') {
                    if (this.empty() || (ch = this.input.charAt(this.position++)) == '\n' || ch == '\r' || ch == '\f') continue;
                    int hc = this.hexChar(ch);
                    if (hc != -1) {
                        int codepoint = hc;
                        for (int i = 1; i <= 5 && !this.empty() && (hc = this.hexChar(this.input.charAt(this.position))) != -1; ++i) {
                            ++this.position;
                            codepoint = codepoint * 16 + hc;
                        }
                        sb.append((char)codepoint);
                        continue;
                    }
                }
                sb.append(ch);
            }
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }

        private static class AnPlusB {
            public int a;
            public int b;

            AnPlusB(int a, int b) {
                this.a = a;
                this.b = b;
            }
        }
    }

    private static class Selector {
        List<SimpleSelector> simpleSelectors = null;
        int specificity = 0;

        private Selector() {
        }

        void add(SimpleSelector part) {
            if (this.simpleSelectors == null) {
                this.simpleSelectors = new ArrayList<SimpleSelector>();
            }
            this.simpleSelectors.add(part);
        }

        int size() {
            return this.simpleSelectors == null ? 0 : this.simpleSelectors.size();
        }

        SimpleSelector get(int i) {
            return this.simpleSelectors.get(i);
        }

        boolean isEmpty() {
            return this.simpleSelectors == null || this.simpleSelectors.isEmpty();
        }

        void addedIdAttribute() {
            this.specificity += 1000000;
        }

        void addedAttributeOrPseudo() {
            this.specificity += 1000;
        }

        void addedElement() {
            ++this.specificity;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (SimpleSelector sel : this.simpleSelectors) {
                sb.append(sel).append(' ');
            }
            return sb.append('[').append(this.specificity).append(']').toString();
        }
    }

    static class Rule {
        Selector selector = null;
        SVG.Style style = null;
        Source source;

        Rule(Selector selector, SVG.Style style, Source source) {
            this.selector = selector;
            this.style = style;
            this.source = source;
        }

        public String toString() {
            return String.valueOf(this.selector) + " {...} (src=" + (Object)((Object)this.source) + ")";
        }
    }

    static enum Source {
        Document,
        RenderOptions;

    }

    static class Ruleset {
        private List<Rule> rules = null;

        Ruleset() {
        }

        void add(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            for (int i = 0; i < this.rules.size(); ++i) {
                Rule nextRule = this.rules.get(i);
                if (nextRule.selector.specificity <= rule.selector.specificity) continue;
                this.rules.add(i, rule);
                return;
            }
            this.rules.add(rule);
        }

        void addAll(Ruleset rules) {
            if (rules.rules == null) {
                return;
            }
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>(rules.rules.size());
            }
            for (Rule rule : rules.rules) {
                this.add(rule);
            }
        }

        List<Rule> getRules() {
            return this.rules;
        }

        boolean isEmpty() {
            return this.rules == null || this.rules.isEmpty();
        }

        int ruleCount() {
            return this.rules != null ? this.rules.size() : 0;
        }

        void removeFromSource(Source sourceToBeRemoved) {
            if (this.rules == null) {
                return;
            }
            Iterator<Rule> iter = this.rules.iterator();
            while (iter.hasNext()) {
                if (iter.next().source != sourceToBeRemoved) continue;
                iter.remove();
            }
        }

        public String toString() {
            if (this.rules == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (Rule rule : this.rules) {
                sb.append(rule.toString()).append('\n');
            }
            return sb.toString();
        }
    }

    private static class SimpleSelector {
        Combinator combinator = null;
        String tag = null;
        List<Attrib> attribs = null;
        List<PseudoClass> pseudos = null;

        SimpleSelector(Combinator combinator, String tag) {
            this.combinator = combinator != null ? combinator : Combinator.DESCENDANT;
            this.tag = tag;
        }

        void addAttrib(String attrName, AttribOp op, String attrValue) {
            if (this.attribs == null) {
                this.attribs = new ArrayList<Attrib>();
            }
            this.attribs.add(new Attrib(attrName, op, attrValue));
        }

        void addPseudo(PseudoClass pseudo) {
            if (this.pseudos == null) {
                this.pseudos = new ArrayList<PseudoClass>();
            }
            this.pseudos.add(pseudo);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.combinator == Combinator.CHILD) {
                sb.append("> ");
            } else if (this.combinator == Combinator.FOLLOWS) {
                sb.append("+ ");
            }
            sb.append(this.tag == null ? "*" : this.tag);
            if (this.attribs != null) {
                for (Attrib attr : this.attribs) {
                    sb.append('[').append(attr.name);
                    switch (attr.operation) {
                        case EQUALS: {
                            sb.append('=').append(attr.value);
                            break;
                        }
                        case INCLUDES: {
                            sb.append("~=").append(attr.value);
                            break;
                        }
                        case DASHMATCH: {
                            sb.append("|=").append(attr.value);
                            break;
                        }
                    }
                    sb.append(']');
                }
            }
            if (this.pseudos != null) {
                for (PseudoClass pseu : this.pseudos) {
                    sb.append(':').append(pseu);
                }
            }
            return sb.toString();
        }
    }

    private static class Attrib {
        public final String name;
        final AttribOp operation;
        public final String value;

        Attrib(String name, AttribOp op, String value) {
            this.name = name;
            this.operation = op;
            this.value = value;
        }
    }

    private static enum PseudoClassIdents {
        target,
        root,
        nth_child,
        nth_last_child,
        nth_of_type,
        nth_last_of_type,
        first_child,
        last_child,
        first_of_type,
        last_of_type,
        only_child,
        only_of_type,
        empty,
        not,
        lang,
        link,
        visited,
        hover,
        active,
        focus,
        enabled,
        disabled,
        checked,
        indeterminate,
        UNSUPPORTED;

        private static final Map<String, PseudoClassIdents> cache;

        public static PseudoClassIdents fromString(String str) {
            PseudoClassIdents attr = cache.get(str);
            if (attr != null) {
                return attr;
            }
            return UNSUPPORTED;
        }

        static {
            cache = new HashMap<String, PseudoClassIdents>();
            for (PseudoClassIdents attr : PseudoClassIdents.values()) {
                if (attr == UNSUPPORTED) continue;
                String key = attr.name().replace('_', '-');
                cache.put(key, attr);
            }
        }
    }

    private static enum AttribOp {
        EXISTS,
        EQUALS,
        INCLUDES,
        DASHMATCH;

    }

    private static enum Combinator {
        DESCENDANT,
        CHILD,
        FOLLOWS;

    }

    static enum MediaType {
        all,
        aural,
        braille,
        embossed,
        handheld,
        print,
        projection,
        screen,
        speech,
        tty,
        tv;

    }
}

