/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslTopNode;

public class XslVariable
extends XslNode
implements XslTopNode {
    private String _name;
    private String _select;
    private boolean _isGlobal;

    @Override
    public String getTagName() {
        return "xsl:variable";
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = true;
    }

    @Override
    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("select")) {
            this._select = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    public void endAttributes() throws XslParseException {
        if (this._name == null) {
            throw this.error(L.l("'name' is a required attribute of <xsl:variable>"));
        }
    }

    @Override
    public void endElement() {
        this.addVariableCount();
    }

    @Override
    public void generate(JavaWriter out) throws Exception {
        if (this._select != null) {
            int index = this.addExpr(this._select);
            if (this._isGlobal) {
                out.print("env.setGlobal(\"" + this._name + "\", ");
                out.print("_exprs[" + index + "].evalObject(node, env));");
            } else {
                out.print("_exprs[" + index + "]");
                out.println(".addVar(env, \"" + this._name + "\", node, env);");
            }
        } else {
            String id = "frag" + this._gen.generateId();
            out.println("XMLWriter " + id + " = out.pushFragment();");
            this.generateChildren(out);
            if (this._isGlobal) {
                out.print("env.setGlobal(\"");
            } else {
                out.print("env.addVar(\"");
            }
            out.printJavaString(this._name);
            out.println("\", out.popFragment(" + id + "));");
        }
    }

    @Override
    protected void printPopScope(JavaWriter out) throws Exception {
    }
}

