/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.fun;

import com.caucho.vfs.Path;
import com.caucho.xml.CauchoNode;
import com.caucho.xml.LooseHtml;
import com.caucho.xml.QDocument;
import com.caucho.xml.Xml;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.XPathFun;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xsl.TransformerImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class DocumentFun
extends XPathFun {
    private static final Logger log = Logger.getLogger(DocumentFun.class.getName());
    TransformerImpl _transformer;
    boolean _isHtml;

    public DocumentFun(TransformerImpl transformer) {
        this._transformer = transformer;
    }

    public void setHtml(boolean isHtml) {
        this._isHtml = isHtml;
    }

    public Object eval(Node node, ExprEnvironment env, AbstractPattern pattern, ArrayList args) throws XPathException {
        Path path;
        if (args.size() < 1) {
            return null;
        }
        String name = Expr.toString(args.get(0));
        Node basenode = args.size() > 1 ? Expr.toNode(args.get(1)) : Expr.toNode(args.get(0));
        Path stylesheetPath = env.getStylesheetEnv().getPath();
        URIResolver resolver = this._transformer.getURIResolver();
        if (name == null || name.equals("")) {
            name = stylesheetPath.getTail();
        }
        String systemId = null;
        DocumentType dtd = null;
        Document owner = null;
        if (basenode != null) {
            if (basenode.getOwnerDocument() != null) {
                owner = basenode.getOwnerDocument();
                dtd = owner.getDoctype();
            } else if (basenode instanceof Document) {
                owner = (Document)basenode;
                dtd = owner.getDoctype();
            }
        }
        if (basenode instanceof CauchoNode) {
            systemId = ((CauchoNode)basenode).getBaseURI();
        }
        Path pwd = stylesheetPath.getParent();
        if (systemId == null && owner instanceof QDocument) {
            systemId = ((QDocument)owner).getSystemId();
        }
        if (systemId == null && dtd != null) {
            systemId = dtd.getSystemId();
        }
        if (systemId == null) {
            systemId = stylesheetPath.getURL();
        }
        Node doc = null;
        Source source = null;
        if (resolver != null) {
            try {
                source = resolver.resolve(name, systemId);
            }
            catch (TransformerException e) {
                throw new XPathException((Throwable)e);
            }
        }
        if (source != null) {
            systemId = source.getSystemId();
            path = pwd.lookup(systemId);
        } else if (systemId != null) {
            pwd = pwd.lookup(systemId).getParent();
            path = pwd.lookup(name);
        } else {
            path = pwd.lookup(name);
        }
        this._transformer.addCacheDepend(path);
        if (env instanceof Env) {
            doc = (Node)((Env)env).getCache((Object)path);
        }
        if (doc != null) {
            return doc;
        }
        try {
            doc = this._isHtml ? new LooseHtml().parseDocument(path) : new Xml().parseDocument(path);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (env instanceof Env && source == null) {
            ((Env)env).setCache((Object)path, (Object)doc);
        }
        return doc;
    }
}

