/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.ConfigException;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.QServerSocketWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SSLFactory;
import com.caucho.vfs.SelfSignedCert;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class JsseSSLFactory
implements SSLFactory {
    private static final Logger log = Logger.getLogger(JsseSSLFactory.class.getName());
    private static final L10N L = new L10N(JsseSSLFactory.class);
    private static Method _honorCipherOrderMethod;
    private static Method _getSSLParametersMethod;
    private Path _keyStoreFile;
    private String _alias;
    private String _password;
    private String _verifyClient;
    private String _keyStoreType = "jks";
    private String _keyManagerFactory = "SunX509";
    private String _sslContext = "TLS";
    private String[] _cipherSuites;
    private String[] _cipherSuitesForbidden;
    private String[] _protocols;
    private String _selfSignedName;
    private Boolean _isHonorCipherOrder;
    private KeyStore _keyStore;

    public void setCipherSuites(String[] ciphers) {
        this._cipherSuites = ciphers;
    }

    public void setCipherSuitesForbidden(String[] ciphers) {
        this._cipherSuitesForbidden = ciphers;
    }

    public void setKeyStoreFile(Path keyStoreFile) {
        this._keyStoreFile = keyStoreFile;
    }

    public Path getKeyStoreFile() {
        return this._keyStoreFile;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setVerifyClient(String verifyClient) {
        this._verifyClient = verifyClient;
    }

    public String getVerifyClient() {
        return this._verifyClient;
    }

    public void setKeyManagerFactory(String keyManagerFactory) {
        this._keyManagerFactory = keyManagerFactory;
    }

    public void setSelfSignedCertificateName(String name) {
        this._selfSignedName = name;
    }

    public void setSSLContext(String sslContext) {
        this._sslContext = sslContext;
    }

    public void setKeyStoreType(String keyStore) {
        this._keyStoreType = keyStore;
    }

    public void setProtocol(String protocol) {
        this._protocols = protocol.split("[\\s,]+");
    }

    public Boolean getHonorCipherOrder() {
        return this._isHonorCipherOrder;
    }

    public void setHonorCipherOrder(Boolean isHonorCipherOrder) {
        if (_honorCipherOrderMethod == null) {
            log.log(Level.WARNING, "honor-cipher-order requires JDK 1.8");
        }
        this._isHonorCipherOrder = isHonorCipherOrder;
    }

    @PostConstruct
    public void init() throws ConfigException, IOException, GeneralSecurityException {
        if (this._keyStoreFile != null && this._password == null) {
            throw new ConfigException(L.l("'password' is required for JSSE."));
        }
        if (this._password != null && this._keyStoreFile == null) {
            throw new ConfigException(L.l("'key-store-file' is required for JSSE."));
        }
        if (this._alias != null && this._keyStoreFile == null) {
            throw new ConfigException(L.l("'alias' requires a key store for JSSE."));
        }
        if (this._keyStoreFile == null && this._selfSignedName == null) {
            throw new ConfigException(L.l("JSSE requires a key-store-file or a self-signed-certificate-name."));
        }
        if (this._keyStoreFile == null) {
            return;
        }
        this._keyStore = KeyStore.getInstance(this._keyStoreType);
        ReadStream is = this._keyStoreFile.openRead();
        try {
            this._keyStore.load((InputStream)is, this._password.toCharArray());
        }
        finally {
            is.close();
        }
        if (this._alias != null) {
            Key key = this._keyStore.getKey(this._alias, this._password.toCharArray());
            if (key == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding key.", (Object)this._alias));
            }
            Certificate[] certChain = this._keyStore.getCertificateChain(this._alias);
            if (certChain == null) {
                throw new ConfigException(L.l("JSSE alias '{0}' does not have a corresponding certificate chain.", (Object)this._alias));
            }
            this._keyStore = KeyStore.getInstance(this._keyStoreType);
            this._keyStore.load(null, this._password.toCharArray());
            this._keyStore.setKeyEntry(this._alias, key, this._password.toCharArray(), certChain);
        }
    }

    @Override
    public QServerSocket create(InetAddress host, int port) throws IOException, GeneralSecurityException {
        SSLServerSocketFactory factory = null;
        if (this._keyStore != null) {
            SSLContext sslContext = SSLContext.getInstance(this._sslContext);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactory);
            kmf.init(this._keyStore, this._password.toCharArray());
            sslContext.init(kmf.getKeyManagers(), null, null);
            factory = sslContext.getServerSocketFactory();
        } else {
            factory = this.createAnonymousFactory(host, port);
        }
        int listen = 100;
        ServerSocket serverSocket = host == null ? factory.createServerSocket(port, listen) : factory.createServerSocket(port, listen, host);
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        if (this._cipherSuites != null) {
            sslServerSocket.setEnabledCipherSuites(this._cipherSuites);
        }
        if (this._cipherSuitesForbidden != null) {
            String[] cipherSuites = sslServerSocket.getEnabledCipherSuites();
            if (cipherSuites == null) {
                cipherSuites = sslServerSocket.getSupportedCipherSuites();
            }
            ArrayList<String> cipherList = new ArrayList<String>();
            for (String cipher : cipherSuites) {
                if (this.isCipherForbidden(cipher, this._cipherSuitesForbidden)) continue;
                cipherList.add(cipher);
            }
            cipherSuites = new String[cipherList.size()];
            cipherList.toArray(cipherSuites);
            sslServerSocket.setEnabledCipherSuites(cipherSuites);
        }
        if (this._protocols != null) {
            try {
                sslServerSocket.setEnabledProtocols(this._protocols);
            }
            catch (Exception e) {
                throw ConfigException.create((String)L.l("Invalid protocols '{0}', expected from list '{1}'\n  {2}", Arrays.asList(this._protocols), Arrays.asList(sslServerSocket.getSupportedProtocols()), (Object)e.toString()), (Throwable)e);
            }
        }
        if ("required".equals(this._verifyClient)) {
            sslServerSocket.setNeedClientAuth(true);
        } else if ("optional".equals(this._verifyClient)) {
            sslServerSocket.setWantClientAuth(true);
        }
        this.setHonorCipherOrder(sslServerSocket);
        return new QServerSocketWrapper(serverSocket);
    }

    private void setHonorCipherOrder(SSLServerSocket serverSocket) {
        if (this._isHonorCipherOrder == null) {
            return;
        }
        if (_honorCipherOrderMethod == null) {
            return;
        }
        try {
            SSLParameters params = (SSLParameters)_getSSLParametersMethod.invoke((Object)serverSocket, new Object[0]);
            _honorCipherOrderMethod.invoke((Object)params, this._isHonorCipherOrder);
            log.log(Level.FINER, L.l("setting honor-cipher-order {0}", (Object)this._isHonorCipherOrder));
        }
        catch (Throwable t) {
            log.log(Level.WARNING, t.getMessage(), t);
        }
    }

    private boolean isCipherForbidden(String cipher, String[] forbiddenList) {
        for (String forbidden : forbiddenList) {
            if (cipher.indexOf(forbidden) < 0) continue;
            return true;
        }
        return false;
    }

    private SSLServerSocketFactory createAnonymousFactory(InetAddress hostAddr, int port) throws IOException, GeneralSecurityException {
        SelfSignedCert cert;
        SSLContext sslContext = SSLContext.getInstance(this._sslContext);
        String[] cipherSuites = this._cipherSuites;
        String selfSignedName = this._selfSignedName;
        if (selfSignedName == null || "".equals(selfSignedName) || "*".equals(selfSignedName)) {
            if (hostAddr != null) {
                selfSignedName = hostAddr.getHostName();
            } else {
                InetAddress addr = InetAddress.getLocalHost();
                selfSignedName = addr.getHostAddress();
            }
        }
        if ((cert = this.createSelfSignedCert(selfSignedName, cipherSuites)) == null) {
            throw new ConfigException(L.l("Cannot generate anonymous certificate"));
        }
        sslContext.init(cert.getKeyManagers(), null, null);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SelfSignedCert createSelfSignedCert(String name, String[] cipherSuites) {
        Path certPath;
        SelfSignedCert cert;
        Path certDir;
        block11: {
            Path dataDir = RootDirectorySystem.getCurrentDataDirectory();
            certDir = dataDir.lookup("certs");
            cert = null;
            try {
                certPath = certDir.lookup(name + ".cert");
                if (!certPath.canRead()) break block11;
                ReadStream is = certPath.openRead();
                try {
                    Hessian2Input hIn = new Hessian2Input((InputStream)is);
                    cert = (SelfSignedCert)hIn.readObject(SelfSignedCert.class);
                    hIn.close();
                    if (!cert.isExpired()) {
                        SelfSignedCert selfSignedCert = cert;
                        return selfSignedCert;
                    }
                }
                finally {
                    IoUtil.close((InputStream)is);
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        cert = SelfSignedCert.create(name, cipherSuites);
        try {
            certDir.mkdirs();
            certPath = certDir.lookup(name + ".cert");
            WriteStream os = certPath.openWrite();
            try {
                Hessian2Output hOut = new Hessian2Output((OutputStream)os);
                hOut.writeObject((Object)cert);
                hOut.close();
                return cert;
            }
            finally {
                IoUtil.close((OutputStream)os);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return cert;
    }

    @Override
    public QServerSocket bind(QServerSocket ss) throws ConfigException, IOException, GeneralSecurityException {
        throw new ConfigException(L.l("jsse is not allowed here"));
    }

    static {
        try {
            Method method = SSLServerSocket.class.getMethod("getSSLParameters", new Class[0]);
            method.setAccessible(true);
            _getSSLParametersMethod = method;
            method = SSLParameters.class.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            method.setAccessible(true);
            _honorCipherOrderMethod = method;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.getMessage(), e);
        }
    }
}

